/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.management.IRunnableJob;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

public class JobRunner {
    private final IRunnableJob job;
    private boolean wasSuspendend;
    private boolean wasStarted;
    private final IProgressMonitor cancelationMonitor = new CancelationProgressMonitor();
    private Future<IStatus> runningJob;

    public JobRunner(IRunnableJob job) {
        this.job = job;
    }

    public void runJob() {
        if (this.job.isStarted()) {
            this.wasStarted = true;
        } else if (Job.getJobManager().isSuspended()) {
            this.wasSuspendend = true;
            JobCallable callable = new JobCallable(this.job, this.cancelationMonitor);
            this.runningJob = InternalAPI.getExecutor().submit(callable);
        } else {
            this.job.schedule();
        }
    }

    public void runJob(long delay) {
        if (this.job.isStarted()) {
            this.wasStarted = true;
        } else if (Job.getJobManager().isSuspended()) {
            this.wasSuspendend = true;
            JobCallable callable = new JobCallable(this.job, this.cancelationMonitor);
            this.runningJob = InternalAPI.getScheduled().schedule(callable, delay, TimeUnit.MILLISECONDS);
        } else {
            this.job.schedule(delay);
        }
    }

    public void cancel() {
        if (this.wasSuspendend) {
            if (!this.runningJob.isCancelled() && !this.runningJob.isDone()) {
                this.cancelationMonitor.setCanceled(true);
                boolean interrupted = false;
                try {
                    while (true) {
                        try {
                            this.runningJob.get();
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (InterruptedException interruptedException) {
                            interrupted = true;
                            continue;
                        }
                        catch (ExecutionException e) {
                            Throwable t = e.getCause() == null ? e : e.getCause();
                            throw new RuntimeException(t);
                        }
                        break;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        } else {
            this.job.cancel();
            try {
                this.job.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobStart() {
        if (!this.wasStarted) {
            Object sync;
            Object object = sync = this.job.getSync();
            synchronized (object) {
                boolean interrupted = false;
                while (!this.job.isStarted() && !this.job.isFinished()) {
                    try {
                        this.job.getSync().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class CancelationProgressMonitor
    implements IProgressMonitor {
        boolean canceled = false;

        private CancelationProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean value) {
            this.canceled = value;
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }

    private static class JobCallable
    implements Callable<IStatus> {
        private final IRunnableJob job;
        private final IProgressMonitor cancelationMonitor;

        public JobCallable(IRunnableJob job, IProgressMonitor cancelationMonitor) {
            this.job = job;
            this.cancelationMonitor = cancelationMonitor;
        }

        @Override
        public IStatus call() throws Exception {
            try {
                Job.getJobManager().beginRule(this.job.getRule(), this.cancelationMonitor);
                IStatus iStatus = this.job.run(this.cancelationMonitor);
                return iStatus;
            }
            finally {
                Job.getJobManager().endRule(this.job.getRule());
            }
        }
    }
}

