/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.bplustree.db.ExtentManager;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IdentityLinkedSet;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.management.ReferenceStatus;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.InternalSearchPattern;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.internal.util.Util;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class InternalReference
extends InternalReferenceObject {
    public static final InternalReference NULL = new InternalReference(null, null){};
    final Record record;
    List<LinkKey> originalKeys;
    InternalReference snapshot;
    BrokenStatus broken = BrokenStatus.NOTBROKEN;
    int linkId = -1;
    int nextReferenceId = -1;
    protected int referenceType;
    int[][] parameters;
    int fOffset;
    int fLength;
    int fLine;
    protected boolean crossProject;
    private TempReferenceInfo info;

    public InternalReference(ILink link, String referenceType) {
        this.record = new Record(this);
        this.record.dirty = true;
        this.referenceType = ReferenceGeneratorService.getInstance().getReferenceTypeId(referenceType);
        this.markLoaded();
        if (link != null && referenceType != null) {
            Assert.isNotNull((Object)link, (String)Messages.InternalReference_0);
            Assert.isNotNull((Object)referenceType, (String)Messages.InternalReference_1);
            Assert.isLegal((link.getId() != -1 ? 1 : 0) != 0, (String)Messages.InternalReference_2);
            this.linkId = link.getId();
        }
    }

    public InternalReference() {
        this.record = null;
    }

    public TextRange getFragmentLocation() {
        this.loadData();
        return new TextRange(this.fOffset, this.fLength, this.fLine);
    }

    public TextRange getAbsoluteFragmentLocation() {
        this.loadData();
        TextRange absRange = new TextRange(this.fOffset + this.getSource().getLinkLocation().getOffset(), this.fLength, this.fLine);
        return absRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFragmentLocation(TextRange fragmentLocation) {
        boolean equal;
        this.loadData();
        ILink source = this.getSource();
        if (source == null) {
            Assert.isNotNull((Object)source, (String)Messages.InternalReference_3);
            return;
        }
        if (fragmentLocation == null) {
            String link;
            try {
                link = source.toString();
                link = source.getContextText();
            }
            catch (Exception exception) {
                link = "null";
            }
            Assert.isNotNull((Object)fragmentLocation, (String)NLS.bind((String)Messages.errorMsg_fragment_can_not_be_null_link_X, (Object)link));
            return;
        }
        TextRange absRange = new TextRange(fragmentLocation.getOffset() + source.getLinkLocation().getOffset(), fragmentLocation.getLength(), fragmentLocation.getLinenumber());
        if (!source.getLinkLocation().contains(absRange)) {
            String link = source.toString();
            try {
                link = source.getContextText();
            }
            catch (Exception exception) {
                link = "null";
            }
            String error = NLS.bind((String)Messages.errorMsg_link_range_X_does_not_contain_Y_link_Z, (Object[])new String[]{source.getLinkLocation().toString(), fragmentLocation.toString(), link});
            Assert.isLegal((boolean)false, (String)error);
        }
        Object object = this.record;
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getFragmentLocation(), fragmentLocation);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().fragmentLocation = fragmentLocation;
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    private TempReferenceInfo getInfo() {
        if (this.info == null) {
            this.info = new TempReferenceInfo();
        }
        return this.info;
    }

    @Override
    public int getId() {
        return super.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFrom(InternalReference other) {
        this.loadData();
        Record record = this.record;
        synchronized (record) {
            Assert.isNotNull((Object)other.getSource(), (String)Messages.errorMsg_reference_source_can_not_be_null);
            if (this.linkId != other.linkId) {
                this.linkId = other.linkId;
                this.record.dirty = true;
            }
            if (!Util.isEqualOrBothNull(this.getReferenceType(), this.getReferenceType())) {
                this.referenceType = other.referenceType;
                this.record.dirty = true;
            }
            if (!Arrays.deepEquals((Object[])this.getParametersArray(), (Object[])other.getParametersArray())) {
                this.parameters = null;
                this.getInfo().tempParams = other.getParametersArray();
                this.record.dirty = true;
            }
        }
        this.setNextReference(other.getNextReference());
    }

    @Override
    public final IReferenceElement.ElementType getElementType() {
        return IReferenceElement.ElementType.REFERENCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextReference(Reference nextReference) {
        boolean equal;
        this.loadData();
        Reference n = this.getNextReference();
        Object object = this.record;
        synchronized (object) {
            equal = Util.isEqualOrBothNull(n, nextReference);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                if (nextReference == null) {
                    this.nextReferenceId = -1;
                    this.getInfo().tempNextReference = null;
                } else if (nextReference.getId() >= 0) {
                    this.nextReferenceId = nextReference.getId();
                } else {
                    this.getInfo().tempNextReference = nextReference;
                }
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    protected String getCachingKey() {
        ILink s;
        int n;
        this.loadData();
        StringBuilder b = new StringBuilder();
        b.append(this.getReferenceType());
        b.append(":");
        String[][] params = this.getParametersArray();
        if (params != null) {
            String[][] stringArray = params;
            n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String[] entry = stringArray[n2];
                b.append(entry[0]);
                b.append(entry[1]);
                ++n2;
            }
        }
        if ((s = this.getSource()) != null) {
            b.append(s.getName());
            String[][] params2 = ((Link)s).getParameters();
            if (params2 != null) {
                String[][] stringArray = params2;
                int n3 = params2.length;
                n = 0;
                while (n < n3) {
                    String[] entry = stringArray[n];
                    b.append(entry[0]);
                    b.append(entry[1]);
                    ++n;
                }
            }
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference getNextReference() {
        this.loadData();
        Record record = this.record;
        synchronized (record) {
            if (this.info != null && this.info.tempNextReference != null) {
                Assert.isTrue((boolean)this.record.dirty, (String)Messages.InternalReference_5);
                return this.info.tempNextReference;
            }
        }
        int id = this.nextReferenceId;
        if (id >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(id, Reference.class);
        }
        return null;
    }

    public ILink getSource() {
        this.loadData();
        int id = this.linkId;
        if (id >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(id, ILink.class);
        }
        return null;
    }

    public String getReferenceType() {
        this.loadData();
        return ReferenceGeneratorService.getInstance().getReferenceType(this.referenceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String key, String value) {
        this.loadData();
        Record record = this.record;
        synchronized (record) {
            if (this.info == null) {
                this.info = new TempReferenceInfo();
            }
            if (this.info.tempParams == null) {
                this.info.tempParams = new String[1][];
                this.info.tempParams[0] = new String[]{key, value};
            } else {
                String[][] oldParams = this.info.tempParams;
                String[][] newParams = new String[oldParams.length + 1][];
                System.arraycopy(oldParams, 0, newParams, 0, oldParams.length);
                newParams[this.info.tempParams.length] = new String[]{key, value};
                this.info.tempParams = newParams;
            }
            Arrays.sort(this.info.tempParams, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (((String[])o1)[0] == null && ((String[])o2)[0] == null) {
                        return 0;
                    }
                    if (((String[])o1)[0] == null && ((String[])o2)[0] != null) {
                        return -1;
                    }
                    if (((String[])o1)[0] != null && ((String[])o2)[0] == null) {
                        return 1;
                    }
                    return ((String[])o1)[0].compareTo(((String[])o2)[0]);
                }
            });
            this.record.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String key) {
        int i;
        String t;
        this.loadData();
        int keyIndex = ReferenceDatabase.getDefault().lookupKey(key);
        int paramIndex = -1;
        Record record = this.record;
        synchronized (record) {
            t = this.getTempParam(key);
            if (t == null) {
                paramIndex = this.getSavedParamStringIndex(keyIndex);
            }
        }
        if (t != null) {
            return t;
        }
        if (paramIndex < 0) {
            return null;
        }
        Record record2 = this.record;
        synchronized (record2) {
            i = this.parameters[paramIndex][1];
        }
        return ReferenceDatabase.getDefault().getString(i);
    }

    String getTempParam(String key) {
        if (this.info != null && this.info.tempParams != null) {
            int idx = Arrays.binarySearch(this.info.tempParams, key, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((String[])o1)[0].compareTo((String)o2);
                }
            });
            if (idx >= 0) {
                return this.info.tempParams[idx][1];
            }
            return null;
        }
        return null;
    }

    int getSavedParamStringIndex(int keyIndex) {
        if (this.parameters != null) {
            if (keyIndex == -1) {
                return -1;
            }
            int idx = Arrays.binarySearch(this.parameters, keyIndex, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((int[])o1)[0] - (Integer)o2;
                }
            });
            return idx;
        }
        return -1;
    }

    @Override
    public InternalReferenceRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        if (InternalAPI.LOAD_DATA_FOR_TO_STRING) {
            this.loadData();
        }
        if (this.isSnapshot() || this.record.isFullyLoaded()) {
            String s = "";
            if (this.isSnapshot()) {
                s = String.valueOf(s) + "Snap: ";
            }
            s = String.valueOf(s) + this.getElementType().name() + super.toString() + " TYPE: " + this.getReferenceType();
            s = String.valueOf(s) + " source: ";
            s = String.valueOf(s) + this.linkId;
            s = String.valueOf(s) + " nextRef: ";
            s = String.valueOf(s) + this.nextReferenceId;
            if (this.parameters != null) {
                s = String.valueOf(s) + " " + this.parameters.length + " Saved parameters: ";
                int[][] nArray = this.parameters;
                int n = this.parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    int[] entry = nArray[n2];
                    s = String.valueOf(s) + "[" + ReferenceDatabase.getDefault().getString(entry[0]) + "]=[" + ReferenceDatabase.getDefault().getString(entry[1]) + "], ";
                    ++n2;
                }
            }
            s = String.valueOf(s) + "Broken status: " + (Object)((Object)this.getBrokenStatus());
            s = String.valueOf(s) + " CrossProject: " + this.crossProject;
            if (this.info != null) {
                s = String.valueOf(s) + " [[" + this.info.toString() + "]]";
            }
            if (this.providerId >= 0) {
                s = String.valueOf(s) + " Provided by: " + Service.getProviderType(this.providerId) + "(" + Service.getProviderClass(this.providerId) + ")";
            }
            return s;
        }
        String s = String.valueOf(this.getElementType().name()) + " Proxy object: " + super.toString();
        return s;
    }

    @Override
    public boolean isSnapshot() {
        return false;
    }

    @Override
    public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
        Reference nextReference;
        this.loadData();
        if (graph.contains(this)) {
            return;
        }
        ILink source = this.getSource();
        if (source != null) {
            ((InternalReferenceObject)((Object)source)).getObjectGraph(graph, objMarkers);
            graph.add((InternalReferenceObject)((Object)source));
        }
        if ((nextReference = this.getNextReference()) != null) {
            ((InternalReferenceObject)nextReference).getObjectGraph(graph, objMarkers);
            graph.add(nextReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOriginal() {
        if (this.getId() == -1) {
            return;
        }
        this.loadData();
        InternalReference internalReference = this;
        synchronized (internalReference) {
            if (this.frozen) {
                if (this.originalKeys == null) {
                    this.originalKeys = IndexManager.getKeys(this);
                }
                if (this.snapshot == null) {
                    this.snapshot = this.snapshot((Map)new HashMap(1, 1.0f));
                }
            }
        }
    }

    public Set<IResolvedReference> resolve() {
        SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(this.getId()), IndexConstants.BY_REFERENCE_ID, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        SearchScope scope = SearchEngine.createWorkspaceScope();
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, req, null);
        return req.getMatches();
    }

    @Override
    protected synchronized List<LinkKey> getOriginalKeys() {
        return this.originalKeys;
    }

    public BrokenStatus getBrokenStatus() {
        this.loadData();
        return this.broken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokenStatus(BrokenStatus status) {
        boolean equal;
        this.loadData();
        Object object = this.record;
        synchronized (object) {
            equal = this.getBrokenStatus() == status;
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.broken = status;
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    public String getFragmentText() {
        this.loadData();
        ILink source = this.getSource();
        if (source == null) {
            throw new ReferenceException(new ReferenceStatus(4, 101, null));
        }
        int offset = this.getFragmentLocation().getOffset();
        int length = this.getFragmentLocation().getLength();
        if (length == 0) {
            return "";
        }
        if (source.getLinkText() == null) {
            return "";
        }
        return source.getLinkText().substring(offset, offset + length);
    }

    public String[][] getParametersArray() {
        int i;
        this.loadData();
        int size = (this.parameters == null ? 0 : this.parameters.length) + (this.info == null || this.info.tempParams == null ? 0 : this.info.tempParams.length);
        String[][] params = new String[size][];
        int count = -1;
        if (this.info != null && this.info.tempParams != null) {
            i = 0;
            while (i < this.info.tempParams.length) {
                String[] string = this.info.tempParams[i];
                params[++count] = string;
                ++i;
            }
        }
        if (this.parameters != null) {
            i = 0;
            while (i < this.parameters.length) {
                int[] ints = this.parameters[i];
                params[++count] = new String[]{ReferenceDatabase.getDefault().getString(ints[0]), ReferenceDatabase.getDefault().getString(ints[1])};
                ++i;
            }
        }
        Arrays.sort(params, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (((String[])o1)[0] == null && ((String[])o2)[0] == null) {
                    return 0;
                }
                if (((String[])o1)[0] == null && ((String[])o2)[0] != null) {
                    return -1;
                }
                if (((String[])o1)[0] != null && ((String[])o2)[0] == null) {
                    return 1;
                }
                return ((String[])o1)[0].compareTo(((String[])o2)[0]);
            }
        });
        return params;
    }

    @Override
    protected synchronized void clearOriginalKeys() {
        this.originalKeys = null;
        this.snapshot = null;
    }

    @Override
    public InternalReference snapshot(Map<IReferenceElement, IReferenceElement> snapMap) {
        Reference next;
        if (!InternalAPI.Tweaks.SHOULD_USE_SNAPSHOT) {
            return this;
        }
        InternalReference snap = (InternalReference)snapMap.get(this);
        if (snap != null) {
            return snap;
        }
        ILink source = this.getSource();
        if (source != null) {
            ((Link)source).snapshot((Map)snapMap);
        }
        if ((next = this.getNextReference()) != null) {
            next.snapshot((Map)snapMap);
        }
        snap = new InternalReferenceSnapshot(this.getId(), (ILink)snapMap.get(source), ReferenceGeneratorService.getInstance().getReferenceTypeId(this.getReferenceType()), this.getParametersArray(), (Reference)snapMap.get(next), this.crossProject);
        snapMap.put(this, snap);
        return snap;
    }

    @Override
    protected InternalReference getOriginal() {
        return this.snapshot;
    }

    public boolean isCrossProject() {
        this.loadData();
        return this.crossProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrossProject(boolean crossProject) {
        boolean equal;
        this.loadData();
        Object object = this.record;
        synchronized (object) {
            this.loadData();
            equal = this.isCrossProject() == crossProject;
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.crossProject = crossProject;
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    static class InternalReferenceSnapshot
    extends Reference {
        private final int id;
        private final String[][] params;
        private final ILink source;
        private final Reference next;

        public InternalReferenceSnapshot(int id, ILink source, int referenceType, String[][] params, Reference next, boolean crossProject) {
            super(null, null);
            this.id = id;
            this.source = source;
            this.referenceType = referenceType;
            this.params = params;
            this.next = next;
            this.crossProject = crossProject;
        }

        @Override
        public void addParameter(String key, String value) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        protected void clearOriginalKeys() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        protected void copyFrom(InternalReference other) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public TextRange getAbsoluteFragmentLocation() {
            return super.getAbsoluteFragmentLocation();
        }

        @Override
        public BrokenStatus getBrokenStatus() {
            return super.getBrokenStatus();
        }

        @Override
        protected String getCachingKey() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public TextRange getFragmentLocation() {
            return super.getFragmentLocation();
        }

        @Override
        public boolean isSnapshot() {
            return true;
        }

        @Override
        public String getFragmentText() {
            return super.getFragmentText();
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public Reference getNextReference() {
            return this.next;
        }

        @Override
        public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public InternalReference snapshot(Map<IReferenceElement, IReferenceElement> snapMap) {
            return this;
        }

        @Override
        protected List<LinkKey> getOriginalKeys() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public String getParameter(String key) {
            int idx = Arrays.binarySearch(this.params, key, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((String[])o1)[0].compareTo((String)o2);
                }
            });
            if (idx >= 0) {
                return this.params[idx][1];
            }
            return null;
        }

        @Override
        public String[][] getParametersArray() {
            return this.params;
        }

        @Override
        public InternalReferenceRecord getRecord() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public String getReferenceType() {
            return super.getReferenceType();
        }

        @Override
        public ILink getSource() {
            return this.source;
        }

        @Override
        public Set<IResolvedReference> resolve() {
            return super.resolve();
        }

        @Override
        public void setBrokenStatus(BrokenStatus status) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setFragmentLocation(TextRange fragmentLocation) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setNextReference(Reference nextReference) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public void freeze() {
        }

        @Override
        public void init(ExtentManager manager) {
        }

        @Override
        protected boolean isFrozen() {
            return true;
        }

        @Override
        public void loadData() {
        }

        @Override
        public void markLoaded() {
        }
    }

    static class Record
    extends InternalReferenceRecord {
        private final InternalReference reference;
        public boolean dirty;

        public Record(InternalReference reference) {
            super(IReferenceElement.ElementType.REFERENCE.ordinal());
            this.reference = reference;
        }

        @Override
        protected void aboutToUpdate(ReferenceEvent.Kind kind) {
            if (this.reference.info == null) {
                return;
            }
            int size = ((InternalReference)this.reference).info.tempParams == null ? 0 : ((InternalReference)this.reference).info.tempParams.length;
            int[][] params = new int[size][];
            int c = -1;
            if (this.reference.info != null && ((InternalReference)this.reference).info.tempParams != null) {
                int i = 0;
                while (i < ((InternalReference)this.reference).info.tempParams.length) {
                    String[] stringEntry = ((InternalReference)this.reference).info.tempParams[i];
                    params[++c] = new int[]{ReferenceDatabase.getDefault().addString(stringEntry[0]), ReferenceDatabase.getDefault().addString(stringEntry[1])};
                    ++i;
                }
            }
            int len = this.reference.parameters == null ? 0 : this.reference.parameters.length;
            int[] list = new int[len * 2];
            int j = -1;
            int i = 0;
            while (i < len) {
                list[++j] = this.reference.parameters[i][0];
                list[++j] = this.reference.parameters[i][1];
                ++i;
            }
            ReferenceDatabase.getDefault().removeStrings(list);
            Arrays.sort(params, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((int[])o1)[0] - ((int[])o2)[0];
                }
            });
            this.reference.parameters = (int[][])(params.length == 0 ? null : (int[][])params);
            if (((InternalReference)this.reference).info.tempNextReference != null) {
                this.reference.nextReferenceId = ((InternalReference)this.reference).info.tempNextReference.getId();
            }
            if (((InternalReference)this.reference).info.fragmentLocation != null) {
                this.reference.fOffset = ((InternalReference)this.reference).info.fragmentLocation.getOffset();
                this.reference.fLength = ((InternalReference)this.reference).info.fragmentLocation.getLength();
                this.reference.fLine = ((InternalReference)this.reference).info.fragmentLocation.getLinenumber();
            }
            this.reference.info = null;
        }

        @Override
        protected int[] getStringIds() {
            this.loadData();
            int len = this.reference.parameters == null ? 0 : this.reference.parameters.length;
            int[] list = new int[len * 2];
            int j = -1;
            int i = 0;
            while (i < len) {
                list[++j] = this.reference.parameters[i][0];
                list[++j] = this.reference.parameters[i][1];
                ++i;
            }
            return list;
        }

        @Override
        public void doReadRecord(PooledByteBuffer bytes) {
            this.reference.linkId = ByteUtils.bytesToInt(bytes.buffer);
            this.reference.broken = BrokenStatus.values()[ByteUtils.bytesToUnsignedShort(bytes.buffer)];
            TextRange range = new TextRange(0, 0, 0);
            range.readRecord(new PooledByteBuffer(bytes.buffer));
            this.reference.fOffset = range.getOffset();
            this.reference.fLength = range.getLength();
            this.reference.fLine = range.getLinenumber();
            this.reference.nextReferenceId = ByteUtils.bytesToInt(bytes.buffer);
            this.reference.referenceType = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            int parameterSize = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            this.reference.parameters = new int[parameterSize][];
            int i = 0;
            while (i < parameterSize) {
                int k = ByteUtils.bytesToInt(bytes.buffer);
                int v = ByteUtils.bytesToInt(bytes.buffer);
                this.reference.parameters[i] = new int[]{k, v};
                ++i;
            }
            this.reference.providerId = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            this.reference.crossProject = ByteUtils.bytesToBoolean(bytes.buffer);
            bytes.returnBuffer();
            this.clean();
            this.reference.freeze();
        }

        @Override
        public PooledByteBuffer doWriteRecord() {
            Object object;
            Assert.isTrue((this.reference.linkId != -1 ? 1 : 0) != 0);
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            buffers.add(ByteUtils.intToBytes(this.reference.linkId));
            buffers.add(ByteUtils.unsignedShortToBytes(this.reference.broken.ordinal()));
            TextRange range = this.reference.getFragmentLocation();
            PooledByteBuffer buffer = range.writeRecord();
            buffers.add(buffer.copy());
            buffer.returnBuffer();
            buffers.add(ByteUtils.intToBytes(this.reference.nextReferenceId));
            buffers.add(ByteUtils.unsignedShortToBytes(this.reference.referenceType));
            if (this.reference.parameters == null || this.reference.parameters.length == 0) {
                buffers.add(ByteUtils.unsignedShortToBytes(0));
            } else {
                buffers.add(ByteUtils.unsignedShortToBytes(this.reference.parameters.length));
                object = this.reference.parameters;
                int n = this.reference.parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    int[] paramEntry = object[n2];
                    buffers.add(ByteUtils.intToBytes(paramEntry[0]));
                    buffers.add(ByteUtils.intToBytes(paramEntry[1]));
                    ++n2;
                }
            }
            buffers.add(ByteUtils.unsignedShortToBytes(this.reference.providerId));
            buffers.add(ByteUtils.booleanToBytes(this.reference.crossProject));
            int size = 0;
            for (ByteBuffer byteBuffer : buffers) {
                size += byteBuffer.limit();
            }
            PooledByteBuffer payload = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
            object = buffers.iterator();
            while (object.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)object.next();
                payload.buffer.put(byteBuffer);
            }
            payload.buffer.rewind();
            return payload;
        }

        @Override
        public int getSize() {
            int size = 21 + 8 * (this.reference.parameters == null ? 0 : this.reference.parameters.length);
            return size;
        }

        @Override
        protected void clean() {
            this.dirty = false;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        protected InternalReferenceObject getLinkArtifact() {
            return this.reference;
        }

        @Override
        protected Collection<? extends IReferenceElement> getDeleteCascade() {
            SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(this.reference.getId()), IndexConstants.BY_REFERENCE_ID, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
            SearchScope scope = SearchEngine.createWorkspaceScope();
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            new SearchEngine().search(pattern, scope, req, null);
            return req.getMatches();
        }
    }

    static class TempReferenceInfo {
        String[][] tempParams;
        Reference tempNextReference;
        public TextRange fragmentLocation;

        TempReferenceInfo() {
        }

        public String toString() {
            return "TempReferenceInfo [fragmentLocation=" + this.fragmentLocation + ", tempNextReference=" + this.tempNextReference + ", tempParams=" + Arrays.deepToString((Object[])this.tempParams) + "]";
        }
    }
}

