/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.bplustree.db.Persistable;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.management.BrokenReferenceData;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.TextRange;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InternalBrokenReference
implements Persistable {
    private BrokenReferenceData data;

    public InternalBrokenReference(BrokenReferenceData data) {
        this.data = data;
    }

    public TextRange getBrokenReferenceRange() {
        return this.data.brokenReferenceRange;
    }

    public void setBrokenReferenceRange(TextRange brokenReferenceRange) {
        this.data.brokenReferenceRange = brokenReferenceRange;
    }

    public String getDescription() {
        return this.data.description;
    }

    public void setDescription(String description) {
        this.data.description = description;
    }

    public IResource getResource() {
        return this.data.resource;
    }

    public void setResource(IResource resource) {
        this.data.resource = resource;
    }

    public ILink getSource() {
        return this.data.source;
    }

    public void setSource(ILink source) {
        this.data.source = source;
    }

    public void setPotentialTargets(List<IResolvedReference> potentialTargets) {
        this.data.potentialTargets = potentialTargets;
    }

    public List<IResolvedReference> getPotentialTargets() {
        return this.data.potentialTargets;
    }

    public void setBrokenResolvedReferenceId(int brokenResolvedReferenceId) {
        this.data.brokenResolvedReferenceId = brokenResolvedReferenceId;
    }

    public int getBrokenResolvedReferenceId() {
        return this.data.brokenResolvedReferenceId;
    }

    public String getBrokenText() {
        return this.data.brokenText;
    }

    public void setBrokenText(String brokenText) {
        this.data.brokenText = brokenText;
    }

    public String toString() {
        return String.valueOf(this.getDescription()) + " [" + this.getBrokenText() + "] at [" + this.getBrokenReferenceRange() + "] for link " + this.getSource();
    }

    @Override
    public void readRecord(PooledByteBuffer bytes) {
        int resourceType;
        this.data = new BrokenReferenceData();
        this.data.description = ByteUtils.bytesToString(bytes.buffer);
        this.data.brokenText = ByteUtils.bytesToString(bytes.buffer);
        this.data.brokenResolvedReferenceId = ByteUtils.bytesToInt(bytes.buffer);
        int size = ByteUtils.bytesToInt(bytes.buffer);
        this.data.potentialTargets = new ArrayList<IResolvedReference>(size);
        int i = 0;
        while (i < size) {
            int id = ByteUtils.bytesToInt(bytes.buffer);
            IResolvedReference rr = ReferenceDatabase.getDefault().getReferenceElement(id, IResolvedReference.class);
            if (rr == null) {
                Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "Could not find " + i + "th (out of " + size + ") persisted id: " + id);
            } else {
                this.data.potentialTargets.add(rr);
            }
            ++i;
        }
        if (ByteUtils.bytesToBoolean(bytes.buffer)) {
            this.data.brokenReferenceRange = new TextRange(0, 0, 0);
            this.data.brokenReferenceRange.readRecord(bytes);
        }
        String pathName = (resourceType = ByteUtils.bytesToUnsignedShort(bytes.buffer)) > 0 ? ByteUtils.bytesToString(bytes.buffer) : null;
        IFile res = null;
        if (resourceType == 1) {
            res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathName));
        } else if (resourceType == 2) {
            res = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(pathName));
        } else if (resourceType == 4) {
            res = ResourcesPlugin.getWorkspace().getRoot().getProject(pathName);
        } else if (resourceType != -1) {
            Assert.isLegal((boolean)false, (String)"Unknown resource type");
        }
        this.data.resource = res;
        this.data.source = ReferenceDatabase.getDefault().getReferenceElement(ByteUtils.bytesToInt(bytes.buffer), ILink.class);
    }

    @Override
    public PooledByteBuffer writeRecord() {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        buffers.add(ByteUtils.stringToBytes(this.data.description));
        buffers.add(ByteUtils.stringToBytes(this.data.brokenText));
        buffers.add(ByteUtils.intToBytes(this.data.brokenResolvedReferenceId));
        if (this.data.potentialTargets == null) {
            buffers.add(ByteUtils.intToBytes(0));
        } else {
            buffers.add(ByteUtils.intToBytes(this.data.potentialTargets.size()));
            int i = 0;
            while (i < this.data.potentialTargets.size()) {
                buffers.add(ByteUtils.intToBytes(this.data.potentialTargets.get(i).getId()));
                ++i;
            }
        }
        if (this.data.brokenReferenceRange == null) {
            buffers.add(ByteUtils.booleanToBytes(false));
        } else {
            buffers.add(ByteUtils.booleanToBytes(true));
            buffers.add(this.data.brokenReferenceRange.writeRecord().buffer);
        }
        if (this.data.resource == null) {
            buffers.add(ByteUtils.unsignedShortToBytes(0));
        } else {
            buffers.add(ByteUtils.unsignedShortToBytes(this.data.resource.getType()));
            buffers.add(ByteUtils.stringToBytes(this.data.resource.getFullPath().toString()));
        }
        if (this.data.source == null) {
            buffers.add(ByteUtils.intToBytes(-1));
        } else {
            buffers.add(ByteUtils.intToBytes(this.data.source.getId()));
        }
        int size = 0;
        for (ByteBuffer byteBuffer : buffers) {
            size += byteBuffer.limit();
        }
        PooledByteBuffer result = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
        for (ByteBuffer byteBuffer : buffers) {
            result.buffer.put(byteBuffer);
        }
        result.buffer.rewind();
        return result;
    }
}

