/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.internal.management.ErrorRecoveryJob;
import com.ibm.etools.references.internal.management.JobRunner;
import com.ibm.etools.references.internal.nls.Messages;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ErrorRecovery {
    public static final Object STARTUP_ERROR = new Object();
    public static final Object CONVERT_INDEXES_ERROR = new Object();
    public static final Object REBUILD_DB_ERROR = new Object();
    private static AtomicInteger faults = new AtomicInteger(0);
    private static ErrorRecoveryJob job = new ErrorRecoveryJob();
    private static JobRunner runner = new JobRunner(job);
    private static Set<IResource> faultedResources = new HashSet<IResource>();

    public static final void performRecovery(Object causeContext, String friendlyMsg, Exception e, Set<ErrorEvent.PresentationHints> hints) {
        int f;
        IResource resource = ErrorRecovery.getResource(causeContext);
        String ignorePath = null;
        if (resource != null) {
            if (faultedResources.contains(resource)) {
                ignorePath = ErrorRecovery.getIgnorePath(causeContext);
            }
            faultedResources.add(resource);
        }
        if ((f = faults.incrementAndGet()) > 5) {
            InternalAPI.handleFrameworkException(causeContext, friendlyMsg, e, hints, true);
        } else {
            InternalAPI.logReferenceException(friendlyMsg, "com.ibm.etools.references", e, ErrorEvent.Kind.FRAMEWORK_ERROR, Collections.singleton(ErrorEvent.PresentationHints.LOG));
            if (f == 1) {
                Status status = new Status(1, "com.ibm.etools.references", NLS.bind((String)Messages.ErrorRecovery_0, (Object)faults));
                Logger.log(Logger.Category.REFERENCE_MANAGER, Logger.Severity.INFO, Logger.Mode.USER, (IStatus)status);
            } else {
                Status status = new Status(1, "com.ibm.etools.references", NLS.bind((String)Messages.ErrorRecovery_1, (Object)faults));
                Logger.log(Logger.Category.REFERENCE_MANAGER, Logger.Severity.INFO, Logger.Mode.USER, (IStatus)status);
            }
            job.setFaults(f);
            job.setIgnoredPath(ignorePath);
            runner.runJob();
        }
    }

    private static String getIgnorePath(Object cause) {
        IResource r = ErrorRecovery.getResource(cause);
        if (r != null) {
            return r.getFullPath().toString();
        }
        return null;
    }

    private static IResource getResource(Object cause) {
        if (cause instanceof IAdaptable) {
            return (IResource)((IAdaptable)cause).getAdapter(IResource.class);
        }
        return null;
    }

    static void processorFinished(boolean hasUnrecoverableError) {
        if (!hasUnrecoverableError) {
            ErrorRecovery.clearFaultCount();
        }
    }

    public static void clearFaultCount() {
        faults.set(0);
        faultedResources.clear();
    }
}

