/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.internal.management.ItemToIndex;
import com.ibm.etools.references.internal.services.Dependency;
import com.ibm.etools.references.internal.services.LinkDetectorService;
import com.ibm.etools.references.internal.services.LinkNodeModelService;
import com.ibm.etools.references.internal.services.LinkTransformerService;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.services.ReferenceResolverService;
import com.ibm.etools.references.management.SpecializedType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class DependencyUtil {
    private static final LinkTypeRegistry LINKTYPE = LinkTypeRegistry.getInstance();
    private static final LinkDetectorService DETECTOR = LinkDetectorService.getInstance();
    private static final ReferenceResolverService RESOLVER = ReferenceResolverService.getInstance();
    private static final LinkTransformerService TRANSFORMER = LinkTransformerService.getInstance();
    private static final LinkNodeModelService NODEPROVIDER = LinkNodeModelService.getInstance();

    public static int getDepedentLinks(ItemToIndex info, LinkTransformerService.TransformerCache transformerCache) {
        HashSet<SpecializedType> linkIds = new HashSet<SpecializedType>();
        if (info.modelIds != null) {
            for (String modelId : info.modelIds) {
                List<SpecializedType> depIds = DETECTOR.getLinksAvailableForLinkModel(modelId);
                if (depIds != null) {
                    linkIds.addAll(depIds);
                }
                if (!NODEPROVIDER.isTargetOfTypeModel(modelId)) continue;
                return Integer.MAX_VALUE;
            }
        }
        int dependencies = 0;
        for (SpecializedType specializedType : linkIds) {
            IProject project = info.change.getResource().getProject();
            List<Dependency> deps = TRANSFORMER.getDependentLinkIds(specializedType.getId(), project, transformerCache);
            Iterator<Dependency> iterator = deps.iterator();
            while (iterator.hasNext()) {
                Dependency dependency = iterator.next();
                if (!linkIds.contains(LINKTYPE.getLinkType(dependency.linkid))) continue;
                iterator.remove();
            }
            dependencies = Math.max(dependencies, deps.size());
            Map<Dependency, List<String>> rdeps = RESOLVER.getDependentReferenceType(specializedType.getId());
            HashSet<String> allRefTypes = new HashSet<String>();
            for (List<String> refTypes : rdeps.values()) {
                allRefTypes.addAll(refTypes);
            }
            HashSet<SpecializedType> linkTypes = new HashSet<SpecializedType>();
            for (String refType : allRefTypes) {
                linkTypes.addAll(ReferenceGeneratorService.getInstance().getLinkTypesForRef(refType));
            }
            dependencies = Math.max(dependencies, linkTypes.size());
        }
        return dependencies;
    }
}

