/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.ErrorRecovery;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.ReferenceManager;
import java.util.EnumSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ConvertIndexesJob
extends Job {
    private final ReferenceDatabase database;
    private boolean newStyleIsHeap = false;
    private boolean oldStyleIsHeap = false;

    public ConvertIndexesJob(ReferenceDatabase database) {
        super(Messages.errorMsg_linkindexerconvertindexes);
        this.database = database;
        this.setSystem(true);
        this.setPriority(10);
    }

    public boolean belongsTo(Object family) {
        return family == ReferenceManager.class;
    }

    public void setConvertStyle(boolean toHeap) {
        if (this.getState() == 0) {
            this.newStyleIsHeap = toHeap;
            this.schedule();
        }
    }

    public void setConvertStyle(boolean toHeap, boolean force) {
        if (this.getState() == 0) {
            this.newStyleIsHeap = toHeap;
            this.schedule();
        }
    }

    public boolean isUsingHeapIndex() {
        return this.oldStyleIsHeap;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.newStyleIsHeap == this.oldStyleIsHeap) {
                return Status.OK_STATUS;
            }
            long s = System.currentTimeMillis();
            this.database.convertIndexes(this.newStyleIsHeap, monitor);
            long e = System.currentTimeMillis();
            if (Logger.SHOULD_TRACE_TIMING) {
                Logger.trace(Logger.Category.TIMING, "Converted: (style=" + (this.newStyleIsHeap ? "to heap" : "toDisk") + ") in " + (float)(e - s) / 1000.0f + "s", new Throwable[0]);
            }
            this.oldStyleIsHeap = this.newStyleIsHeap;
        }
        catch (RuntimeException e) {
            String friendlyMsg = Messages.errorMsg_fatalerrorwhileconverting;
            InternalAPI.handleFrameworkException(ErrorRecovery.CONVERT_INDEXES_ERROR, friendlyMsg, e, EnumSet.of(ErrorEvent.PresentationHints.LOG, ErrorEvent.PresentationHints.BLOCK), true);
        }
        return Status.OK_STATUS;
    }

    public boolean shouldSchedule() {
        if (this.newStyleIsHeap == this.oldStyleIsHeap) {
            return false;
        }
        return InternalAPI.Tweaks.SHOULD_USE_IN_MEMORY_INDEX;
    }
}

