/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.ThreadPriorityPolicy;
import com.ibm.etools.references.internal.management.IRunnableJob;
import com.ibm.etools.references.internal.management.InternalReferenceManager;
import com.ibm.etools.references.internal.management.JobRunner;
import com.ibm.etools.references.internal.management.MonitorPolicy;
import com.ibm.etools.references.internal.management.Scheduler;
import com.ibm.etools.references.internal.management.SchedulerCondition;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.ResourceChange;
import com.ibm.etools.references.search.SearchScope;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class AddToIndexJob
extends Job
implements IRunnableJob {
    private final Scheduler scheduler;
    private final Queue<SchedulerItem> indexQueue = new ConcurrentLinkedQueue<SchedulerItem>();
    private final AtomicInteger size = new AtomicInteger(0);
    private final AtomicBoolean ready = new AtomicBoolean(true);
    private final Semaphore semaphore;
    private final Object runningSync;
    private volatile boolean started;
    private volatile boolean finished;
    private volatile Thread activeThread;

    public AddToIndexJob(Scheduler scheduler, InternalReferenceManager manager) {
        super(Messages.AddFilesToLinkIndexerQueue);
        this.scheduler = scheduler;
        this.semaphore = new Semaphore(1);
        this.runningSync = new Object();
        this.setPriority(10);
        this.setSystem(true);
    }

    private SchedulerItem getItemsToAdd() {
        SchedulerItem set = this.indexQueue.poll();
        if (set != null) {
            this.size.decrementAndGet();
        }
        return set;
    }

    public void addChangeItem(List<ResourceChange> changes) {
        if (changes.isEmpty()) {
            return;
        }
        this.indexQueue.add(new SchedulerItem(changes, null, null));
        this.size.incrementAndGet();
        this.setReady(false);
        this.doSchedule();
    }

    public void addLinkDeltas(List<InternalAPI.LinkDelta> deltas) {
        if (deltas.isEmpty()) {
            return;
        }
        this.indexQueue.add(new SchedulerItem(null, null, deltas));
        this.size.incrementAndGet();
        this.setReady(false);
        this.doSchedule(3500L);
    }

    public void waitForScope(SearchScope scope, IProgressMonitor monitor) {
        SchedulerCondition condition;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            this.scheduler.getLock().lock();
            condition = this.scheduler.getOrCreateCondition(scope);
            if (condition.isReady()) {
                if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
                    Logger.trace(Logger.Category.DEBUG_CONDITIONS, "EXISTING condition was ready without waiting (" + condition.getDebugName() + ")", new Throwable[]{null});
                }
                return;
            }
            if (this.size.get() == 0 && this.ready.get()) {
                boolean schedule = this.justAddItem(new SchedulerItem(null, condition, null), MonitorPolicy.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
                if (schedule) {
                    this.scheduler.scheduleProcessor();
                }
            } else {
                this.indexQueue.add(new SchedulerItem(null, condition, null));
                this.size.incrementAndGet();
                this.setReady(false);
                this.doSchedule();
            }
            sub.setWorkRemaining(1);
        }
        finally {
            this.scheduler.getLock().unlock();
        }
        condition.waitUntilReady(MonitorPolicy.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
    }

    public boolean isScopeReady(SearchScope scope, IProgressMonitor monitor) {
        try {
            this.scheduler.getLock().lock();
            SchedulerCondition condition = this.scheduler.getOrCreateCondition(scope);
            if (condition.isReady()) {
                return true;
            }
            if (this.size.get() == 0 && this.ready.get()) {
                boolean schedule = this.justAddItem(new SchedulerItem(null, condition, null), monitor);
                if (schedule) {
                    this.scheduler.scheduleProcessor();
                }
            } else {
                this.indexQueue.add(new SchedulerItem(null, condition, null));
                this.size.incrementAndGet();
                this.setReady(false);
                this.doSchedule();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            boolean bl = condition.isReady();
            return bl;
        }
        finally {
            this.scheduler.getLock().unlock();
        }
    }

    boolean isReady() {
        return this.ready.get();
    }

    private void setReady(boolean newReady) {
        if (newReady) {
            this.ready.set(true);
            this.semaphore.release();
        } else {
            boolean success = this.ready.compareAndSet(true, false);
            if (success) {
                boolean interrupted = false;
                boolean gotLock = false;
                while (!gotLock) {
                    try {
                        gotLock = this.tryLock();
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                }
                if (this.ready.get()) {
                    this.semaphore.release();
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void doSchedule() {
        this.started = false;
        JobRunner runner = new JobRunner(this);
        runner.runJob();
    }

    private void doSchedule(long delay) {
        this.started = false;
        JobRunner runner = new JobRunner(this);
        runner.runJob(delay);
    }

    public int getSize() {
        return this.size.get();
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        IStatus status = this.execute(monitor);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus execute(IProgressMonitor monitor) {
        Logger.trace(Logger.Category.JOB_STATE_CHANGES, "AddToIndex started", new Throwable[0]);
        try {
            ThreadPriorityPolicy.setBackgroundProcessingPriority(Thread.currentThread());
            this.activeThread = Thread.currentThread();
            this.started = true;
            this.finished = false;
            Object object = this.runningSync;
            synchronized (object) {
                this.runningSync.notifyAll();
            }
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getSize());
            SchedulerItem item = this.getItemsToAdd();
            boolean shouldSchedule = false;
            while (item != null) {
                try {
                    shouldSchedule |= this.justAddItem(item, (IProgressMonitor)mon.newChild(1));
                }
                catch (OperationCanceledException operationCanceledException) {
                    break;
                }
                item = this.getItemsToAdd();
                this.scheduler.getManager().doRateLimit(this.activeThread.getPriority());
            }
            if (shouldSchedule) {
                this.scheduler.scheduleProcessor();
            }
            this.setReady(true);
        }
        finally {
            this.activeThread = null;
            this.started = false;
            this.finished = true;
            if (monitor != null) {
                monitor.done();
            }
            Logger.trace(Logger.Category.JOB_STATE_CHANGES, "AddToIndex ended", new Throwable[0]);
        }
        return Status.OK_STATUS;
    }

    private boolean justAddItem(SchedulerItem item, IProgressMonitor monitor) {
        return this.scheduler.addItemToIndex(item, monitor);
    }

    public boolean belongsTo(Object family) {
        return family == AddToIndexJob.class || family == ReferenceManager.class;
    }

    private boolean tryLock() throws InterruptedException {
        boolean gotLock = this.semaphore.tryAcquire(InternalAPI.Tweaks.WAIT_TIME, TimeUnit.MILLISECONDS);
        return gotLock;
    }

    @Override
    public Object getSync() {
        return this.runningSync;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void boostPriority() {
        ThreadPriorityPolicy.boostPriority(this.activeThread, Thread.currentThread());
    }

    static class SchedulerItem {
        List<ResourceChange> changes;
        SchedulerCondition condition;
        Set<String> modelIds;
        boolean addedModelDeps;
        List<InternalAPI.LinkDelta> deltas;

        public SchedulerItem(List<ResourceChange> changes, SchedulerCondition condition, List<InternalAPI.LinkDelta> deltas) {
            this.changes = changes;
            this.condition = condition;
            this.deltas = deltas;
        }

        public String toString() {
            return "SchedulerItem [addedModelDeps=" + this.addedModelDeps + ", changes=" + (this.changes == null ? "null" : Arrays.deepToString(this.changes.toArray())) + ", condition=" + this.condition + ", deltas=" + (this.deltas == null ? "null" : Arrays.deepToString(this.deltas.toArray())) + ", modelIds=" + (this.modelIds == null ? "null" : Arrays.deepToString(this.modelIds.toArray())) + "]";
        }
    }
}

