/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index.keys;

import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.keys.IntPairComparatorForLinkKey;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.management.IReferenceElement;
import java.util.Comparator;

public class IntPairLinkKey
extends LinkKey {
    private int id1;
    private int id2;

    public IntPairLinkKey(IndexConstants keyType, IReferenceElement.ElementType linkType) {
        super(keyType, linkType);
    }

    public IntPairLinkKey(String indexName) {
        super(indexName);
    }

    public void setIntPair(int id1, int id2) {
        this.id1 = id1;
        this.id2 = id2;
    }

    @Override
    public LinkKey getMaximumValueKey() {
        IntPairLinkKey key = new IntPairLinkKey(this.getIndexName());
        key.id1 = this.id1;
        key.id2 = Integer.MAX_VALUE;
        return key;
    }

    @Override
    public LinkKey getMaximumPrefixKey() {
        return this;
    }

    public int getInt1() {
        return this.id1;
    }

    public int getInt2() {
        return this.id2;
    }

    @Override
    public Object getMatchableValue() {
        return this.id1;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " I1[ " + this.id1 + " ] I2[ " + this.id2 + " ]";
    }

    @Override
    public void readKeyData(PooledByteBuffer buffer) {
        this.id1 = ByteUtils.bytesToInt(buffer.buffer);
        this.id2 = ByteUtils.bytesToInt(buffer.buffer);
        buffer.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeKeyData() {
        PooledByteBuffer buffer = PooledByteBuffer.INSTANCE.leaseByteBuffer(8);
        buffer.buffer.put(ByteUtils.intToBytes(this.id1));
        buffer.buffer.put(ByteUtils.intToBytes(this.id2));
        buffer.buffer.rewind();
        return buffer;
    }

    @Override
    public Comparator<LinkKey> defaultComparator() {
        return new IntPairComparatorForLinkKey();
    }
}

