/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.DBRecordFactory;
import com.ibm.etools.references.internal.bplustree.db.ExtentManager;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.FileHeader;
import com.ibm.etools.references.internal.bplustree.db.IO;
import com.ibm.etools.references.internal.bplustree.db.IntFileHeader;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.CountedString;
import com.ibm.etools.references.internal.index.EventCollector;
import com.ibm.etools.references.internal.index.IdentityLinkedSet;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import com.ibm.etools.references.internal.index.PropertyStore;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.index.keys.StringDatabaseKey;
import com.ibm.etools.references.internal.management.ErrorRecovery;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.management.ReferenceStatus;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.internal.management.SavedIndexQueue;
import com.ibm.etools.references.internal.management.SavedMarkerQueue;
import com.ibm.etools.references.internal.management.Scheduler;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.search.InternalSearchEngine;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.search.SearchEngine;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ReferenceDatabase {
    private static final String QUEUE_BIN = "refDB" + File.separator + "queue.bin";
    private static final String MARKER_BIN = "refDB" + File.separator + "marker.bin";
    public static final int TYPE_SAVEDINDEXQUEUE = 100;
    public static final int TYPE_PROPERTYSTORE = 101;
    public static final int TYPE_COUNTED_STRING = 102;
    public static final int TYPE_SAVEDMARKERQUEUE = 103;
    private static final int MEM_INDEX_MIN_THRESHOLD = InternalAPI.Tweaks.INDEX_MIN_THRESHOLD;
    private static final int MEM_INDEX_MAX_THRESHOLD = InternalAPI.Tweaks.INDEX_MAX_THRESHOLD;
    private static final int MEM_DB_SIZE_THRESHOLD = InternalAPI.Tweaks.INDEX_MAX_DBSIZE_THRESHOLD;
    private static ReferenceDatabase INSTANCE = new ReferenceDatabase();
    public static final CountDownLatch READY_LATCH = new CountDownLatch(1);
    private ExtentManager db = null;
    private final ReferenceRecordFactory referenceFactory = new ReferenceRecordFactory(this);
    private final List<FileHeader> headers;
    private final Future<?> init;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock write = this.rwlock.writeLock();
    private final ReentrantReadWriteLock.ReadLock read = this.rwlock.readLock();
    private int lastSize;
    private boolean usingHeap;

    public static ReferenceDatabase getDefault() {
        return INSTANCE;
    }

    private ReferenceDatabase() throws FatalIOException {
        this.headers = this.createHeaders();
        this.init = InternalAPI.getExecutor().submit(new Init(), null);
    }

    private void init() {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.init.get();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause() == null ? e : e.getCause();
                    throw new RuntimeException(t);
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void waitReady() {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    READY_LATCH.await();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void loadHeaders(List<FileHeader> headers) {
    }

    private void saveHeaders() {
    }

    private int getSavedInfoId() {
        return ((IntFileHeader)this.headers.get(0)).getHeaderValue();
    }

    private int getPropertyStoreId() {
        return ((IntFileHeader)this.headers.get(1)).getHeaderValue();
    }

    private int getRefDBSize() {
        return ((IntFileHeader)this.headers.get(2)).getHeaderValue();
    }

    private int getSavedMarkerInfoId() {
        return ((IntFileHeader)this.headers.get(3)).getHeaderValue();
    }

    private List<FileHeader> createHeaders() {
        IntFileHeader savedindex = new IntFileHeader("RefDB saved index items id", 65535);
        IntFileHeader propStoreId = new IntFileHeader("RefDB property store id", 65535);
        IntFileHeader size = new IntFileHeader("RefDB size", 0);
        IntFileHeader savedmarkers = new IntFileHeader("RefDB saved marker items id", 65535);
        ArrayList<FileHeader> headers = new ArrayList<FileHeader>();
        Collections.addAll(headers, savedindex, propStoreId, size, savedmarkers);
        return headers;
    }

    private void initHeaders() {
        ((IntFileHeader)this.headers.get(0)).reset();
        ((IntFileHeader)this.headers.get(1)).reset();
        ((IntFileHeader)this.headers.get(2)).reset();
        ((IntFileHeader)this.headers.get(3)).reset();
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream stream) {
        this.init();
        try {
            this.read.lock();
            stream.println("=== Dumping sorted list of all artifacts");
            List<Integer> integers = this.db.debugGetRecIds();
            Collections.sort(integers);
            for (Integer id : integers) {
                InternalReferenceRecord element = this.getInternalReferenceRecord(id);
                if (element != null) {
                    stream.println(element.toString());
                    continue;
                }
                stream.println("Could not find element with id: " + id);
            }
            stream.println("=== Dumping low level extent store");
            this.db.debugPrintRecords(stream);
        }
        finally {
            this.read.unlock();
        }
    }

    public void addOrUpdateArtifact(IReferenceElement artifact, EventCollector collector) throws ReferenceException {
        InternalReferenceObject refObject;
        this.init();
        if (artifact instanceof InternalReferenceObject && (refObject = (InternalReferenceObject)artifact).getRecord().isDirty()) {
            IdentityHashMap<Object, Object> markers = new IdentityHashMap<Object, Object>();
            IdentityLinkedSet<InternalReferenceObject> graph = new IdentityLinkedSet<InternalReferenceObject>();
            refObject.getObjectGraph(graph, markers);
            try {
                this.write.lock();
                this.assignAndUpdate(collector, refObject, graph.getList());
            }
            finally {
                this.write.unlock();
            }
        }
    }

    private void assignAndUpdate(EventCollector collector, InternalReferenceObject refObject, List<InternalReferenceObject> objList) {
        IdentityHashMap<InternalReferenceObject, ReferenceEvent> events = new IdentityHashMap<InternalReferenceObject, ReferenceEvent>();
        if (!refObject.getRecord().isDeleted()) {
            for (InternalReferenceObject graphObject : objList) {
                this.dbAssignIds(graphObject, events);
            }
            for (InternalReferenceObject graphObject : objList) {
                this.dbUpdateRecord(graphObject, collector, events);
            }
        }
    }

    private void dbAssignIds(InternalReferenceObject graphObject, IdentityHashMap<InternalReferenceObject, ReferenceEvent> events) throws ReferenceException {
        this.init();
        ReferenceEvent event = null;
        if (graphObject.getRecord().getId() == -1) {
            event = new ReferenceEvent(null, null, ReferenceEvent.Kind.ADD);
            try {
                this.db.assignId(graphObject.getRecord());
            }
            catch (RuntimeException e) {
                throw new ReferenceException(new ReferenceStatus(4, 105, graphObject.toString(), e));
            }
        } else {
            event = new ReferenceEvent(null, null, ReferenceEvent.Kind.CHANGE);
        }
        events.put(graphObject, event);
    }

    private IStatus createStatus(String errorString, InternalReferenceObject graphObject, RuntimeException e) {
        String eString = String.valueOf(errorString) + (graphObject == null ? "" : graphObject.getRecord());
        Status status = new Status(4, "com.ibm.etools.references", eString, (Throwable)e);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbUpdateRecord(IReferenceElement artifact, EventCollector collector, IdentityHashMap<InternalReferenceObject, ReferenceEvent> events) throws ReferenceException {
        this.init();
        ReferenceEvent event = events.get(artifact);
        InternalReferenceRecord record = ((InternalReferenceObject)artifact).getRecord();
        List<LinkKey> originalKeys = ((InternalReferenceObject)artifact).getOriginalKeys();
        try {
            try {
                this.write.lock();
                if (originalKeys != null) {
                    Assert.isTrue((event.getKind() == ReferenceEvent.Kind.CHANGE ? 1 : 0) != 0, (String)"Contract violation: getOriginalKeys() returned keys when the object was not added to the db yet.");
                    ReferenceEvent realEvent = new ReferenceEvent(((InternalReferenceObject)artifact).getOriginal(), artifact, ReferenceEvent.Kind.CHANGE);
                    InternalReferenceRecord internalReferenceRecord = record;
                    synchronized (internalReferenceRecord) {
                        record.aboutToUpdate(realEvent.getKind());
                    }
                    collector.addEvent(realEvent);
                    IndexManager.updateFromIndexes(originalKeys, (InternalReferenceObject)artifact);
                } else if (event.getKind() == ReferenceEvent.Kind.ADD) {
                    this.incSize();
                    Object realEvent = record;
                    synchronized (realEvent) {
                        record.aboutToUpdate(event.getKind());
                    }
                    this.db.update(record);
                    IndexManager.addToIndexes((InternalReferenceObject)artifact);
                    realEvent = new ReferenceEvent(null, artifact, ReferenceEvent.Kind.ADD);
                    collector.addEvent((ReferenceEvent)realEvent);
                }
                ((InternalReferenceObject)artifact).clearOriginalKeys();
            }
            catch (RuntimeException e) {
                if (e instanceof ReferenceException) {
                    throw e;
                }
                throw new ReferenceException(new ReferenceStatus(4, 106, artifact.toString(), e));
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public InternalReferenceRecord getInternalReferenceRecord(int id) throws ReferenceException {
        if (id != -1) {
            this.init();
            try {
                this.read.lock();
                DBRecord o = this.db.readRecord(id);
                if (o instanceof InternalReferenceRecord) {
                    InternalReferenceRecord internalReferenceRecord = (InternalReferenceRecord)o;
                    return internalReferenceRecord;
                }
                return null;
            }
            catch (RuntimeException e) {
                throw new ReferenceException(new ReferenceStatus(4, 107, Integer.toString(id), e));
            }
            finally {
                this.read.unlock();
            }
        }
        return null;
    }

    public String getString(int id) {
        InternalReferenceRecord record = this.getInternalReferenceRecord(id);
        if (record instanceof CountedString) {
            return ((CountedString)record).getString();
        }
        return null;
    }

    public int lookupKey(String string) {
        Assert.isNotNull((Object)string, (String)"String can not be null");
        this.init();
        try {
            this.read.lock();
            StringDatabaseKey key = new StringDatabaseKey();
            key.setIntPair(string.hashCode(), -1);
            int[] existingStringIds = IndexManager.search(key, key.getMaximumValueKey());
            DBRecord shared = null;
            int[] nArray = existingStringIds;
            int n = existingStringIds.length;
            int n2 = 0;
            while (n2 < n) {
                CountedString cs;
                int id = nArray[n2];
                InternalReferenceRecord record = this.getInternalReferenceRecord(id);
                if (record instanceof CountedString && string.equals((cs = (CountedString)record).getString())) {
                    shared = cs;
                    break;
                }
                ++n2;
            }
            if (shared != null) {
                int n3 = shared.getId();
                return n3;
            }
        }
        finally {
            this.read.unlock();
        }
        return -1;
    }

    public int updateString(int oldString, String newString) {
        Assert.isNotNull((Object)newString, (String)"String can not be null");
        if (oldString == -1) {
            return this.addString(newString);
        }
        this.init();
        try {
            this.write.lock();
            StringDatabaseKey key = new StringDatabaseKey();
            key.setIntPair(newString.hashCode(), -1);
            int[] existingStringIds = IndexManager.search(key, key.getMaximumValueKey());
            DBRecord shared = null;
            int[] nArray = existingStringIds;
            int n = existingStringIds.length;
            int n2 = 0;
            while (n2 < n) {
                CountedString cs;
                int id = nArray[n2];
                InternalReferenceRecord record = this.getInternalReferenceRecord(id);
                if (record instanceof CountedString && newString.equals((cs = (CountedString)record).getString())) {
                    shared = cs;
                    break;
                }
                ++n2;
            }
            if (shared != null) {
                if (oldString != shared.getId()) {
                    this.descrementString(shared.getId());
                    this._addString(newString);
                    ((CountedString)shared).setCount(((CountedString)shared).getCount() + 1);
                    this.db.update(shared);
                    if (Logger.SHOULD_TRACE_STRING) {
                        Logger.trace(Logger.Category.STRING, "UPDATE STRING: " + shared, new Throwable[0]);
                    }
                }
            } else {
                this.descrementString(oldString);
                shared = this._addString(newString);
                ((CountedString)shared).setCount(((CountedString)shared).getCount() + 1);
                this.db.update(shared);
                if (Logger.SHOULD_TRACE_STRING) {
                    Logger.trace(Logger.Category.STRING, "UPDATE STRING: " + shared, new Throwable[0]);
                }
            }
            int n3 = shared.getId();
            return n3;
        }
        finally {
            this.write.unlock();
        }
    }

    public int addString(String string) {
        if (string == null) {
            return -1;
        }
        this.init();
        try {
            this.write.lock();
            StringDatabaseKey key = new StringDatabaseKey();
            key.setIntPair(string.hashCode(), -1);
            int[] existingStringIds = IndexManager.search(key, key.getMaximumValueKey());
            CountedString shared = null;
            int[] nArray = existingStringIds;
            int n = existingStringIds.length;
            int n2 = 0;
            while (n2 < n) {
                CountedString cs;
                int id = nArray[n2];
                InternalReferenceRecord record = this.getInternalReferenceRecord(id);
                if (record instanceof CountedString && string.equals((cs = (CountedString)record).getString())) {
                    shared = cs;
                    break;
                }
                ++n2;
            }
            if (shared == null) {
                shared = this._addString(string);
            }
            shared.setCount(shared.getCount() + 1);
            this.db.update(shared);
            if (Logger.SHOULD_TRACE_STRING) {
                Logger.trace(Logger.Category.STRING, "ADD STRING: " + shared, new Throwable[0]);
            }
            int n3 = shared.getId();
            return n3;
        }
        finally {
            this.write.unlock();
        }
    }

    private CountedString _addString(String string) {
        CountedString shared = new CountedString(102);
        shared.setString(string);
        this.db.assignId(shared);
        StringDatabaseKey key = new StringDatabaseKey();
        key.setIntPair(string.hashCode(), shared.getId());
        IndexManager.addToIndexes(key, ByteUtils.intToBytes(shared.getId()).array());
        return shared;
    }

    public void removeStrings(Collection<Integer> ids) {
        Assert.isNotNull(ids, (String)"int[] can not be null");
        this.init();
        try {
            this.write.lock();
            for (Integer id : ids) {
                this.descrementString(id);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void removeStrings(int[] ids) {
        Assert.isNotNull((Object)ids, (String)"int[] can not be null");
        this.init();
        try {
            this.write.lock();
            int id = 0;
            while (id < ids.length) {
                this.descrementString(ids[id]);
                ++id;
            }
        }
        finally {
            this.write.unlock();
        }
    }

    private void descrementString(int id) {
        InternalReferenceRecord record = this.getInternalReferenceRecord(id);
        if (record instanceof CountedString) {
            CountedString cs = (CountedString)record;
            int newCount = cs.getCount() - 1;
            cs.setCount(newCount);
            if (newCount <= 0) {
                StringDatabaseKey key = new StringDatabaseKey();
                key.setIntPair(cs.getString().hashCode(), cs.getId());
                IndexManager.removeFromIndexes(key);
                this.db.delete(cs);
                if (Logger.SHOULD_TRACE_STRING) {
                    Logger.trace(Logger.Category.STRING, "REMOVE STRING: " + cs, new Throwable[0]);
                }
            } else {
                this.db.update(cs);
                if (Logger.SHOULD_TRACE_STRING) {
                    Logger.trace(Logger.Category.STRING, "REMOVE STRING: " + cs, new Throwable[0]);
                }
            }
        }
    }

    public IReferenceElement getReferenceElement(int id) throws ReferenceException {
        InternalReferenceRecord record = this.getInternalReferenceRecord(id);
        if (record != null) {
            InternalReferenceObject o = record.getLinkArtifact();
            return o;
        }
        return null;
    }

    public <T extends IReferenceElement> T getReferenceElement(int id, Class<T> clazz) throws ReferenceException {
        InternalReferenceRecord record = this.getInternalReferenceRecord(id);
        if (record != null) {
            try {
                return (T)((IReferenceElement)clazz.cast(record.getLinkArtifact()));
            }
            catch (ClassCastException classCastException) {}
        }
        return null;
    }

    public void removeReferenceElement(IReferenceElement artifact, EventCollector collector) throws ReferenceException {
        this.removeReferenceElements(Collections.singleton(artifact), collector);
    }

    public void removeReferenceElements(Collection<? extends IReferenceElement> artifacts, EventCollector collector) throws ReferenceException {
        if (artifacts.isEmpty()) {
            return;
        }
        this.init();
        LinkedHashSet<? extends IReferenceElement> toBeDeleted = new LinkedHashSet<IReferenceElement>();
        toBeDeleted.addAll(artifacts);
        for (IReferenceElement iReferenceElement : artifacts) {
            if (iReferenceElement.getId() == -1) continue;
            InternalReferenceRecord internalReferenceRecord = ((InternalReferenceObject)iReferenceElement).getRecord();
            LinkedHashSet<? extends IReferenceElement> cascade = new LinkedHashSet<IReferenceElement>(internalReferenceRecord.getDeleteCascade());
            while (!cascade.isEmpty()) {
                cascade.removeAll(toBeDeleted);
                Iterator itr = cascade.iterator();
                if (!itr.hasNext()) continue;
                IReferenceElement c = (IReferenceElement)itr.next();
                itr.remove();
                cascade.addAll(((InternalReferenceObject)c).getRecord().getDeleteCascade());
                toBeDeleted.add(c);
            }
        }
        HashMap<IReferenceElement, IReferenceElement> hashMap = new HashMap<IReferenceElement, IReferenceElement>();
        HashMap<IReferenceElement, List<LinkKey>> deleteKeys = new HashMap<IReferenceElement, List<LinkKey>>();
        Iterator iterator = toBeDeleted.iterator();
        while (iterator.hasNext()) {
            IReferenceElement referenceElement = (IReferenceElement)iterator.next();
            if (((InternalReferenceObject)referenceElement).getRecord().isPendingDelete()) {
                iterator.remove();
                continue;
            }
            IReferenceElement snap = ((InternalReferenceObject)referenceElement).snapshot(new HashMap<IReferenceElement, IReferenceElement>(1, 1.0f));
            hashMap.put(referenceElement, snap);
            deleteKeys.put(referenceElement, IndexManager.getKeys((InternalReferenceObject)referenceElement));
        }
        try {
            this.write.lock();
            for (IReferenceElement iReferenceElement : toBeDeleted) {
                InternalReferenceRecord record;
                if (iReferenceElement.getId() == -1 || (record = ((InternalReferenceObject)iReferenceElement).getRecord()).isPendingDelete()) continue;
                try {
                    try {
                        record.aboutToDelete();
                        IndexManager.deleteKeys((Collection)deleteKeys.get(iReferenceElement));
                        this.decSize();
                        this.db.delete(record);
                        this.removeStrings(record.getStringIds());
                    }
                    catch (RuntimeException e) {
                        throw new ReferenceException(new ReferenceStatus(4, 108, iReferenceElement.toString(), e));
                    }
                }
                finally {
                    collector.addEvent(new ReferenceEvent((IReferenceElement)hashMap.get(iReferenceElement), null, ReferenceEvent.Kind.REMOVE));
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void reset() throws ReferenceException {
        File directory;
        File queuefile;
        IPath location = Activator.getDefault().getStateLocation();
        if (location != null && (queuefile = new File(directory = location.toFile(), QUEUE_BIN)).exists()) {
            queuefile.delete();
        }
        if ((location = Activator.getDefault().getStateLocation()) != null && (queuefile = new File(directory = location.toFile(), MARKER_BIN)).exists()) {
            queuefile.delete();
        }
        if (!this.init.isDone()) {
            return;
        }
        try {
            this.write.lock();
            ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
            try {
                this.db.recreate();
            }
            catch (Exception e) {
                ReferenceStatus status = new ReferenceStatus(4, 112, null, e);
                exceptions.add(new ReferenceException(status));
            }
            InternalSearchEngine.removeCache();
            this.initHeaders();
            this.loadHeaders(this.headers);
            try {
                IndexManager.recreateIndexes();
            }
            catch (RuntimeException e) {
                exceptions.add(e);
            }
            ReferenceException x = InternalAPI.convertMultipleExceptions(111, exceptions);
            if (x != null) {
                throw x;
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void clearCache() {
        this.init();
        this.write.lock();
        try {
            this.db.clearCache();
        }
        finally {
            this.write.unlock();
        }
    }

    public void drainCache(boolean immediate) {
        this.init();
        this.write.lock();
        try {
            this.db.drainCache(immediate);
        }
        finally {
            this.write.unlock();
        }
    }

    public void joinPendingWrites() {
        this.write.lock();
        try {
            this.drainCache(false);
        }
        finally {
            this.write.unlock();
        }
        this.db.joinPendingWrites();
    }

    public void shutdown() {
        this.init();
        this.joinPendingWrites();
        try {
            this.write.lock();
            ArrayList<ReferenceException> exceptions = new ArrayList<ReferenceException>();
            try {
                this.resetIndexes(true);
            }
            catch (ReferenceException e) {
                exceptions.add(e);
            }
            this.saveHeaders();
            try {
                this.db.close(true);
            }
            catch (RuntimeException e) {
                ReferenceStatus status = new ReferenceStatus(4, 113, null, e);
                exceptions.add(new ReferenceException(status));
            }
            InternalSearchEngine.removeCache();
            try {
                IndexManager.closeIndexes();
            }
            catch (ReferenceException e) {
                exceptions.add(e);
            }
            ReferenceException x = InternalAPI.convertMultipleExceptions(117, exceptions);
            if (x != null) {
                throw x;
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void reload() throws FatalIOException {
        this.init();
        this.write.lock();
        try {
            this.db.reload();
            this.loadHeaders(this.headers);
        }
        finally {
            this.write.unlock();
        }
    }

    public SavedIndexQueue createSavedIndexQueue() {
        return (SavedIndexQueue)this.referenceFactory.createRecord(100, null);
    }

    public SavedMarkerQueue createSavedMarkerIndexQueue() {
        return (SavedMarkerQueue)this.referenceFactory.createRecord(103, null);
    }

    public SavedIndexQueue getSavedIndexQueue() throws FatalIOException {
        this.waitReady();
        try {
            this.write.lock();
            IO io = null;
            IPath location = Activator.getDefault().getStateLocation();
            if (location != null) {
                File directory = location.toFile();
                File queuefile = new File(directory, QUEUE_BIN);
                if (!queuefile.exists()) {
                    SavedIndexQueue savedIndexQueue = this.createSavedIndexQueue();
                    return savedIndexQueue;
                }
                io = InternalAPI.Tweaks.SHOULD_USE_MAPPED_BUFFER ? new IO.BufferIO(queuefile) : new IO.FileChannelIO(queuefile);
            }
            if (io != null) {
                try {
                    io.init(false, 4);
                    PooledByteBuffer length = io.read(4);
                    int size = length.buffer.getInt();
                    PooledByteBuffer buffer = io.read(size);
                    SavedIndexQueue queue = this.createSavedIndexQueue();
                    queue.readRecord(buffer);
                    buffer.returnBuffer();
                    SavedIndexQueue savedIndexQueue = queue;
                    return savedIndexQueue;
                }
                finally {
                    try {
                        io.close();
                    }
                    catch (Exception e) {
                        Logger.logException("Problems closing saved index queue file", e);
                    }
                }
            }
            throw new RuntimeException("Errors reading saved index queue");
        }
        finally {
            this.write.unlock();
        }
    }

    public void updateSavedIndexQueue(SavedIndexQueue queue) throws FatalIOException {
        block13: {
            this.waitReady();
            try {
                this.write.lock();
                IO io = null;
                IPath location = Activator.getDefault().getStateLocation();
                if (location != null) {
                    File directory = location.toFile();
                    File queuefile = new File(directory, QUEUE_BIN);
                    queuefile.mkdirs();
                    boolean deleted = queuefile.delete();
                    if (deleted || !queuefile.exists()) {
                        io = InternalAPI.Tweaks.SHOULD_USE_MAPPED_BUFFER ? new IO.BufferIO(queuefile) : new IO.FileChannelIO(queuefile);
                    }
                }
                if (io != null) {
                    PooledByteBuffer buffer = queue.writeRecord();
                    try {
                        io.init(true, buffer.buffer.remaining() + 4);
                        io.write(ByteUtils.intToBytes(buffer.buffer.remaining()));
                        io.write(buffer.buffer);
                        buffer.returnBuffer();
                        break block13;
                    }
                    finally {
                        try {
                            io.close();
                        }
                        catch (Exception e) {
                            Logger.logException("Problems closing file for saved index queue", e);
                        }
                    }
                }
                Logger.logException("Could not write saved index queue", null);
            }
            finally {
                this.write.unlock();
            }
        }
    }

    public SavedMarkerQueue getSavedMarkerQueue() {
        this.waitReady();
        try {
            this.write.lock();
            IO io = null;
            IPath location = Activator.getDefault().getStateLocation();
            if (location != null) {
                File directory = location.toFile();
                File queuefile = new File(directory, MARKER_BIN);
                if (!queuefile.exists()) {
                    SavedMarkerQueue savedMarkerQueue = this.createSavedMarkerIndexQueue();
                    return savedMarkerQueue;
                }
                io = InternalAPI.Tweaks.SHOULD_USE_MAPPED_BUFFER ? new IO.BufferIO(queuefile) : new IO.FileChannelIO(queuefile);
            }
            if (io != null) {
                try {
                    io.init(false, 4);
                    PooledByteBuffer length = io.read(4);
                    int size = length.buffer.getInt();
                    PooledByteBuffer buffer = io.read(size);
                    SavedMarkerQueue queue = this.createSavedMarkerIndexQueue();
                    queue.readRecord(buffer);
                    buffer.returnBuffer();
                    SavedMarkerQueue savedMarkerQueue = queue;
                    return savedMarkerQueue;
                }
                finally {
                    try {
                        io.close();
                    }
                    catch (Exception e) {
                        Logger.logException("Problems closing saved marker queue file", e);
                    }
                }
            }
            throw new RuntimeException("Errors reading saved marker queue");
        }
        finally {
            this.write.unlock();
        }
    }

    public void updateSavedMarkerQueue(SavedMarkerQueue queue) throws FatalIOException {
        block13: {
            this.waitReady();
            try {
                this.write.lock();
                IO io = null;
                IPath location = Activator.getDefault().getStateLocation();
                if (location != null) {
                    File directory = location.toFile();
                    File queuefile = new File(directory, MARKER_BIN);
                    queuefile.mkdirs();
                    boolean deleted = queuefile.delete();
                    if (deleted || !queuefile.exists()) {
                        io = InternalAPI.Tweaks.SHOULD_USE_MAPPED_BUFFER ? new IO.BufferIO(queuefile) : new IO.FileChannelIO(queuefile);
                    }
                }
                if (io != null) {
                    PooledByteBuffer buffer = queue.writeRecord();
                    try {
                        io.init(true, buffer.buffer.remaining() + 4);
                        io.write(ByteUtils.intToBytes(buffer.buffer.remaining()));
                        io.write(buffer.buffer);
                        buffer.returnBuffer();
                        break block13;
                    }
                    finally {
                        try {
                            io.close();
                        }
                        catch (Exception e) {
                            Logger.logException("Problems closing file for saved marker queue", e);
                        }
                    }
                }
                Logger.logException("Could not write saved marker queue", null);
            }
            finally {
                this.write.unlock();
            }
        }
    }

    public int getSize() {
        this.init();
        this.read.lock();
        try {
            int n = this.getRefDBSize();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    public void incSize() {
        this.init();
        try {
            this.write.lock();
            ((IntFileHeader)this.headers.get(2)).setHeaderValue(((IntFileHeader)this.headers.get(2)).getHeaderValue() + 1);
        }
        finally {
            this.write.unlock();
        }
    }

    public void decSize() {
        this.init();
        try {
            this.write.lock();
            ((IntFileHeader)this.headers.get(2)).setHeaderValue(((IntFileHeader)this.headers.get(2)).getHeaderValue() - 1);
        }
        finally {
            this.write.unlock();
        }
    }

    public boolean convertIndexes(boolean toHeap, IProgressMonitor progressMonitor) {
        this.init();
        try {
            this.write.lock();
            long s = System.currentTimeMillis();
            boolean success = IndexManager.convertIndexes(toHeap, progressMonitor);
            long e = System.currentTimeMillis();
            if (Logger.SHOULD_TRACE_TIMING) {
                Logger.trace(Logger.Category.TIMING, "Converted: (style=" + (toHeap ? "to heap" : "toDisk") + ") in " + (float)(e - s) / 1000.0f + "s", new Throwable[0]);
            }
            boolean bl = success;
            return bl;
        }
        catch (RuntimeException e) {
            String friendlyMsg = Messages.errorMsg_fatalerrorwhileconverting;
            InternalAPI.handleFrameworkException(ErrorRecovery.CONVERT_INDEXES_ERROR, friendlyMsg, e, EnumSet.of(ErrorEvent.PresentationHints.LOG, ErrorEvent.PresentationHints.BLOCK), true);
            return false;
        }
        finally {
            this.write.unlock();
        }
    }

    public PropertyStore getPropertyStore() throws FatalIOException {
        this.init();
        int id = 65535;
        try {
            this.write.lock();
            id = this.getPropertyStoreId();
            if (id == 65535) {
                PropertyStore propertyStore = (PropertyStore)this.referenceFactory.createRecord(101, null);
                return propertyStore;
            }
            PropertyStore nodes = null;
            DBRecord r = this.db.readRecord(id);
            if (r instanceof PropertyStore) {
                nodes = (PropertyStore)r;
            }
            PropertyStore propertyStore = nodes;
            return propertyStore;
        }
        catch (FatalIOException e) {
            if (e.getCode() == 1) {
                return null;
            }
            throw e;
        }
        finally {
            this.write.unlock();
        }
    }

    public void storeValue(String nameSpace, String key, String value) {
        this.init();
        try {
            this.write.lock();
            PropertyStore store = this.getPropertyStore();
            if (store != null) {
                store.writeValue(nameSpace, key, value);
                this.db.update(store);
                ((IntFileHeader)this.headers.get(1)).setHeaderValue(store.getId());
            } else {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Store property after db is closed");
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void clearValue(String nameSpace, String key) {
        this.init();
        try {
            this.write.lock();
            PropertyStore store = this.getPropertyStore();
            if (store != null) {
                store.removeValue(nameSpace, key);
                this.db.update(store);
                ((IntFileHeader)this.headers.get(1)).setHeaderValue(store.getId());
            } else {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Clear property after db is closed");
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public String readValue(String nameSpace, String key, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("", 1);
        this.init();
        boolean gotLock = false;
        try {
            while (!gotLock) {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                gotLock = this.write.tryLock(250L, TimeUnit.MILLISECONDS);
            }
            PropertyStore store = this.getPropertyStore();
            if (store != null) {
                String string = store.readValue(nameSpace, key);
                return string;
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        finally {
            if (gotLock) {
                this.write.unlock();
            }
        }
    }

    public void convertIndexes(int size, boolean toHeap) {
        int current = this.getSize();
        int delta = current - this.lastSize;
        this.lastSize = current;
        if (toHeap) {
            if (current >= MEM_DB_SIZE_THRESHOLD && this.usingHeap) {
                this.convertIndexes(false, null);
                this.usingHeap = false;
            } else if (size > MEM_INDEX_MIN_THRESHOLD && size < MEM_INDEX_MAX_THRESHOLD && current < MEM_DB_SIZE_THRESHOLD && delta > 0) {
                if (!this.usingHeap) {
                    this.convertIndexes(true, null);
                }
                this.usingHeap = true;
            }
        } else {
            if (this.usingHeap) {
                this.convertIndexes(false, null);
            }
            this.usingHeap = false;
        }
    }

    private void resetIndexes(boolean ensureDisk) throws ReferenceException {
        this.convertIndexes(false, null);
        IndexManager.syncIndexes(ensureDisk);
    }

    public void printCacheStats(PrintStream out) {
        this.read.lock();
        try {
            out.println("Reference Database");
            out.print("\t");
            this.db.printCacheStats(out);
        }
        finally {
            this.read.unlock();
        }
    }

    public void resetStats() {
        this.write.lock();
        try {
            this.db.resetStats();
        }
        finally {
            this.write.unlock();
        }
    }

    public Link createNewLink(boolean parseLinksOnly) {
        if (parseLinksOnly) {
            Link.ParsedLink link = new Link.ParsedLink();
            link.init(this.db);
            link.markLoaded();
            return link;
        }
        Link link = new Link();
        link.init(this.db);
        link.markLoaded();
        return link;
    }

    public ExtentManager getExtentManager() {
        return this.db;
    }

    public ResolvedReference createNewResolvedReference() {
        ResolvedReference reference = new ResolvedReference();
        reference.init(this.db);
        reference.markLoaded();
        return reference;
    }

    public InternalAPI.DBStatistic[] getStatistics(IProgressMonitor monitor) {
        ArrayList<InternalAPI.DBStatistic> stats = new ArrayList<InternalAPI.DBStatistic>();
        SubMonitor outer = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor sub = outer.newChild(80);
        sub.beginTask("", 100);
        sub.subTask("Flushing caches");
        this.drainCache(true);
        IndexManager.drainCache(true);
        this.joinPendingWrites();
        sub.worked(10);
        this.read.lock();
        try {
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            SpecializedType fileType = ReferenceManager.getReferenceManager().getLinkType("builtin.file.nodeid");
            SpecializedType folderType = ReferenceManager.getReferenceManager().getLinkType("builtin.folder.nodeid");
            SpecializedType projectType = ReferenceManager.getReferenceManager().getLinkType("builtin.project.nodeid");
            IReferenceElement.ElementType[] types = IReferenceElement.ElementType.values();
            InternalAPI.DBStatistic regularLinks = new InternalAPI.DBStatistic("regularLinks");
            InternalAPI.DBStatistic fileLinks = new InternalAPI.DBStatistic("fileLinks");
            InternalAPI.DBStatistic folderLinks = new InternalAPI.DBStatistic("folderLinks");
            InternalAPI.DBStatistic projectLinks = new InternalAPI.DBStatistic("projectLinks");
            InternalAPI.DBStatistic references = new InternalAPI.DBStatistic("references");
            InternalAPI.DBStatistic resolved = new InternalAPI.DBStatistic("resolved");
            InternalAPI.DBStatistic totalBrokenLinks = new InternalAPI.DBStatistic("Actual broken links");
            sub.subTask("Collecting database artifact statistics");
            List<Integer> ids = this.db.debugGetRecIds();
            SubMonitor dbStatMon = sub.newChild(45);
            dbStatMon.beginTask("", ids.size());
            for (Integer integer : ids) {
                DBRecord record = this.db.readRecord(integer);
                if (record != null) {
                    if (record.getDataType() < 0 || record.getDataType() > types.length) {
                        dbStatMon.worked(1);
                        continue;
                    }
                    IReferenceElement.ElementType type = types[record.getDataType()];
                    if (type == IReferenceElement.ElementType.LINK) {
                        ILink link = (ILink)((Object)((InternalReferenceRecord)record).getLinkArtifact());
                        if (fileType.equals(link.getSpecializedType())) {
                            ++fileLinks.count;
                        } else if (folderType.equals(link.getSpecializedType())) {
                            ++folderLinks.count;
                        } else if (projectType.equals(link.getSpecializedType())) {
                            ++projectLinks.count;
                        } else {
                            ++regularLinks.count;
                            totalBrokenLinks.count += (long)link.findBrokenReferences(null).size();
                        }
                    } else if (type == IReferenceElement.ElementType.REFERENCE) {
                        ++references.count;
                    } else if (type == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                        ++resolved.count;
                    }
                }
                dbStatMon.worked(1);
            }
            stats.add(regularLinks);
            stats.add(fileLinks);
            stats.add(folderLinks);
            stats.add(projectLinks);
            stats.add(references);
            stats.add(resolved);
            if (sub.isCanceled()) {
                InternalAPI.DBStatistic[] dBStatisticArray = stats.toArray(new InternalAPI.DBStatistic[stats.size()]);
                return dBStatisticArray;
            }
            SubMonitor otherStats = sub.newChild(45);
            otherStats.beginTask("", 7);
            final InternalAPI.DBStatistic ignoredContainedLinks = new InternalAPI.DBStatistic("Ignored contained links");
            final InternalAPI.DBStatistic ignoredCompletely = new InternalAPI.DBStatistic("Ignored completely");
            IResourceVisitor visitor = new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 8) {
                        return true;
                    }
                    if (!Scheduler.isTargettable(resource) || Scheduler.hasStar(resource)) {
                        ++ignoredCompletely.count;
                    } else if (Scheduler.ignoreContainedLinks(resource)) {
                        ++ignoredContainedLinks.count;
                    }
                    return true;
                }
            };
            otherStats.subTask("Ignored resources");
            try {
                ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
            }
            catch (CoreException coreException) {}
            otherStats.worked(1);
            stats.add(ignoredContainedLinks);
            stats.add(ignoredCompletely);
            if (otherStats.isCanceled()) {
                InternalAPI.DBStatistic[] dBStatisticArray = stats.toArray(new InternalAPI.DBStatistic[stats.size()]);
                return dBStatisticArray;
            }
            InternalAPI.DBStatistic dbSizeRecords = new InternalAPI.DBStatistic("DB size (records)");
            otherStats.subTask(dbSizeRecords.name);
            dbSizeRecords.count = this.getSize();
            otherStats.worked(1);
            stats.add(dbSizeRecords);
            if (otherStats.isCanceled()) {
                InternalAPI.DBStatistic[] dBStatisticArray = stats.toArray(new InternalAPI.DBStatistic[stats.size()]);
                return dBStatisticArray;
            }
            InternalAPI.DBStatistic dbSizeDiskUsed = new InternalAPI.DBStatistic("DB total used (bytes)");
            otherStats.subTask(dbSizeDiskUsed.name);
            dbSizeDiskUsed.count = this.db.getRecordUsedBytes();
            otherStats.worked(1);
            stats.add(dbSizeDiskUsed);
            if (otherStats.isCanceled()) {
                InternalAPI.DBStatistic[] dBStatisticArray = stats.toArray(new InternalAPI.DBStatistic[stats.size()]);
                return dBStatisticArray;
            }
            InternalAPI.DBStatistic dbSizeDiskAlloc = new InternalAPI.DBStatistic("DB total allocated (bytes)");
            otherStats.subTask(dbSizeDiskAlloc.name);
            dbSizeDiskAlloc.count = this.db.getTotalAllocatedBytes();
            otherStats.worked(1);
            stats.add(dbSizeDiskAlloc);
            if (otherStats.isCanceled()) {
                InternalAPI.DBStatistic[] dBStatisticArray = stats.toArray(new InternalAPI.DBStatistic[stats.size()]);
                return dBStatisticArray;
            }
            InternalAPI.DBStatistic totalIndexUsed = new InternalAPI.DBStatistic("Index size used (bytes)");
            otherStats.subTask(totalIndexUsed.name);
            totalIndexUsed.count = IndexManager.getTotalUsedBytes();
            otherStats.worked(1);
            stats.add(totalIndexUsed);
            if (otherStats.isCanceled()) {
                InternalAPI.DBStatistic[] dBStatisticArray = stats.toArray(new InternalAPI.DBStatistic[stats.size()]);
                return dBStatisticArray;
            }
            InternalAPI.DBStatistic totalIndexAlloc = new InternalAPI.DBStatistic("Index size allocated (bytes)");
            otherStats.subTask(totalIndexAlloc.name);
            totalIndexAlloc.count = IndexManager.getTotalAllocatedBytes();
            otherStats.worked(1);
            stats.add(totalIndexAlloc);
            if (otherStats.isCanceled()) {
                InternalAPI.DBStatistic[] dBStatisticArray = stats.toArray(new InternalAPI.DBStatistic[stats.size()]);
                return dBStatisticArray;
            }
            InternalAPI.DBStatistic totalMarkers = new InternalAPI.DBStatistic("Broken links (markers)");
            otherStats.subTask(dbSizeRecords.name);
            try {
                IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.ibm.etools.references.linkmarker", false, 2);
                totalMarkers.count = markers.length;
            }
            catch (CoreException coreException) {}
            otherStats.worked(1);
            stats.add(totalMarkers);
            stats.add(totalBrokenLinks);
        }
        finally {
            this.read.unlock();
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
        return stats.toArray(new InternalAPI.DBStatistic[stats.size()]);
    }

    private class Init
    implements Runnable {
        private Init() {
        }

        @Override
        public void run() {
            boolean interrupted = false;
            try {
                while (true) {
                    try {
                        READY_LATCH.await();
                        File databaseFile = new File(Activator.getDatabaseDirectory(), "database.db");
                        ReferenceDatabase.this.initHeaders();
                        ReferenceDatabase.this.db = new ExtentManager(InternalAPI.Tweaks.DB_CACHE_SIZE, databaseFile, ReferenceDatabase.this.referenceFactory, 512000, ReferenceDatabase.this.headers, 1.0f, false, ReferenceDatabase.this.rwlock);
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public class ReferenceRecordFactory
    extends DBRecordFactory {
        public ReferenceRecordFactory(ReferenceDatabase refDB) {
        }

        @Override
        public DBRecord createRecord(int recordType, ExtentManager manager) {
            if (recordType == 100) {
                return new SavedIndexQueue(recordType);
            }
            if (recordType == 101) {
                return new PropertyStore(recordType);
            }
            if (recordType == 102) {
                return new CountedString(recordType);
            }
            if (recordType == 103) {
                return new SavedMarkerQueue(recordType);
            }
            IReferenceElement.ElementType elementType = IReferenceElement.ElementType.values()[recordType];
            InternalReferenceRecord result = null;
            if (elementType == IReferenceElement.ElementType.LINK) {
                Assert.isNotNull((Object)manager, (String)Messages.ReferenceRecordFactory_ManageCannotBeNull);
                Link o = new Link();
                o.init(manager);
                result = ((InternalReferenceObject)o).getRecord();
            } else if (elementType == IReferenceElement.ElementType.REFERENCE) {
                Assert.isNotNull((Object)manager, (String)Messages.ReferenceRecordFactory_ManageCannotBeNull);
                Reference o = new Reference(null, null);
                o.init(manager);
                result = ((InternalReferenceObject)o).getRecord();
            } else if (elementType == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                Assert.isNotNull((Object)manager, (String)Messages.ReferenceRecordFactory_ManageCannotBeNull);
                ResolvedReference o = new ResolvedReference();
                o.init(manager);
                result = ((InternalReferenceObject)o).getRecord();
            }
            return result;
        }

        @Override
        public boolean shouldProxyLoad(int recordType) {
            if (recordType > IReferenceElement.ElementType.values().length) {
                return false;
            }
            IReferenceElement.ElementType elementType = IReferenceElement.ElementType.values()[recordType];
            if (elementType == IReferenceElement.ElementType.LINK) {
                return true;
            }
            if (elementType == IReferenceElement.ElementType.REFERENCE) {
                return true;
            }
            if (elementType == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                return true;
            }
            return super.shouldProxyLoad(recordType);
        }

        @Override
        public int getAverageSize(int recordType) {
            IReferenceElement.ElementType elementType = IReferenceElement.ElementType.values()[recordType];
            if (elementType == IReferenceElement.ElementType.LINK) {
                return 40;
            }
            if (elementType == IReferenceElement.ElementType.REFERENCE) {
                return 36;
            }
            if (elementType != IReferenceElement.ElementType.RESOLVED_REFERENCE && recordType == 102) {
                return 84;
            }
            return 128;
        }

        @Override
        public int getSize(int recordType) {
            IReferenceElement.ElementType elementType = IReferenceElement.ElementType.values()[recordType];
            if (elementType == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                return 25;
            }
            return -1;
        }

        @Override
        public int[] recordTypes() {
            return new int[]{IReferenceElement.ElementType.RESOLVED_REFERENCE.ordinal(), IReferenceElement.ElementType.REFERENCE.ordinal(), IReferenceElement.ElementType.LINK.ordinal()};
        }
    }
}

