/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.internal.bplustree.db.IntArray;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.TreeInconsistencyException;
import com.ibm.etools.references.internal.index.IReferenceIndex;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.management.ReferenceStatus;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class HeapBasedReferenceIndex
implements IReferenceIndex {
    private final TreeMap<Key, byte[]> index;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock write = this.lock.writeLock();
    private final ReentrantReadWriteLock.ReadLock read = this.lock.readLock();
    private final File indexFile;
    private final String indexName;

    public HeapBasedReferenceIndex(File indexFile, String indexName, Comparator c) {
        this.indexFile = indexFile;
        this.indexName = indexName;
        this.index = new TreeMap(c);
    }

    @Override
    public IReferenceIndex newIndex() {
        return new HeapBasedReferenceIndex(this.indexFile, this.indexName, this.index.comparator());
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    private IStatus createStatus(String errorString, Exception e) {
        String eString = errorString;
        Status status = new Status(4, "com.ibm.etools.references", eString, (Throwable)e);
        return status;
    }

    private void assertStuff() throws TreeInconsistencyException {
    }

    private int itrCount(Iterator<Map.Entry<Key, byte[]>> itr) throws TreeInconsistencyException {
        int c = 0;
        Key prev = null;
        while (itr.hasNext()) {
            Map.Entry<Key, byte[]> entry = itr.next();
            if (c != 0 && prev != null) {
                Key current = entry.getKey();
                if (this.index.comparator().compare(current, prev) <= 0) {
                    throw new TreeInconsistencyException(Messages.bTreeMsg_incorrect_key_ordering);
                }
            }
            prev = entry.getKey();
            ++c;
        }
        return c;
    }

    @Override
    public void add(Key linkArtifactKey, IReferenceElement artifact) throws ReferenceException {
        try {
            try {
                this.write.lock();
                int id = artifact.getId();
                this.index.put(linkArtifactKey, ByteUtils.intToBytes(id).array());
                this.assertStuff();
            }
            catch (TreeInconsistencyException e) {
                throw new ReferenceException(new ReferenceStatus(4, 102, "Key: " + linkArtifactKey + ", Value: " + artifact, e));
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void add(Key linkArtifactKey, byte[] bytes) throws ReferenceException {
        try {
            try {
                this.write.lock();
                this.index.put(linkArtifactKey, bytes);
                this.assertStuff();
            }
            catch (TreeInconsistencyException e) {
                throw new ReferenceException(new ReferenceStatus(4, 102, "Key: " + linkArtifactKey + ", Value: " + Arrays.toString(bytes), e));
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void addAll(Iterator<?> entryItr, boolean replace, IProgressMonitor monitor, int itrSize) throws ReferenceException {
        Map.Entry entry = null;
        try {
            try {
                monitor.beginTask("", itrSize);
                this.write.lock();
                if (replace) {
                    this.recreate();
                }
                while (entryItr.hasNext()) {
                    entry = (Map.Entry)entryItr.next();
                    this.index.put((Key)entry.getKey(), (byte[])entry.getValue());
                    monitor.worked(1);
                }
                this.assertStuff();
            }
            catch (TreeInconsistencyException e) {
                ReferenceStatus status = null;
                status = entry != null && entry.getKey() != null ? new ReferenceStatus(4, 102, "Key: " + entry.getKey() + ", Value: " + Arrays.toString((byte[])entry.getValue()), e) : new ReferenceStatus(4, 102, "unknown", e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void close() {
        throw new RuntimeException(Messages.errorMsg_HeapBasedReferenceIndex_nocloseheapindex);
    }

    @Override
    public void delete(Key artifact) throws ReferenceException {
        try {
            try {
                this.write.lock();
                this.index.remove(artifact);
                this.assertStuff();
            }
            catch (TreeInconsistencyException e) {
                ReferenceStatus status = new ReferenceStatus(4, 103, artifact == null ? "null" : artifact.toString(), e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void delete() {
        try {
            this.write.lock();
            this.index.clear();
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public IReferenceIndex.Pair[] entries(int[] valueIds) {
        ArrayList<IReferenceIndex.Pair> pairs = new ArrayList<IReferenceIndex.Pair>();
        try {
            this.read.lock();
            Set<Integer> ids = null;
            for (Map.Entry<Key, byte[]> entry : this.index.entrySet()) {
                Key key;
                int id = ByteUtils.bytesToInt(ByteBuffer.wrap(entry.getValue()));
                if (valueIds == null) {
                    key = entry.getKey();
                    pairs.add(new IReferenceIndex.Pair(key, id));
                    continue;
                }
                if (ids == null) {
                    ids = this.createSet(valueIds);
                }
                if (!ids.contains(id)) continue;
                key = (LinkKey)entry.getKey();
                pairs.add(new IReferenceIndex.Pair(key, id));
            }
        }
        finally {
            this.read.unlock();
        }
        return pairs.toArray(new IReferenceIndex.Pair[pairs.size()]);
    }

    private Set<Integer> createSet(int[] ints) {
        HashSet<Integer> s = new HashSet<Integer>(ints.length);
        int i = 0;
        while (i < ints.length) {
            s.add(ints[i]);
            ++i;
        }
        return s;
    }

    @Override
    public File getFile() {
        return this.indexFile;
    }

    @Override
    public void print() {
        this.print(System.out, true);
    }

    @Override
    public void print(PrintStream stream, boolean includeLinks) {
        try {
            this.read.lock();
            stream.println("Iteration: ");
            Iterator<Map.Entry<Key, byte[]>> itr = this.index.entrySet().iterator();
            int count = 0;
            while (itr.hasNext()) {
                Map.Entry<Key, byte[]> entry = itr.next();
                stream.print("Key: " + entry.getKey());
                stream.print(" Value: " + this.printData(entry.getValue()));
                if (includeLinks) {
                    int id = ByteUtils.bytesToInt(ByteBuffer.wrap(entry.getValue()));
                    stream.println(" Link: " + ReferenceDatabase.getDefault().getReferenceElement(id));
                } else {
                    stream.println();
                }
                ++count;
            }
            stream.println("Tree size: " + this.index.size() + " iteration count: " + count);
        }
        finally {
            this.read.unlock();
        }
    }

    private String printData(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            buf.append(String.valueOf(b) + ",");
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void recreate() {
        this.delete();
    }

    @Override
    public void reload() {
    }

    @Override
    public int[] search(Key start, Key end) throws ReferenceException {
        IntArray array = new IntArray();
        try {
            try {
                this.read.lock();
                for (Map.Entry entry : this.index.subMap(start, true, end, true).entrySet()) {
                    int id = ByteUtils.bytesToInt(ByteBuffer.wrap((byte[])entry.getValue()));
                    array.add(id);
                }
            }
            catch (TreeInconsistencyException e) {
                ReferenceStatus status = new ReferenceStatus(4, 104, "Range=[" + start + " to " + end + "]", e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.read.unlock();
        }
        return array.toArray();
    }

    @Override
    public IReferenceIndex convertToDisk(IReferenceIndex targetIndex, IProgressMonitor monitor) {
        try {
            this.write.lock();
            int size = this.index.size();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
            Iterator<Map.Entry<Key, byte[]>> entryItr = this.index.entrySet().iterator();
            targetIndex.addAll(entryItr, true, (IProgressMonitor)sub.newChild(size), size);
            this.assertStuff();
        }
        finally {
            this.write.unlock();
        }
        return targetIndex;
    }

    @Override
    public IReferenceIndex convertToHeap(IReferenceIndex targetIndex, IProgressMonitor monitor) {
        return this;
    }

    @Override
    public void sync() {
    }

    @Override
    public void printCacheStats(PrintStream out) {
        out.print("Heap-based: no-cache");
    }

    @Override
    public void resetCacheStats() {
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void drainCache(boolean immediate) {
    }

    @Override
    public int getSize() {
        try {
            this.read.lock();
            int n = this.index.size();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public long getTotalAllocatedBytes() {
        return 0L;
    }

    @Override
    public long getTotalUsedBytes() {
        return 0L;
    }
}

