/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.IntArray;
import com.ibm.etools.references.internal.bplustree.tree.BPTree;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.TreeInconsistencyException;
import com.ibm.etools.references.internal.index.IReferenceIndex;
import com.ibm.etools.references.internal.index.keys.IndexKeyFactory;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.management.ReferenceStatus;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DiskBasedReferenceIndex
implements IReferenceIndex {
    private final BPTree tree;
    private final String indexName;

    public DiskBasedReferenceIndex(File indexFile, String indexName, IndexKeyFactory indexKeyFactory, int dataSize) throws FatalIOException {
        this(indexFile, indexName, indexKeyFactory, dataSize, false);
    }

    public DiskBasedReferenceIndex(File indexFile, String indexName, IndexKeyFactory indexKeyFactory, int dataSize, boolean create) throws FatalIOException {
        this.indexName = indexName;
        this.tree = new BPTree(indexFile, InternalAPI.Tweaks.INDEX_CACHE_SIZE, InternalAPI.Tweaks.INDEX_BRANCHES, InternalAPI.Tweaks.INDEX_NODES_PER_EXTENT, indexKeyFactory, dataSize, create);
    }

    @Override
    public IReferenceIndex newIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public File getFile() {
        return this.tree.getFile();
    }

    @Override
    public void add(Key linkArtifactKey, IReferenceElement artifact) throws ReferenceException {
        try {
            int id = artifact.getId();
            this.tree.insert(linkArtifactKey, ByteUtils.intToBytes(id).array());
        }
        catch (TreeInconsistencyException e) {
            throw new ReferenceException(new ReferenceStatus(4, 102, "Key: " + linkArtifactKey + ", Value: " + artifact, e));
        }
    }

    @Override
    public void add(Key linkArtifactKey, byte[] bytes) throws ReferenceException {
        try {
            this.tree.insert(linkArtifactKey, bytes);
        }
        catch (TreeInconsistencyException e) {
            throw new ReferenceException(new ReferenceStatus(4, 102, "Key: " + linkArtifactKey + ", Value: " + Arrays.toString(bytes), e));
        }
    }

    @Override
    public void addAll(Iterator<?> entryItr, boolean replace, IProgressMonitor monitor, int itrSize) throws ReferenceException {
        monitor.beginTask("", itrSize);
        Map.Entry entry = null;
        this.tree.beginWrite();
        try {
            try {
                if (replace) {
                    this.recreate();
                }
                while (entryItr.hasNext()) {
                    entry = (Map.Entry)entryItr.next();
                    this.tree.insert((Key)entry.getKey(), (byte[])entry.getValue());
                    monitor.worked(1);
                }
            }
            catch (TreeInconsistencyException e) {
                ReferenceStatus status = null;
                status = entry != null && entry.getKey() != null ? new ReferenceStatus(4, 102, "Key: " + entry.getKey() + ", Value: " + Arrays.toString((byte[])entry.getValue()), e) : new ReferenceStatus(4, 102, "unknown", e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.tree.endWrite();
        }
    }

    @Override
    public void delete(Key artifact) throws ReferenceException {
        try {
            this.tree.delete(artifact);
        }
        catch (TreeInconsistencyException e) {
            ReferenceStatus status = new ReferenceStatus(4, 103, artifact == null ? "null" : artifact.toString(), e);
            throw new ReferenceException(status);
        }
    }

    @Override
    public int[] search(Key start, Key end) throws ReferenceException {
        IntArray array = new IntArray();
        try {
            try {
                this.tree.beginRead();
                Iterator<Map.Entry<Key, byte[]>> itr = this.tree.iterator(start, end);
                while (itr.hasNext()) {
                    Map.Entry<Key, byte[]> entry = itr.next();
                    int id = ByteUtils.bytesToInt(entry.getValue());
                    array.add(id);
                }
            }
            catch (TreeInconsistencyException e) {
                ReferenceStatus status = new ReferenceStatus(4, 104, "Range=[" + start + " to " + end + "]", e);
                throw new ReferenceException(status);
            }
        }
        finally {
            this.tree.endRead();
        }
        return array.toArray();
    }

    @Override
    public IReferenceIndex.Pair[] entries(int[] valueIds) {
        ArrayList<IReferenceIndex.Pair> pairs = new ArrayList<IReferenceIndex.Pair>();
        try {
            this.tree.beginRead();
            Set<Integer> ids = null;
            Iterator<Map.Entry<Key, byte[]>> iterator = this.tree.iterator(null, null);
            while (iterator.hasNext()) {
                LinkKey key;
                Map.Entry<Key, byte[]> entry = iterator.next();
                int id = ByteUtils.bytesToInt(entry.getValue());
                if (valueIds == null) {
                    key = (LinkKey)entry.getKey();
                    pairs.add(new IReferenceIndex.Pair(key, id));
                    continue;
                }
                if (ids == null) {
                    ids = this.createSet(valueIds);
                }
                if (!ids.contains(id)) continue;
                key = (LinkKey)entry.getKey();
                pairs.add(new IReferenceIndex.Pair(key, id));
            }
        }
        finally {
            this.tree.endRead();
        }
        return pairs.toArray(new IReferenceIndex.Pair[pairs.size()]);
    }

    private Set<Integer> createSet(int[] ints) {
        HashSet<Integer> s = new HashSet<Integer>(ints.length);
        int i = 0;
        while (i < ints.length) {
            s.add(ints[i]);
            ++i;
        }
        return s;
    }

    @Override
    public void delete() {
        this.tree.delete();
    }

    @Override
    public void recreate() {
        this.tree.recreate();
    }

    @Override
    public void reload() {
        this.tree.reload();
    }

    @Override
    public void print() {
        this.print(System.out, true);
    }

    @Override
    public void print(PrintStream stream, boolean includeLinks) {
        this.tree.printToStream(stream, false, includeLinks);
    }

    @Override
    public void close() {
        this.tree.close(true);
    }

    @Override
    public String toString() {
        return "Index: " + this.tree.getFile();
    }

    @Override
    public IReferenceIndex convertToDisk(IReferenceIndex targetIndex, IProgressMonitor monitor) {
        return this;
    }

    @Override
    public IReferenceIndex convertToHeap(IReferenceIndex targetIndex, IProgressMonitor monitor) {
        if (targetIndex instanceof DiskBasedReferenceIndex) {
            Assert.isTrue((boolean)false, (String)Messages.DiskBasedReferenceIndex_0);
        }
        try {
            this.tree.beginRead();
            int size = this.tree.getSize();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
            Iterator<Map.Entry<Key, byte[]>> entryItr = this.tree.iterator(null, null);
            targetIndex.addAll(entryItr, true, (IProgressMonitor)sub.newChild(size), size);
        }
        finally {
            this.tree.endRead();
        }
        return targetIndex;
    }

    @Override
    public void sync() {
        this.tree.sync();
    }

    @Override
    public void printCacheStats(PrintStream out) {
        this.tree.printCacheStats(out);
    }

    @Override
    public void resetCacheStats() {
        this.tree.resetCacheStats();
    }

    @Override
    public void clearCache() {
        this.tree.clearCache();
    }

    @Override
    public void drainCache(boolean immediate) {
        this.tree.drainCache(immediate);
    }

    @Override
    public int getSize() {
        return this.tree.getSize();
    }

    public BPTree getTree() {
        return this.tree;
    }

    @Override
    public long getTotalUsedBytes() {
        return this.getTree().getTotalUsedBytes();
    }

    @Override
    public long getTotalAllocatedBytes() {
        return this.getTree().getAllocatedBytes();
    }
}

