/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.index;

import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;

public class CountedString
extends InternalReferenceRecord {
    private String string;
    private int count;
    private boolean dirty;

    public CountedString(int dataType) {
        super(dataType);
    }

    public void setString(String string) {
        this.string = string;
        this.dirty = true;
    }

    public String getString() {
        return this.string;
    }

    public void setCount(int count) {
        this.count = count;
        this.dirty = true;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    protected void clean() {
        this.dirty = false;
    }

    @Override
    public void doReadRecord(PooledByteBuffer buffer) {
        this.count = ByteUtils.bytesToUnsignedShort(buffer.buffer);
        this.string = ByteUtils.bytesToString(buffer.buffer);
        buffer.returnBuffer();
    }

    @Override
    public int getSize() {
        return ByteUtils.storageSize(this.string) + 2;
    }

    @Override
    public PooledByteBuffer doWriteRecord() {
        PooledByteBuffer buffer = PooledByteBuffer.INSTANCE.leaseByteBuffer(this.getSize());
        buffer.buffer.put(ByteUtils.unsignedShortToBytes(this.count));
        buffer.buffer.put(ByteUtils.stringToBytes(this.string));
        buffer.buffer.rewind();
        return buffer;
    }

    @Override
    protected InternalReferenceObject getLinkArtifact() {
        return null;
    }

    @Override
    public String toString() {
        return "[ID: " + this.getId() + " ] CountedString: count=" + this.count + ", string=" + this.string;
    }
}

