/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.cache;

import com.ibm.etools.references.internal.cache.Cache;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends Cache<K, V> {
    private final LruLinkedHashMap LRU = new LruLinkedHashMap();

    public LRUCache(int size) {
        super(size);
    }

    @Override
    public final V get(K key) {
        Object value = this.LRU.get(key);
        if (value != null) {
            ++this.hits;
        }
        ++this.accesses;
        return value;
    }

    @Override
    public V remove(K key) {
        Object val = this.LRU.remove(key);
        if (val != null) {
            this.removeFromCache(key, val);
        }
        return val;
    }

    @Override
    public V put(K key, V value) {
        return this.LRU.put(key, value);
    }

    @Override
    public final Collection<V> values() {
        return this.LRU.values();
    }

    @Override
    protected void removeFromCache(K key, V value) {
    }

    @Override
    public final void clear() {
        super.clear();
        this.LRU.clear();
    }

    public class LruLinkedHashMap
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        public LruLinkedHashMap() {
            super(LRUCache.this.size, 1.0f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() > LRUCache.this.size) {
                LRUCache.this.removeFromCache(eldest.getKey(), eldest.getValue());
                return true;
            }
            return false;
        }
    }
}

