/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.tree;

import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.BPTree;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.TreeInconsistencyException;
import com.ibm.etools.references.internal.nls.Messages;
import java.nio.ByteBuffer;
import org.eclipse.osgi.util.NLS;

public class OverflowedKeyRecord
extends DBRecord {
    private final BPTree tree;
    private ByteBuffer overflowKeyData;
    int refCount = -1;

    public OverflowedKeyRecord(int dataType, BPTree tree) {
        super(dataType);
        this.tree = tree;
    }

    @Override
    public void readRecord(PooledByteBuffer input) {
        this.refCount = input.buffer.getInt();
        this.overflowKeyData = input.copy();
        input.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeRecord() {
        this.overflowKeyData.rewind();
        PooledByteBuffer buffer = PooledByteBuffer.INSTANCE.leaseByteBuffer(4 + this.overflowKeyData.limit());
        buffer.buffer.putInt(this.refCount);
        buffer.buffer.put(this.overflowKeyData);
        buffer.buffer.rewind();
        return buffer;
    }

    @Override
    public int getSize() {
        return 4 + this.overflowKeyData.limit();
    }

    public void setOverflowKeyData(ByteBuffer keyData) {
        this.overflowKeyData = keyData;
    }

    public ByteBuffer getCopyOverflowKeyData() {
        this.overflowKeyData.rewind();
        return this.overflowKeyData.duplicate();
    }

    public ByteBuffer getOverflowKeyData() {
        this.overflowKeyData.rewind();
        return this.overflowKeyData.duplicate();
    }

    @Override
    public String toString() {
        Key key = this.tree.factory.createKey();
        int size = this.tree.factory.getAverageSize();
        int keysize = this.overflowKeyData.limit();
        int ammount = keysize - size;
        key.readKeyData(new PooledByteBuffer(this.getOverflowKeyData()));
        return String.valueOf(super.toString()) + " Overflowed key: " + key + " (by " + ammount + "bytes)";
    }

    public void increment() {
        ++this.refCount;
        this.save();
    }

    public void decrement() {
        --this.refCount;
        if (this.refCount == 0) {
            try {
                this.tree.getOverflowExtents().delete(this);
            }
            catch (RuntimeException e) {
                throw new TreeInconsistencyException(String.valueOf(Messages.bTreeMsg_exception_during_delete_of_overflow_record_x) + this.getId(), e);
            }
        } else {
            this.save();
        }
    }

    public void save() {
        try {
            this.tree.getOverflowExtents().update(this);
        }
        catch (RuntimeException e) {
            throw new TreeInconsistencyException(NLS.bind((String)Messages.bTreeMsg_exception_during_update_of_overflow_record_x, (Object)this.getId()), e);
        }
    }

    public void init() {
        this.refCount = 1;
    }
}

