/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.tree;

import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.BPTree;
import com.ibm.etools.references.internal.bplustree.tree.Key;
import com.ibm.etools.references.internal.bplustree.tree.OverflowedKeyRecord;
import com.ibm.etools.references.internal.nls.Messages;
import java.nio.ByteBuffer;
import org.eclipse.core.runtime.Assert;

public class KeyInfo {
    private final BPTree tree;
    private PooledByteBuffer keyData;
    private ByteBuffer overflowData;
    private ByteBuffer actualData;
    boolean isproxy = false;
    private boolean isoverflowed = false;
    private int overflowId = -1;

    public KeyInfo(BPTree tree) {
        this.tree = tree;
    }

    public KeyInfo(OverflowedKeyRecord record, BPTree tree) {
        this.tree = tree;
        this.overflowId = record.getId();
        this.isproxy = true;
        this.isoverflowed = true;
    }

    public KeyInfo(PooledByteBuffer writeKeyData, BPTree tree) {
        this.tree = tree;
        if (tree.factory.getSize() == -1) {
            this.isproxy = true;
            if (writeKeyData.buffer.limit() > tree.factory.getAverageSize()) {
                this.isoverflowed = true;
                PooledByteBuffer buf = PooledByteBuffer.INSTANCE.leaseByteBuffer(5);
                buf.buffer.put((byte)1);
                buf.buffer.rewind();
                this.setKeyData(buf);
                this.overflowData = writeKeyData.copy();
            } else {
                PooledByteBuffer buf = PooledByteBuffer.INSTANCE.leaseByteBuffer(1 + writeKeyData.buffer.remaining());
                buf.buffer.put((byte)0);
                buf.buffer.put(writeKeyData.copy());
                buf.buffer.rewind();
                this.setKeyData(buf);
            }
        } else {
            this.setKeyData(writeKeyData.duplicate());
        }
    }

    public void dispose() {
        if (this.keyData != null) {
            this.keyData.returnBuffer();
            this.keyData = null;
        }
        if (this.overflowData != null) {
            this.overflowData = null;
        }
        this.actualData = null;
    }

    public ByteBuffer getActual() {
        if (this.isproxy) {
            if (this.isoverflowed) {
                this.keyData.buffer.rewind();
                byte overflowed = this.keyData.buffer.get();
                if (overflowed == 1) {
                    if (this.overflowId == -1) {
                        this.overflowData.rewind();
                        return this.overflowData.duplicate();
                    }
                    OverflowedKeyRecord record = (OverflowedKeyRecord)this.tree.getOverflowExtents().readRecord(this.overflowId);
                    if (record != null) {
                        ByteBuffer overflowData = record.getCopyOverflowKeyData();
                        return overflowData;
                    }
                    return null;
                }
                return this.keyData.buffer.slice();
            }
            if (this.actualData == null) {
                ByteBuffer data = this.keyData.buffer.duplicate();
                data.position(1);
                this.actualData = data.slice();
            }
        } else if (this.actualData == null) {
            ByteBuffer dup = this.keyData.buffer.duplicate();
            dup.rewind();
            this.actualData = dup.slice();
        }
        this.actualData.rewind();
        return this.actualData;
    }

    public void commit() {
        if (this.isoverflowed) {
            if (this.overflowId == -1) {
                OverflowedKeyRecord record = (OverflowedKeyRecord)this.tree.keyFactory.createRecord(3, null);
                record.refCount = 0;
                this.overflowData.rewind();
                record.setOverflowKeyData(this.overflowData);
                record.increment();
                this.overflowId = record.getId();
                this.keyData.buffer.putInt(1, this.overflowId);
                this.overflowData = null;
            } else {
                OverflowedKeyRecord record = (OverflowedKeyRecord)this.tree.getOverflowExtents().readRecord(this.overflowId);
                record.increment();
            }
        }
    }

    public void increment() {
        if (this.isoverflowed) {
            if (this.overflowId == -1) {
                OverflowedKeyRecord record = (OverflowedKeyRecord)this.tree.keyFactory.createRecord(3, null);
                this.overflowData.rewind();
                record.setOverflowKeyData(this.overflowData);
                record.increment();
                this.overflowId = record.getId();
                this.keyData.buffer.putInt(1, this.overflowId);
                this.overflowData = null;
            } else {
                OverflowedKeyRecord record = (OverflowedKeyRecord)this.tree.getOverflowExtents().readRecord(this.overflowId);
                record.increment();
            }
        }
    }

    public void decrement() {
        if (this.isoverflowed) {
            if (this.overflowId == -1) {
                Assert.isLegal((boolean)false, (String)Messages.bTreeMsg_can_not_decrement_deleted_or_new_key);
            } else {
                OverflowedKeyRecord record = (OverflowedKeyRecord)this.tree.getOverflowExtents().readRecord(this.overflowId);
                record.decrement();
            }
        }
    }

    final void setKeyData(PooledByteBuffer keyData) {
        if (this.keyData != null) {
            this.keyData.returnBuffer();
        }
        this.keyData = keyData;
    }

    ByteBuffer writeKeyData() {
        this.keyData.buffer.rewind();
        ByteBuffer b = this.keyData.buffer;
        return b;
    }

    public Key getKey() {
        ByteBuffer actual = this.getActual();
        Key key = this.tree.factory.createKey();
        try {
            key.readKeyData(new PooledByteBuffer(actual));
        }
        catch (RuntimeException runtimeException) {
            key = null;
        }
        return key;
    }

    public String toString() {
        Key key = this.getKey();
        if (this.isproxy) {
            if (this.isoverflowed) {
                return "[V] " + key + " (Proxy: OID=" + this.overflowId + ") ";
            }
            return "[V] " + key;
        }
        return "[NV] " + key;
    }
}

