/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.tree;

import java.nio.ByteBuffer;

public class ByteUtils {
    public static final int NULL_SHORT = 65535;
    private static final byte[] TRUE = new byte[]{1};
    private static final byte[] FALSE = new byte[1];

    public static final int doubleUnsignedShortToInt(int short1, int short2) {
        int one = (short1 & 0xFF00) >> 8;
        int two = short1 & 0xFF;
        int three = (short2 & 0xFF00) >> 8;
        int four = short2 & 0xFF;
        int result = one << 24 | two << 16 | three << 8 | four;
        return result;
    }

    public static int intToFirstUnsignedShort(int integer) {
        return (integer & 0xFFFF0000) >>> 16;
    }

    public static int intToSecondUnsignedShort(int integer) {
        return integer & 0xFFFF;
    }

    public static int setSecondUnsignedShort(int source, int short2) {
        int masked = source & 0xFFFF0000;
        int high = short2 & 0xFFFF;
        int result = masked | high;
        return result;
    }

    public static final int[] intToUnsignedShorts(int integer) {
        int extentId = ByteUtils.intToFirstUnsignedShort(integer);
        int recId = integer & 0xFFFF;
        return new int[]{extentId, recId};
    }

    public static final int bytesToUnsignedShort(ByteBuffer buffer) {
        int firstByte = 0xFF & buffer.get();
        int secondByte = 0xFF & buffer.get();
        int result = firstByte << 8 | secondByte;
        return result;
    }

    public static final ByteBuffer unsignedShortToBytes(int theShort) {
        byte[] buf = new byte[]{(byte)((theShort & 0xFF00) >> 8), (byte)(theShort & 0xFF)};
        return ByteBuffer.wrap(buf);
    }

    public static final ByteBuffer intToBytes(int i) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(i);
        buffer.rewind();
        return buffer;
    }

    public static final int bytesToInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static final int bytesToInt(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public static final ByteBuffer booleanToBytes(boolean b) {
        return b ? ByteBuffer.wrap(TRUE) : ByteBuffer.wrap(FALSE);
    }

    public static final boolean bytesToBoolean(ByteBuffer buffer) {
        byte s = buffer.get();
        return s == 1;
    }

    public static final int storageSize(String string) {
        int space = 2 + (string == null ? 0 : string.length() * 2);
        return space;
    }

    public static final ByteBuffer stringToBytes(String string) {
        int space = string == null ? 0 : string.length();
        ByteBuffer buffer = ByteBuffer.allocate(space * 2 + 2);
        buffer.put(ByteUtils.unsignedShortToBytes(string == null ? 65535 : space));
        if (string != null && string.length() > 0) {
            buffer.asCharBuffer().put(string);
        }
        buffer.rewind();
        return buffer;
    }

    public static final String bytesToString(ByteBuffer buffer) {
        int size = ByteUtils.bytesToUnsignedShort(buffer);
        if (size == 65535) {
            return null;
        }
        if (size == 0) {
            return "";
        }
        char[] chars = new char[size];
        buffer.asCharBuffer().get(chars);
        buffer.position(buffer.position() + size * 2);
        return new String(chars);
    }
}

