/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.internal.bplustree.db.FileHeader;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import org.eclipse.core.runtime.Assert;

public class UnsignedShortFileHeader
extends FileHeader {
    private int value = 0;
    private int def = 0;

    public UnsignedShortFileHeader(String name, int def) {
        super(name);
        Assert.isLegal((def >= 0 && def <= 65535 ? 1 : 0) != 0, (String)("Not a legal short: " + def));
        this.def = def;
        this.value = def;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "Value: " + this.value + " Default: " + this.def;
    }

    public int getHeaderValue() {
        return this.value;
    }

    @Override
    public short getSize() {
        return 2;
    }

    @Override
    public void readRecord(PooledByteBuffer bytes) {
        this.value = ByteUtils.bytesToUnsignedShort(bytes.buffer);
        bytes.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeRecord() {
        return new PooledByteBuffer(ByteUtils.unsignedShortToBytes(this.value));
    }

    public void setHeaderValue(int val) {
        Assert.isLegal((this.def >= 0 && this.def <= 65535 ? 1 : 0) != 0, (String)("Not a legal short: " + val));
        this.value = val;
    }

    @Override
    public void reset() {
        this.value = this.def;
    }
}

