/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.internal.bplustree.db.FileHeader;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import java.nio.ByteBuffer;

public class IntFileHeader
extends FileHeader {
    private int value = 0;
    private int def = 0;

    public IntFileHeader(String name, int def) {
        super(name);
        this.def = def;
        this.value = def;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "Value: " + this.value + " Default: " + this.def;
    }

    public int getHeaderValue() {
        return this.value;
    }

    @Override
    public short getSize() {
        return 4;
    }

    @Override
    public void readRecord(PooledByteBuffer bytes) {
        this.value = bytes.buffer.getInt();
        bytes.returnBuffer();
    }

    @Override
    public PooledByteBuffer writeRecord() {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(this.value);
        buf.rewind();
        return new PooledByteBuffer(buf);
    }

    public void setHeaderValue(int val) {
        this.value = val;
    }

    @Override
    public void reset() {
        this.value = this.def;
    }
}

