/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import java.util.Arrays;

public class IntArray {
    int[] array;
    int size;

    public IntArray() {
        this(10);
    }

    public IntArray(int size) {
        this.array = new int[size];
    }

    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    public void addSorted(int intToAdd) {
        int index;
        if (this.array.length == this.size) {
            this.grow(1);
        }
        int location = (index = Arrays.binarySearch(this.array, 0, this.size, intToAdd)) < 0 ? -index - 1 : index;
        System.arraycopy(this.array, location, this.array, location + 1, this.size - location);
        this.array[location] = intToAdd;
        ++this.size;
    }

    public void add(int intToAdd) {
        if (this.array.length == this.size) {
            this.grow(1);
        }
        this.array[this.size] = intToAdd;
        ++this.size;
    }

    public void addAll(int[] intsToAdd) {
        if (this.array.length <= this.size + intsToAdd.length) {
            this.grow(intsToAdd.length);
        }
        System.arraycopy(intsToAdd, 0, this.array, this.size, intsToAdd.length);
        this.size += intsToAdd.length;
    }

    public void remove(int id) {
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] == id) {
                if (i + 1 < this.array.length) {
                    System.arraycopy(this.array, i + 1, this.array, i, this.size - i);
                }
                --this.size;
                break;
            }
            ++i;
        }
    }

    public int[] toArray() {
        int[] newarray = new int[this.size];
        if (this.size != 0) {
            System.arraycopy(this.array, 0, newarray, 0, this.size);
        }
        return newarray;
    }

    private void grow(int required) {
        int increment = this.size / 2;
        if (increment < 12) {
            increment = 12;
        }
        if (required > increment) {
            increment = required;
        }
        int[] newarray = new int[this.size + increment];
        System.arraycopy(this.array, 0, newarray, 0, this.size);
        this.array = newarray;
    }

    public static void main(String[] args) {
        IntArray array = new IntArray(1);
        array.add(1);
        array.add(3);
        array.add(4);
        array.add(5);
        array.addSorted(2);
        array.addSorted(0);
        array.addSorted(8);
        array.toArray();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

