/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.InternalReferencesJob;
import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.DBRecordFactory;
import com.ibm.etools.references.internal.bplustree.db.Extent;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.FileHeader;
import com.ibm.etools.references.internal.bplustree.db.IntFileHeader;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.db.SplitRecord;
import com.ibm.etools.references.internal.bplustree.db.UnsignedShortFileHeader;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.bplustree.tree.Node;
import com.ibm.etools.references.internal.cache.ARCCache;
import com.ibm.etools.references.internal.cache.Cache;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.management.ReferenceException;
import java.io.File;
import java.io.PrintStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ExtentManager {
    private final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock.WriteLock write;
    private final ReentrantReadWriteLock.ReadLock read;
    private final WriteBack writeBack = new WriteBack();
    private final int cacheSize;
    private final Cache<Integer, DBRecordFuture> recordCache;
    private final ReentrantLock cacheLock = new ReentrantLock();
    private final HashMap<Integer, RecordWeakRefernece<DBRecord>> activeObjects;
    private int totalExtents = 0;
    private int bytesPerExtent;
    private int slotSize;
    private List<FileHeader> allHeaders;
    private final List<? extends FileHeader> otherHeaders;
    private final HashMap<Integer, Extent> extents;
    private final File file;
    private final DBRecordFactory factory;
    private final float loadFactor;
    private final boolean originalCreateMode;
    private final ReferenceQueue<DBRecord> queue = new ReferenceQueue();
    private boolean bptree = false;
    private static final float LOAD_FACTOR = 0.75f;

    public ExtentManager(File file, DBRecordFactory factory, int bytesPerExtent, List<? extends FileHeader> headers, boolean create) throws FatalIOException {
        this(file, factory, bytesPerExtent, headers, 0.75f, create);
    }

    public ExtentManager(File index, DBRecordFactory factory, int extentSize, List<? extends FileHeader> headers, float load, boolean create) throws FatalIOException {
        this(0, index, factory, extentSize, headers, load, create, new ReentrantReadWriteLock());
    }

    public ExtentManager(int cacheSize, File index, DBRecordFactory directNodeFileFactory, int extentSize, List<? extends FileHeader> headers, float load, boolean create, ReentrantReadWriteLock lock) {
        Assert.isNotNull((Object)index);
        Assert.isNotNull((Object)directNodeFileFactory);
        Assert.isNotNull((Object)lock);
        this.lock = lock;
        this.write = lock.writeLock();
        this.read = lock.readLock();
        this.cacheSize = cacheSize;
        this.activeObjects = new HashMap();
        this.extents = new HashMap();
        this.file = index;
        this.factory = directNodeFileFactory;
        this.loadFactor = load;
        this.otherHeaders = headers;
        this.slotSize = this.calculateSlotSize(this.factory);
        this.bytesPerExtent = extentSize;
        this.init(create);
        this.originalCreateMode = create;
        this.recordCache = new RecordCache<Integer, DBRecordFuture>();
    }

    private void init(boolean create) throws FatalIOException {
        this.allHeaders = new ArrayList<FileHeader>();
        this.allHeaders.addAll(this.createHeaders(this.slotSize, this.bytesPerExtent));
        this.allHeaders.addAll(this.otherHeaders);
        for (FileHeader header : this.allHeaders) {
            header.reset();
        }
        int slots = this.bytesPerExtent / this.slotSize;
        Extent e = this.createNewExtent(create, 0, slots, this.allHeaders);
        e.ensureOpen();
        this.loadHeaders();
    }

    private int calculateSlotSize(DBRecordFactory factory) {
        int[] types;
        int size = 0;
        int[] nArray = types = factory.recordTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            int fSize = factory.getSize(type);
            size = fSize == -1 ? Math.max(3 + factory.getAverageSize(type), size) : Math.max(size, factory.getSize(type));
            ++n2;
        }
        return size;
    }

    private List<? extends FileHeader> createHeaders(int minimumRecordSize, int bytesPerExtent) {
        ArrayList<FileHeader> fh = new ArrayList<FileHeader>();
        fh.add(new IntFileHeader("Minimum record size", minimumRecordSize));
        fh.add(new IntFileHeader("Records/extent", bytesPerExtent));
        fh.add(new UnsignedShortFileHeader("Total Extents", 1));
        return fh;
    }

    private void loadHeaders() {
        this.slotSize = ((IntFileHeader)this.allHeaders.get(0)).getHeaderValue();
        this.bytesPerExtent = ((IntFileHeader)this.allHeaders.get(1)).getHeaderValue();
        this.totalExtents = ((UnsignedShortFileHeader)this.allHeaders.get(2)).getHeaderValue();
    }

    private void saveHeaders() {
        ((IntFileHeader)this.allHeaders.get(0)).setHeaderValue(this.slotSize);
        ((IntFileHeader)this.allHeaders.get(1)).setHeaderValue(this.bytesPerExtent);
        ((UnsignedShortFileHeader)this.allHeaders.get(2)).setHeaderValue(this.totalExtents);
    }

    public DBRecordFactory getFactory() {
        return this.factory;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extent createNewExtent(boolean create, int id, int capacity, List<FileHeader> headers) throws FatalIOException {
        HashMap<Integer, Extent> hashMap = this.extents;
        synchronized (hashMap) {
            Extent previous = null;
            if (id > 0) {
                previous = this.getExtent(id - 1);
            }
            Extent e = new Extent(this, id, capacity, headers, create, previous);
            this.extents.put(id, e);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Extent getExtent(int extentid) throws FatalIOException {
        if (extentid < 0) {
            return null;
        }
        if (extentid > this.totalExtents - 1) {
            return null;
        }
        HashMap<Integer, Extent> hashMap = this.extents;
        synchronized (hashMap) {
            Extent e = this.extents.get(extentid);
            if (e == null) {
                int slots = this.bytesPerExtent / this.slotSize;
                e = this.createNewExtent(this.originalCreateMode, extentid, slots, Collections.<FileHeader>emptyList());
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DBRecord record) throws FatalIOException {
        DBRecord dBRecord = record;
        synchronized (dBRecord) {
            if (record.isStale()) {
                throw new FatalIOException(Messages.bTreeMsg_stalerecord, null);
            }
        }
        try {
            RunnableFuture oldFuture;
            this.write.lock();
            try {
                this.cacheLock.lock();
                record.setDeleteme(true);
                oldFuture = this.recordCache.remove(record.getId());
            }
            finally {
                this.cacheLock.unlock();
            }
            DBRecord oldRecord = this.getResult(oldFuture);
            if (oldRecord == null || oldRecord == record) {
                this.writeBack.addRecord(record);
            } else {
                Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "A different record with same id exists in cache");
                this.writeBack.addRecord(record);
                oldRecord.setDeleteme(true);
                this.writeBack.addRecord(oldRecord);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void realDelete(DBRecord record) throws FatalIOException, InterruptedException {
        DBRecord dBRecord = record;
        synchronized (dBRecord) {
            if (record.isStale()) {
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_tried_to_delete_stale_X_Y, (Object)record.getId(), (Object)record.toDebugString()), null);
            }
            if (record.isDeleted()) {
                return;
            }
            try {
                this.write.lock();
                this.cacheLock.lockInterruptibly();
                try {
                    this.put(record);
                    int[] ints = ByteUtils.intToUnsignedShorts(record.getId());
                    Extent e = this.getExtent(ints[0]);
                    if (e == null) {
                        throw new FatalIOException(Messages.bTreeMsg_recordmissingextent, null);
                    }
                    e.delete(ints[1]);
                    record.setRecordDeleted(true);
                    record.dispose();
                }
                finally {
                    this.cacheLock.unlock();
                }
            }
            finally {
                this.write.unlock();
            }
        }
    }

    private List<DBRecord> splitRecordPayload(DBRecord payload, PooledByteBuffer buffer) {
        int origLimit = buffer.buffer.limit();
        int remainingCapacity = buffer.buffer.remaining();
        int segs = this.getNeededSplitRecords(remainingCapacity);
        List<DBRecord> splitPayload = null;
        if (segs == 1) {
            splitPayload = Collections.singletonList(payload);
        } else {
            splitPayload = new ArrayList<DBRecord>();
            int pos = 0;
            int chunk = this.slotSize - 3;
            int length = pos + chunk;
            buffer.buffer.limit(length);
            buffer.buffer.position(pos);
            SplitRecord begin = new SplitRecord(-2);
            begin.originalDataType = payload.getDataType();
            begin.nextRecord = 65535;
            begin.setOriginalBuffer(buffer);
            splitPayload.add(begin);
            pos += chunk;
            int i = 1;
            while (i < segs - 1) {
                chunk = this.slotSize - 2;
                length = pos + chunk;
                buffer.buffer.limit(length);
                buffer.buffer.position(pos);
                SplitRecord middle = new SplitRecord(-3);
                middle.nextRecord = 65535;
                middle.setOriginalBuffer(buffer);
                splitPayload.add(middle);
                pos += chunk;
                ++i;
            }
            length = Math.min(pos + this.slotSize, origLimit);
            buffer.buffer.limit(length);
            buffer.buffer.position(pos);
            SplitRecord end = new SplitRecord(-4);
            end.setOriginalBuffer(buffer);
            splitPayload.add(end);
            pos += length;
        }
        return splitPayload;
    }

    private int getNeededSplitRecords(int totalBytes) {
        if (totalBytes <= this.slotSize) {
            return 1;
        }
        int segs = 1;
        if ((totalBytes -= this.slotSize - 3) < 0) {
            totalBytes = 0;
        }
        segs += totalBytes / (this.slotSize - 2);
        if ((totalBytes %= this.slotSize - 2) > 0) {
            ++segs;
        }
        return segs;
    }

    public void update(DBRecord record) throws FatalIOException {
        block16: {
            if (record.isStale()) {
                Assert.isTrue((boolean)false, (String)Messages.bTreeMsg_stalerecord);
            }
            if (record.isDeleteme()) {
                return;
            }
            if (!record.isDirty()) {
                return;
            }
            try {
                this.write.lock();
                if (record.getId() == -1) {
                    this.assignId(record);
                }
                if (this.cacheSize > 0) {
                    try {
                        this.cacheLock.lock();
                        RunnableFuture fromCache = this.recordCache.get(record.getId());
                        DBRecord old = this.getResult(fromCache);
                        if (old != null) {
                            if (old.isDeleted() || old.isStale() || old.isDisposed()) {
                                DBRecordFuture task = this.createRecordHolderTask(record);
                                this.recordCache.put(record.getId(), task);
                            }
                        } else {
                            DBRecord rec;
                            RecordWeakRefernece<DBRecord> weakRef = this.activeObjects.get(record.getId());
                            DBRecord dBRecord = rec = weakRef == null ? null : (DBRecord)weakRef.get();
                            if (weakRef != null && rec != null) {
                                DBRecordFuture task = this.createRecordHolderTask(rec);
                                this.recordCache.put(record.getId(), task);
                            } else {
                                Assert.isTrue((boolean)false, (String)Messages.bTreeMsg_recordmissinginobjtracker);
                            }
                        }
                        break block16;
                    }
                    finally {
                        this.cacheLock.unlock();
                    }
                }
                throw new RuntimeException("Cache size of at least 1 is necessary");
            }
            finally {
                this.write.unlock();
            }
        }
    }

    private DBRecordFuture createRecordHolderTask(DBRecord rec) {
        return new DBRecordHolder(rec);
    }

    private DBRecordFuture createRecordRetrieval(int id, boolean fullyRead) {
        return new LoadDBRecordTask(this, id, fullyRead);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    int realUpdate(DBRecord record) throws FatalIOException, InterruptedException {
        DBRecord dBRecord = record;
        synchronized (dBRecord) {
            if (record.isDeleted()) {
                return 65535;
            }
            if (record.isStale()) {
                throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_tried_to_update_stale_X_Y, (Object)record.getId(), (Object)record.toDebugString()), null);
            }
            if (Logger.SHOULD_TRACE_EXTENT_MANAGER_DETAILED) {
                try {
                    Logger.trace(Logger.Category.EXTENT_MANAGER_DETAILED, "Updating " + record.toDebugString(), new Throwable[0]);
                }
                catch (Exception exception) {}
            }
            if (record.getId() != -1 && !record.isFullyLoaded()) {
                this.cacheLock.lockInterruptibly();
                try {
                    this.put(record);
                }
                finally {
                    this.cacheLock.unlock();
                }
                return record.getId();
            }
            if (!record.isDirty() && record.getId() != -1) {
                this.cacheLock.lockInterruptibly();
                try {
                    this.put(record);
                }
                finally {
                    this.cacheLock.unlock();
                }
                return record.getId();
            }
            try {
                int n;
                this.write.lock();
                this.cacheLock.lockInterruptibly();
                try {
                    n = this.performUpdate(record);
                    this.cacheLock.unlock();
                }
                catch (Throwable throwable) {
                    this.cacheLock.unlock();
                    throw throwable;
                }
                return n;
            }
            finally {
                this.write.unlock();
            }
        }
    }

    private int performUpdate(DBRecord record) {
        int[] ints = ByteUtils.intToUnsignedShorts(record.getId());
        int recId = ints[1];
        int extentId = ints[0];
        PooledByteBuffer payload = record.writeRecord();
        Assert.isNotNull((Object)payload, (String)Messages.bTreeMsg_recordreturnednulldata);
        record.setCommited(true);
        if (recId == 65535) {
            List<DBRecord> records = this.splitRecordPayload(record, payload);
            Extent free = this.createOrGetFreeExtent(records.size());
            free.writeRecords(records, payload);
            record.setId(ByteUtils.doubleUnsignedShortToInt(free.getId(), ByteUtils.intToUnsignedShorts(records.get(0).getId())[1]));
            record.setAssignedNew(false);
            record.clean();
            this.put(record);
            return record.getId();
        }
        Extent pointerExtent = null;
        SplitRecord pointer = null;
        int[] pointerData = null;
        if (record.pointerToActual != 65535) {
            pointerData = ByteUtils.intToUnsignedShorts(record.pointerToActual);
            pointerExtent = this.getExtent(pointerData[0]);
            Assert.isNotNull((Object)("Pointer refers to non-existant extent: " + pointerData[0]));
            pointer = this.getExtent(extentId).readSplitRecord(recId);
            Assert.isNotNull((Object)("Pointer record refers to non-existant record: " + pointerData[1]));
        }
        Extent originalExtent = this.getExtent(extentId);
        List<DBRecord> records = this.splitRecordPayload(record, payload);
        int[] oldSplits = record.isAssignedNew() ? new int[]{record.getId()} : (pointerData != null ? pointerExtent.readSplitIds(pointerData[1]) : originalExtent.readSplitIds(recId));
        int recordDifference = records.size() - (oldSplits.length == 0 ? 1 : oldSplits.length);
        if (recordDifference > 0 && !this.canHoldUpdateRecords(pointerExtent == null ? originalExtent : pointerExtent, recordDifference)) {
            Extent free = this.createOrGetFreeExtent(records.size());
            free.writeRecords(records, payload);
            pointer = originalExtent.convertToExtentPointer(record, free.getId(), ByteUtils.intToUnsignedShorts(records.get(0).getId())[1]);
            if (pointerExtent != null) {
                int[] nArray = oldSplits;
                int n = oldSplits.length;
                int n2 = 0;
                while (n2 < n) {
                    int record2 = nArray[n2];
                    pointerExtent.deleteSingle(ByteUtils.intToUnsignedShorts(record2)[1]);
                    ++n2;
                }
            } else {
                int i = 1;
                while (i < oldSplits.length) {
                    originalExtent.deleteSingle(ByteUtils.intToUnsignedShorts(oldSplits[i])[1]);
                    ++i;
                }
            }
        } else {
            int i;
            if (oldSplits.length == 0) {
                records.get(0).setRecordId(recId);
            } else if (records.size() > 1) {
                i = 0;
                while (i < records.size() && i < oldSplits.length) {
                    records.get(i).setRecordId(ByteUtils.intToUnsignedShorts(oldSplits[i])[1]);
                    if (i < oldSplits.length - 1) {
                        int nextRecord = oldSplits[i + 1];
                        ((SplitRecord)records.get((int)i)).nextRecord = ByteUtils.intToUnsignedShorts(nextRecord)[1];
                    } else {
                        ((SplitRecord)records.get((int)i)).nextRecord = 65535;
                    }
                    ++i;
                }
            }
            if (pointerExtent != null) {
                if (records.size() == 1) {
                    records.get(0).setId(record.getId());
                    originalExtent.writeRecords(records, payload);
                    i = 0;
                    while (i < oldSplits.length) {
                        pointerExtent.deleteSingle(ByteUtils.intToUnsignedShorts(oldSplits[i])[1]);
                        ++i;
                    }
                } else {
                    pointerExtent.writeRecords(records, payload);
                    i = records.size();
                    while (i < oldSplits.length) {
                        pointerExtent.deleteSingle(ByteUtils.intToUnsignedShorts(oldSplits[i])[1]);
                        ++i;
                    }
                }
            } else {
                originalExtent.writeRecords(records, payload);
                i = records.size();
                while (i < oldSplits.length) {
                    originalExtent.deleteSingle(ByteUtils.intToUnsignedShorts(oldSplits[i])[1]);
                    ++i;
                }
            }
        }
        record.setAssignedNew(false);
        record.clean();
        this.put(record);
        return record.getId();
    }

    private int getNewSize(int startingSize) {
        return (int)Math.ceil((float)startingSize / this.loadFactor);
    }

    private boolean canHoldNewRecords(Extent e, int requiredSlots) {
        int newsize = e.getSlotUsage() + requiredSlots;
        if (newsize > e.getSlotsCapacity()) {
            return false;
        }
        float fillPercent = (float)newsize / (float)e.getSlotsCapacity();
        return fillPercent <= this.loadFactor;
    }

    private boolean canHoldUpdateRecords(Extent e, int requiredSlots) {
        int newsize = e.getSlotUsage() + requiredSlots;
        return newsize <= e.getSlotsCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extent createOrGetFreeExtent(int requiredSlots) throws FatalIOException {
        Extent freeExtent = null;
        HashMap<Integer, Extent> hashMap = this.extents;
        synchronized (hashMap) {
            for (Extent extent : this.extents.values()) {
                if (!this.canHoldNewRecords(extent, requiredSlots)) continue;
                freeExtent = extent;
                break;
            }
            if (freeExtent == null) {
                int slots = this.bytesPerExtent / this.slotSize;
                freeExtent = this.createNewExtent(true, this.totalExtents, Math.max(this.getNewSize(requiredSlots), slots), Collections.<FileHeader>emptyList());
                ++this.totalExtents;
            }
        }
        return freeExtent;
    }

    public void assignId(DBRecord record) throws FatalIOException {
        if (!record.isDirty() && record.getId() != -1) {
            return;
        }
        try {
            this.write.lock();
            boolean didassign = false;
            if (record.getId() == -1) {
                didassign = true;
                record.init(this);
                record.markLoaded();
                int neededBytes = record.getSize();
                int recordSize = this.getNeededSplitRecords(neededBytes);
                Extent e = this.createOrGetFreeExtent(recordSize);
                int recId = e.assignSlotId();
                int realId = ByteUtils.doubleUnsignedShortToInt(e.getId(), recId);
                record.setId(realId);
                record.setAssignedNew(true);
            }
            this.put(record);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(DBRecord record) {
        this.cacheLock.lock();
        try {
            DBRecord old;
            RecordWeakRefernece<DBRecord> existing = this.activeObjects.put(record.getId(), new RecordWeakRefernece<DBRecord>(record.getId(), record, this.queue));
            if (existing != null && (old = (DBRecord)existing.get()) != null && old != record) {
                DBRecord dBRecord = old;
                synchronized (dBRecord) {
                    if (!old.isDisposed()) {
                        old.dispose();
                    }
                }
                if (Logger.SHOULD_TRACE_EXTENT_MANAGER_DETAILED) {
                    Logger.trace(Logger.Category.EXTENT_MANAGER_DETAILED, "Recycling id: " + record.getId() + " for new object: " + record + " old: " + old, new Throwable[0]);
                }
            }
            RecordWeakRefernece ref = (RecordWeakRefernece)this.queue.poll();
            while (ref != null) {
                RecordWeakRefernece<DBRecord> old2 = this.activeObjects.remove(ref.getRecordId());
                if (old2 != null && old2.get() != null) {
                    this.activeObjects.put(old2.getRecordId(), old2);
                }
                ref = (RecordWeakRefernece)this.queue.poll();
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void setBPtree(boolean bptree) {
        this.bptree = bptree;
    }

    public boolean isBPTree() {
        return this.bptree;
    }

    public PooledByteBuffer allocate(DBRecord record) throws FatalIOException {
        try {
            this.write.lock();
            int[] id = ByteUtils.intToUnsignedShorts(record.getId());
            int rId = id[1];
            int eId = id[0];
            Extent e = this.getExtent(eId);
            PooledByteBuffer pooledByteBuffer = e.allocate(rId, (byte)record.getDataType());
            return pooledByteBuffer;
        }
        finally {
            this.write.unlock();
        }
    }

    int getSlotSize() {
        return this.slotSize;
    }

    public DBRecord readRecord(int id) throws FatalIOException {
        if (id == -1) {
            return null;
        }
        return this.readRecord(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DBRecord readRecord(int id, boolean fullRead) throws FatalIOException {
        while (true) {
            retrieval = null;
            createdRetrieval = false;
            if (this.cacheSize > 0) {
                try {
                    this.cacheLock.lock();
                    retrieval = this.recordCache.get(id);
                    if (retrieval == null) {
                        retrieval = this.createRecordRetrieval(id, fullRead);
                        createdRetrieval = true;
                        this.recordCache.put(id, retrieval);
                    }
                    if (fullRead && !retrieval.isFullRead()) {
                        retrieval = this.createRecordRetrieval(id, fullRead);
                        createdRetrieval = true;
                        this.recordCache.put(id, retrieval);
                    }
                    if (!(retrieval instanceof DBRecordHolder) || !(r = retrieval.getRecord()).isCommited() && !r.isDisposed()) ** GOTO lbl30
                    retrieval = this.createRecordRetrieval(id, fullRead);
                    createdRetrieval = true;
                    this.recordCache.put(id, retrieval);
                }
                finally {
                    this.cacheLock.unlock();
                }
            } else {
                retrieval = this.createRecordRetrieval(id, fullRead);
            }
lbl30:
            // 5 sources

            retrieval.run();
            actual = this.getResult(retrieval);
            if (actual == null) return actual;
            var6_6 = actual;
            synchronized (var6_6) {
                if (actual.isDeleted() != false) return null;
                if (actual.isDeleteme()) {
                    return null;
                }
                if (actual.isStale()) {
                    if (Logger.SHOULD_TRACE_EXTENT_MANAGER_DETAILED == false) return actual;
                    Logger.trace(Logger.Category.EXTENT_MANAGER_DETAILED, String.valueOf(Messages.bTreeMsg_stalerecord) + ": " + actual.toDebugString() + " created " + createdRetrieval, new Throwable[0]);
                    return actual;
                }
                if (actual.isCommited()) {
                    if (Logger.SHOULD_TRACE_EXTENT_MANAGER_DETAILED) {
                        Logger.trace(Logger.Category.EXTENT_MANAGER_DETAILED, String.valueOf(Messages.bTreeMsg_readacommitedrecord) + ": " + actual.toDebugString() + " created " + createdRetrieval, new Throwable[0]);
                    }
                    continue;
                }
                if (!actual.isDisposed()) {
                    if (fullRead == false) return actual;
                    if (actual.isFullyLoaded() != false) return actual;
                    Assert.isTrue((boolean)false, (String)(String.valueOf(Messages.ExtentManager_FullReadFailed) + ": " + actual.toDebugString() + " created " + createdRetrieval));
                    return actual;
                }
                if (Logger.SHOULD_TRACE_EXTENT_MANAGER_DETAILED) {
                    Logger.trace(Logger.Category.EXTENT_MANAGER_DETAILED, String.valueOf(Messages.ExtentManager_ReadADisposedRecord) + ": " + actual.toDebugString(), new Throwable[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(DBRecord record) {
        try {
            this.read.lock();
            try {
                this.cacheLock.lock();
                DBRecord dBRecord = record;
                synchronized (dBRecord) {
                    record.doLoadData();
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRecordFully(DBRecord record) throws FatalIOException {
        if (record.getId() == -1) {
            return;
        }
        DBRecord dBRecord = record;
        synchronized (dBRecord) {
            if (record.isDeleted() || record.isDeleteme()) {
                return;
            }
            if (record.isStale()) {
                return;
            }
        }
        DBRecord readRecord = this.readRecord(record.getId(), true);
        if (readRecord != record) {
            Assert.isTrue((boolean)false, (String)Messages.ExtentManager_RecordsDoNotMatch);
        }
    }

    /*
     * Exception decompiling
     */
    DBRecord realReadRecord(int id, boolean fullRead) throws FatalIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getTotalSlotsUsage() throws FatalIOException {
        this.drainCache(true);
        this.joinPendingWrites();
        int size = 0;
        try {
            this.read.lock();
            int i = 0;
            while (i < this.totalExtents) {
                size += this.getExtent(i).getSlotUsage();
                ++i;
            }
        }
        finally {
            this.read.unlock();
        }
        return size;
    }

    public int getExtents() {
        return this.totalExtents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws FatalIOException {
        try {
            this.write.lock();
            this.close(false);
            HashMap<Integer, Extent> hashMap = this.extents;
            synchronized (hashMap) {
                int i = this.totalExtents - 1;
                while (i >= 0) {
                    try {
                        Extent e = this.extents.get(i);
                        if (e != null) {
                            e.delete();
                        }
                    }
                    catch (RuntimeException ee) {
                        Status error = new Status(4, "com.ibm.etools.references", NLS.bind((String)Messages.bTreeMsg_exception_during_delete, (Object)i), (Throwable)ee);
                        Logger.log((IStatus)error);
                    }
                    --i;
                }
                this.extents.clear();
            }
        }
        finally {
            this.write.unlock();
        }
    }

    private void clearActive() {
        this.cacheLock.lock();
        try {
            for (Map.Entry<Integer, RecordWeakRefernece<DBRecord>> entry : this.activeObjects.entrySet()) {
                DBRecord r;
                RecordWeakRefernece<DBRecord> dbRecordHolder = entry.getValue();
                if (dbRecordHolder == null || (r = (DBRecord)dbRecordHolder.get()) == null) continue;
                r.setStale(true);
            }
            this.activeObjects.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void close(boolean flush) {
        if (flush) {
            this.drainCache(false);
            this.joinPendingWrites();
        } else {
            this.clearWriteBack();
        }
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        try {
            this.write.lock();
            this.clearWriteBack();
            this.clearActive();
            this.clearCache();
            this.saveHeaders();
            HashMap<Integer, Extent> hashMap = this.extents;
            synchronized (hashMap) {
                int i = this.totalExtents - 1;
                while (i >= 0) {
                    Extent e = this.extents.get(i);
                    if (e != null) {
                        try {
                            e.close();
                        }
                        catch (RuntimeException ee) {
                            Status error = new Status(4, "com.ibm.etools.references", NLS.bind((String)"Exception during close of [e={0}]", (Object)i), (Throwable)ee);
                            Logger.log((IStatus)error);
                        }
                    }
                    --i;
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws FatalIOException {
        this.drainCache(false);
        this.joinPendingWrites();
        try {
            this.write.lock();
            this.doClose();
            HashMap<Integer, Extent> hashMap = this.extents;
            synchronized (hashMap) {
                this.extents.clear();
            }
            this.init(false);
        }
        finally {
            this.write.unlock();
        }
    }

    public void recreate() throws FatalIOException {
        this.delete();
        this.init(true);
    }

    public void debugPrintRecords() {
        this.debugPrintRecords(System.out);
    }

    public void debugPrintRecords(PrintStream stream) {
        try {
            stream.println("AVERAGE RECORD SIZE: ");
            int total = 0;
            for (Extent e : this.extents.values()) {
                int i = e.getAvgRecordSize();
                stream.println("Extent: " + e.getId() + "AVG REG SIZE: " + i);
                total += i;
            }
            stream.println("AVERAGE FOR ALL: " + total / this.extents.values().size());
            stream.println("Dumping data: ");
            for (Extent e : this.extents.values()) {
                stream.println("Extent: " + e.getId());
                e.debugDumpRecords(stream);
            }
            for (Extent e : this.extents.values()) {
                stream.println("Extent: " + e.getId());
                e.debugPrintRecords(stream);
            }
        }
        catch (FatalIOException e) {
            e.printStackTrace(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecordUsedBytes() {
        long total = 0L;
        this.read.lock();
        try {
            HashMap<Integer, Extent> hashMap = this.extents;
            synchronized (hashMap) {
                int i = 0;
                while (i < this.totalExtents) {
                    total += this.getExtent(i).getRecordsSize();
                    ++i;
                }
            }
        }
        finally {
            this.read.unlock();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalAllocatedBytes() {
        long total = 0L;
        this.read.lock();
        try {
            HashMap<Integer, Extent> hashMap = this.extents;
            synchronized (hashMap) {
                int i = 0;
                while (i < this.totalExtents) {
                    total += this.getExtent(i).getAllocatedSize();
                    ++i;
                }
            }
        }
        finally {
            this.read.unlock();
        }
        return total;
    }

    public void debugRaw() {
        int i = 0;
        while (i < this.totalExtents) {
            System.out.println("Extent " + i);
            this.getExtent(i).debugRaw();
            System.out.println("");
            ++i;
        }
    }

    public List<Integer> debugGetRecIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Extent e : this.extents.values()) {
            ids.addAll(e.getIds());
        }
        return ids;
    }

    public void flush(Node node) {
    }

    public String toString() {
        return NLS.bind((String)"SlotSize={0}, BytesPerExtent={1}, TotalExtents={2}, File={3}", (Object[])new Object[]{this.slotSize, this.bytesPerExtent, this.totalExtents, this.file.getAbsolutePath()});
    }

    DBRecord getResult(RunnableFuture<DBRecord> record) throws FatalIOException {
        if (record == null) {
            return null;
        }
        boolean interrupted = false;
        while (true) {
            try {
                DBRecord dBRecord = (DBRecord)record.get();
                return dBRecord;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof FatalIOException) {
                    throw (FatalIOException)e.getCause();
                }
                if (e.getCause() instanceof ReferenceException) {
                    throw (ReferenceException)e.getCause();
                }
                Throwable t = e.getCause() == null ? e : e.getCause();
                throw new FatalIOException("Exception retrieving result", t);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void drainCache(boolean immediate) {
        boolean didDrain = false;
        try {
            this.cacheLock.lock();
            Collection<DBRecordFuture> records = this.recordCache.values();
            didDrain = !records.isEmpty();
            for (RunnableFuture runnableFuture : records) {
                try {
                    this.writeBack.addFuture(runnableFuture);
                }
                catch (RuntimeException e) {
                    Logger.logException(Messages.bTreeMsg_errordrainingcache, e);
                }
            }
            this.recordCache.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
        if (didDrain && immediate) {
            this.writeBack.executeNow(false);
        }
    }

    public void joinPendingWrites() {
        this.writeBack.executeNow(true);
    }

    public void clearWriteBack() {
        this.writeBack.clear();
        this.writeBack.cancel();
        this.writeBack.clear();
    }

    public void clearCache() {
        try {
            this.cacheLock.lock();
            this.recordCache.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void touch(DBRecord node) {
        try {
            this.cacheLock.lock();
            this.recordCache.get(node.getId());
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public Lock getReadLock() {
        return this.read;
    }

    public Lock getWriteLock() {
        return this.write;
    }

    public ReentrantReadWriteLock getRWLock() {
        return this.lock;
    }

    public void printCacheStats(PrintStream out) {
        out.println("Hit ratio: " + this.recordCache.getHitRatio());
    }

    public void resetStats() {
        this.recordCache.resetStats();
    }

    static /* synthetic */ ReentrantReadWriteLock.WriteLock access$3(ExtentManager extentManager) {
        return extentManager.write;
    }

    static /* synthetic */ ReentrantLock access$4(ExtentManager extentManager) {
        return extentManager.cacheLock;
    }

    static /* synthetic */ HashMap access$5(ExtentManager extentManager) {
        return extentManager.activeObjects;
    }

    static /* synthetic */ Cache access$6(ExtentManager extentManager) {
        return extentManager.recordCache;
    }

    private static interface DBRecordFuture
    extends RunnableFuture<DBRecord> {
        public boolean isFullRead();

        public DBRecord getRecord();
    }

    private static class DBRecordHolder
    implements DBRecordFuture {
        private final DBRecord rec;

        public DBRecordHolder(DBRecord rec) {
            this.rec = rec;
        }

        @Override
        public boolean isFullRead() {
            return this.rec.isFullyLoaded();
        }

        @Override
        public DBRecord getRecord() {
            return this.rec;
        }

        @Override
        public void run() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public DBRecord get() throws InterruptedException, ExecutionException {
            return this.rec;
        }

        @Override
        public DBRecord get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.rec;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    private static class DBRecordRetriever
    implements Callable<DBRecord> {
        private final int id;
        private final boolean fullRead;
        private final ExtentManager manager;

        public DBRecordRetriever(ExtentManager manager, int id, boolean fullRead) {
            this.id = id;
            this.fullRead = fullRead;
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DBRecord call() throws Exception {
            DBRecord rec = this.manager.realReadRecord(this.id, this.fullRead);
            if (rec != null) {
                DBRecord dBRecord = rec;
                synchronized (dBRecord) {
                    if (!rec.isDeleted() && rec.isCommited()) {
                        Assert.isTrue((boolean)false, (String)(String.valueOf(Messages.bTreeMsg_readacommitedrecord) + rec));
                    }
                }
            }
            return rec;
        }

        public boolean isFullRead() {
            return this.fullRead;
        }
    }

    private static class LoadDBRecordTask
    extends FutureTask<DBRecord>
    implements DBRecordFuture {
        private final DBRecordRetriever dBRecordRetriever;

        LoadDBRecordTask(DBRecordRetriever dBRecordRetriever) {
            super(dBRecordRetriever);
            this.dBRecordRetriever = dBRecordRetriever;
        }

        public LoadDBRecordTask(ExtentManager manager, int id, boolean fullRead) {
            this(new DBRecordRetriever(manager, id, fullRead));
        }

        @Override
        public DBRecord getRecord() {
            return this.dBRecordRetriever.manager.getResult(this);
        }

        @Override
        public boolean isFullRead() {
            return this.dBRecordRetriever.isFullRead();
        }
    }

    private class RecordCache<K, V>
    extends ARCCache<K, V> {
        public RecordCache() {
            super(ExtentManager.this.cacheSize);
        }

        @Override
        public V put(K key, V value) {
            V old = super.put(key, value);
            if (old != null && old != value) {
                ExtentManager.this.writeBack.addFuture((RunnableFuture)old);
            }
            return old;
        }

        @Override
        protected void removeFromCache(K key, V value) {
            ExtentManager.this.writeBack.addFuture((RunnableFuture)value);
        }
    }

    static class RecordComparator
    implements Comparator<DBRecord> {
        RecordComparator() {
        }

        @Override
        public int compare(DBRecord o1, DBRecord o2) {
            if (o1.getId() < o2.getId()) {
                return -1;
            }
            if (o1.getId() == o2.getId()) {
                int id2;
                if (o1 == o2) {
                    return 0;
                }
                int id1 = System.identityHashCode(o1);
                if (id1 == (id2 = System.identityHashCode(o1))) {
                    Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.USER, "Hashcode for unequal obejcts is the same");
                }
                return id1 < id2 ? -1 : (id1 == id2 ? 1 : 1);
            }
            return 1;
        }
    }

    private static class RecordWeakRefernece<T>
    extends WeakReference<T> {
        private final int recordId;

        public RecordWeakRefernece(int recordId, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.recordId = recordId;
        }

        public int getRecordId() {
            return this.recordId;
        }
    }

    private class WriteBack
    implements Runnable {
        private List<DBRecord> queue;
        private List<RunnableFuture<DBRecord>> futureQueue;
        private final Comparator<DBRecord> comparator;
        private final InternalReferencesJob lastExecution = new InternalReferencesJob(this);
        private final AtomicBoolean runNow = new AtomicBoolean();
        private final AtomicBoolean canRun = new AtomicBoolean();

        public WriteBack() {
            this.comparator = new RecordComparator();
            this.init();
        }

        public String toString() {
            File f = ExtentManager.this.getFile();
            if (f != null) {
                return "WriteBack thread for " + ExtentManager.this.getFile().getName();
            }
            return "WriteBack thread <init>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initQueue() {
            Comparator<DBRecord> comparator = this.comparator;
            synchronized (comparator) {
                this.queue = new ArrayList<DBRecord>();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initFutureQueue() {
            Comparator<DBRecord> comparator = this.comparator;
            synchronized (comparator) {
                this.futureQueue = new ArrayList<RunnableFuture<DBRecord>>();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Comparator<DBRecord> comparator = this.comparator;
            synchronized (comparator) {
                this.initQueue();
                this.initFutureQueue();
            }
        }

        public void clear() {
            this.init();
        }

        public void schedule(long delay) {
            this.lastExecution.schedule(delay, TimeUnit.MILLISECONDS);
        }

        public void executeNow(boolean wait) {
            this.canRun.set(false);
            try {
                this.lastExecution.cancelJoin();
                if (!wait) {
                    this.schedule(0L);
                    return;
                }
                this.runNow.compareAndSet(false, true);
                try {
                    this.run(null);
                }
                finally {
                    this.runNow.compareAndSet(true, false);
                }
            }
            finally {
                this.canRun.set(true);
            }
        }

        public void waitUntilDone() {
            this.lastExecution.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFuture(RunnableFuture<DBRecord> future) {
            Comparator<DBRecord> comparator = this.comparator;
            synchronized (comparator) {
                this.futureQueue.add(future);
            }
            this.schedule(2000L);
        }

        public void addRecord(DBRecord record) {
            this.addRecord(record, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRecord(DBRecord record, boolean shouldSchedule) {
            boolean schedule = false;
            Comparator<DBRecord> comparator = this.comparator;
            synchronized (comparator) {
                int insertionPoint = Collections.binarySearch(this.queue, record, this.comparator);
                if (insertionPoint < 0) {
                    int idx = -insertionPoint - 1;
                    this.queue.add(idx, record);
                }
                schedule = true;
            }
            if (shouldSchedule && schedule) {
                this.schedule(2000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RunnableFuture<DBRecord> getNext() {
            Comparator<DBRecord> comparator = this.comparator;
            synchronized (comparator) {
                if (!this.queue.isEmpty()) {
                    if (this.futureQueue.isEmpty()) {
                        this.initFutureQueue();
                    }
                    DBRecord record = this.queue.remove(0);
                    return ExtentManager.this.createRecordHolderTask(record);
                }
                if (!this.futureQueue.isEmpty()) {
                    if (this.queue.isEmpty()) {
                        this.initQueue();
                    }
                    RunnableFuture<DBRecord> record = this.futureQueue.remove(0);
                    return record;
                }
                this.init();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getSize() {
            Comparator<DBRecord> comparator = this.comparator;
            synchronized (comparator) {
                return this.queue.size() + this.futureQueue.size();
            }
        }

        @Override
        public void run() {
            if (this.canRun.get()) {
                this.run(null);
            }
        }

        private boolean shouldBreakOnInterrupt() {
            return this.getSize() <= 1000;
        }

        /*
         * Exception decompiling
         */
        private IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void cancel() {
            this.lastExecution.cancelJoin();
        }
    }
}

