/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.bplustree.db;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.ExtentManager;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.FileHeader;
import com.ibm.etools.references.internal.bplustree.db.IO;
import com.ibm.etools.references.internal.bplustree.db.IntArray;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.db.SplitRecord;
import com.ibm.etools.references.internal.bplustree.db.UnsignedShortFileHeader;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.nls.Messages;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class Extent {
    public static final int NULL = 65535;
    private static final int MAX_CAPACITY = 65534;
    private int lastUsedId = 0;
    private int firstDeletedId = 0;
    private int lastDeletedId = 0;
    private final List<FileHeader> allHeaders = new ArrayList<FileHeader>();
    private IO realIO;
    private int recordSizeWithHeader = 0;
    private final ExtentManager manager;
    private final int extentId;
    private int usedSlots;
    private int availableSlots;
    private final File extentFile;
    private final boolean originalCreate;
    private final int originalAvailableSlots;
    private final Extent previous;

    public Extent(ExtentManager manager, int extentId, int availableSlots, List<FileHeader> headers, boolean create, Extent previous) throws FatalIOException {
        Assert.isLegal((availableSlots <= 65534 ? 1 : 0) != 0, (String)("Tried to create an extent with more slots than it can hold. Wanted: " + availableSlots + ", Total: " + 65534));
        this.previous = previous;
        this.manager = manager;
        this.extentId = extentId;
        String fileName = String.valueOf(manager.getFile().getName()) + ".e" + Integer.toString(extentId);
        this.extentFile = new File(manager.getFile().getParentFile(), fileName);
        this.allHeaders.addAll(this.createHeaders(availableSlots));
        this.allHeaders.addAll(headers);
        this.recordSizeWithHeader = manager.getSlotSize() + 1;
        this.originalCreate = create;
        this.originalAvailableSlots = availableSlots;
    }

    IO getIO() {
        if (this.realIO == null) {
            int totalBytes = this.headerSize() + this.recordSizeWithHeader * this.originalAvailableSlots;
            if (this.previous != null) {
                IO prevIO = this.previous.getIO();
                this.realIO = prevIO.expand(totalBytes);
            } else {
                this.realIO = InternalAPI.Tweaks.SHOULD_USE_MAPPED_BUFFER ? new IO.BufferIO(this.extentFile) : new IO.FileChannelIO(this.extentFile);
            }
            boolean foundExisting = this.realIO.init(this.originalCreate, totalBytes);
            if (foundExisting) {
                this.loadHeaders();
                this.readHeaders();
                if (this.availableSlots != this.originalAvailableSlots) {
                    this.realIO.close();
                    int realSize = this.headerSize() + this.recordSizeWithHeader * this.availableSlots;
                    this.realIO.init(this.originalCreate, realSize);
                }
            } else {
                this.readHeaders();
            }
        }
        return this.realIO;
    }

    public int getId() {
        return this.extentId;
    }

    private int headerSize() {
        int hSize = 0;
        for (FileHeader header : this.allHeaders) {
            hSize += header.getSize();
        }
        return hSize;
    }

    private List<FileHeader> createHeaders(int recordsPerExtent) {
        ArrayList<FileHeader> fh = new ArrayList<FileHeader>();
        fh.add(new UnsignedShortFileHeader("Size of extent", 0));
        fh.add(new UnsignedShortFileHeader("Last used id", 65535));
        fh.add(new UnsignedShortFileHeader("First deleted id", 65535));
        fh.add(new UnsignedShortFileHeader("Last deleted id", 65535));
        fh.add(new UnsignedShortFileHeader("Records per extent", recordsPerExtent));
        return fh;
    }

    private void readHeaders() {
        this.usedSlots = ((UnsignedShortFileHeader)this.allHeaders.get(0)).getHeaderValue();
        this.lastUsedId = ((UnsignedShortFileHeader)this.allHeaders.get(1)).getHeaderValue();
        this.firstDeletedId = ((UnsignedShortFileHeader)this.allHeaders.get(2)).getHeaderValue();
        this.lastDeletedId = ((UnsignedShortFileHeader)this.allHeaders.get(3)).getHeaderValue();
        this.availableSlots = ((UnsignedShortFileHeader)this.allHeaders.get(4)).getHeaderValue();
    }

    private void writeHeaders() throws FatalIOException {
        ((UnsignedShortFileHeader)this.allHeaders.get(0)).setHeaderValue(this.usedSlots);
        ((UnsignedShortFileHeader)this.allHeaders.get(1)).setHeaderValue(this.lastUsedId);
        ((UnsignedShortFileHeader)this.allHeaders.get(2)).setHeaderValue(this.firstDeletedId);
        ((UnsignedShortFileHeader)this.allHeaders.get(3)).setHeaderValue(this.lastDeletedId);
        ((UnsignedShortFileHeader)this.allHeaders.get(4)).setHeaderValue(this.availableSlots);
        this.getIO().position(0);
        for (FileHeader header : this.allHeaders) {
            ByteBuffer buf = header.writeRecord().buffer;
            buf.rewind();
            this.getIO().write(buf);
        }
    }

    private void loadHeaders() throws FatalIOException {
        this.getIO().position(0);
        for (FileHeader header : this.allHeaders) {
            short size = header.getSize();
            PooledByteBuffer buf = this.getIO().read(size);
            header.readRecord(buf);
        }
    }

    public int assignSlotId() throws FatalIOException {
        this.getIO();
        if (this.lastUsedId == this.availableSlots - 1) {
            if (this.firstDeletedId != 65535) {
                int offset = this.headerSize() + this.recordSizeWithHeader * this.firstDeletedId;
                this.getIO().position(offset);
                PooledByteBuffer header = this.getIO().read(3);
                header.buffer.rewind();
                byte dataType = header.buffer.get();
                Assert.isTrue((dataType == -1 ? 1 : 0) != 0, (String)NLS.bind((String)Messages.bTreeMsg_coundnotassignid_deleted, (Object)this.extentFile.getAbsolutePath()));
                int nextDeletedId = ByteUtils.bytesToUnsignedShort(header.buffer);
                int id = this.firstDeletedId;
                this.firstDeletedId = nextDeletedId;
                if (this.firstDeletedId == 65535) {
                    this.lastDeletedId = 65535;
                }
                ++this.usedSlots;
                header.returnBuffer();
                return id;
            }
            throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_couldnotassignid_full, (Object)this.extentFile.getAbsolutePath()), null);
        }
        return this.assignFreeId();
    }

    private int assignFreeId() {
        this.lastUsedId = this.lastUsedId == 65535 ? 0 : ++this.lastUsedId;
        ++this.usedSlots;
        if (this.lastUsedId > 65534) {
            Assert.isTrue((boolean)false, (String)Messages.bTreeMsg_recordIdOverflow);
        }
        return this.lastUsedId;
    }

    public SplitRecord readSplitRecord(int recId) throws FatalIOException {
        block4: {
            byte recType;
            IO io;
            block5: {
                try {
                    io = this.getIO().duplicate();
                    if (recId < 0 || recId > this.availableSlots - 1) break block4;
                    int offset = this.headerSize() + this.recordSizeWithHeader * recId;
                    io.position(offset);
                    PooledByteBuffer recHeader = io.read(1);
                    recType = recHeader.buffer.get();
                    recHeader.returnBuffer();
                    if (recType != -1) break block5;
                    return null;
                }
                catch (RuntimeException e) {
                    FatalIOException io2 = new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_read_slot_x_eid_y, (Object)recId, (Object)this.getId()), e);
                    throw io2;
                }
            }
            if (recType == -2 || recType == -4 || recType == -3 || recType == -5) {
                PooledByteBuffer data = io.read(this.manager.getSlotSize());
                SplitRecord split = new SplitRecord(recType);
                split.readRecord(data);
                split.setFullyloaded(true);
                split.setId(ByteUtils.doubleUnsignedShortToInt(this.getId(), recId));
                return split;
            }
            throw new RuntimeException("Could not find expected split record: (recType: " + recType + ")");
        }
        return null;
    }

    public int getRecordType(int id) {
        try {
            IO io = this.getIO().duplicate();
            if (id >= 0 && id <= this.availableSlots - 1) {
                int offset = this.headerSize() + this.recordSizeWithHeader * id;
                io.position(offset);
                PooledByteBuffer recHeader = io.read(1);
                byte recType = recHeader.buffer.get();
                recHeader.returnBuffer();
                return recType;
            }
            return -1;
        }
        catch (RuntimeException e) {
            throw new FatalIOException(String.valueOf(Messages.bTreeMsg_problemDuringRead) + id, e);
        }
    }

    int[] readSplitIds(int id) throws FatalIOException {
        try {
            IO io = this.getIO().duplicate();
            if (id >= 0 && id <= this.availableSlots - 1) {
                int offset = this.headerSize() + this.recordSizeWithHeader * id;
                io.position(offset);
                PooledByteBuffer recHeader = io.read(1);
                byte recType = recHeader.buffer.get();
                recHeader.returnBuffer();
                if (recType == -1) {
                    return new int[0];
                }
                if (recType == -2) {
                    int nextRecId = 65535;
                    IntArray ids = new IntArray();
                    ids.add(ByteUtils.doubleUnsignedShortToInt(this.getId(), id));
                    PooledByteBuffer data = io.read(3);
                    SplitRecord split = new SplitRecord(recType);
                    split.readNextRecordField(data);
                    nextRecId = split.nextRecord;
                    while (nextRecId != 65535) {
                        int o = this.headerSize() + this.recordSizeWithHeader * nextRecId;
                        io.position(o);
                        PooledByteBuffer header = io.read(1);
                        byte type = header.buffer.get();
                        header.returnBuffer();
                        SplitRecord s = new SplitRecord(type);
                        PooledByteBuffer d = io.read(3);
                        s.readNextRecordField(d);
                        ids.add(ByteUtils.doubleUnsignedShortToInt(this.getId(), nextRecId));
                        nextRecId = s.nextRecord;
                    }
                    return ids.toArray();
                }
                if (recType == -3 || recType == -4) {
                    throw new RuntimeException("Not implemented");
                }
                if (recType == -5) {
                    PooledByteBuffer data = io.read(this.manager.getSlotSize());
                    int eId = ByteUtils.bytesToUnsignedShort(data.buffer);
                    int rId = ByteUtils.bytesToUnsignedShort(data.buffer);
                    data.buffer.rewind();
                    return this.manager.getExtent(eId).readSplitIds(rId);
                }
                return new int[0];
            }
            return new int[0];
        }
        catch (RuntimeException e) {
            FatalIOException io = new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_read_slot_x_eid_y, (Object)id, (Object)this.getId()), e);
            throw io;
        }
    }

    public DBRecord read(int id, DBRecord template, boolean fullRead) throws FatalIOException {
        block15: {
            boolean proxy;
            DBRecord record;
            byte recType;
            IO io;
            block17: {
                block16: {
                    io = this.getIO().duplicate();
                    if (id < 0 || id > this.availableSlots - 1) break block15;
                    int offset = this.headerSize() + this.recordSizeWithHeader * id;
                    io.position(offset);
                    PooledByteBuffer recHeader = io.read(1);
                    recType = recHeader.buffer.get();
                    recHeader.returnBuffer();
                    if (recType != -1) break block16;
                    return null;
                }
                try {
                    if (recType == -2) {
                        boolean proxy2;
                        int originalDataType = 65535;
                        int nextRecId = 65535;
                        ArrayList<SplitRecord> records = new ArrayList<SplitRecord>();
                        PooledByteBuffer data = io.read(this.manager.getSlotSize());
                        SplitRecord split = new SplitRecord(recType);
                        split.readRecord(data);
                        split.setFullyloaded(true);
                        split.setId(ByteUtils.doubleUnsignedShortToInt(this.getId(), id));
                        originalDataType = split.originalDataType;
                        nextRecId = split.nextRecord;
                        DBRecord recombined = null;
                        recombined = template != null ? template : this.manager.getFactory().createRecord(originalDataType, this.manager);
                        boolean bl = proxy2 = !fullRead && this.manager.getFactory().shouldProxyLoad(originalDataType);
                        if (!proxy2) {
                            records.add(split);
                            int size = split.getOriginalBufferSize();
                            while (nextRecId != 65535) {
                                SplitRecord sr = (SplitRecord)this.read(nextRecId, null, true);
                                if (sr != null) {
                                    records.add(sr);
                                    size += sr.getOriginalBufferSize();
                                    nextRecId = sr.nextRecord;
                                    continue;
                                }
                                nextRecId = 65535;
                            }
                            PooledByteBuffer combined = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
                            int count = 0;
                            for (DBRecord dBRecord : records) {
                                PooledByteBuffer b = ((SplitRecord)dBRecord).getOriginalBuffer();
                                combined.buffer.put(b.buffer);
                                b.returnBuffer();
                                ++count;
                            }
                            combined.buffer.rewind();
                            recombined.readRecord(combined);
                            recombined.setFullyloaded(true);
                        } else {
                            recombined.setFullyloaded(false);
                        }
                        recombined.setId(ByteUtils.doubleUnsignedShortToInt(this.extentId, id));
                        return recombined;
                    }
                    if (recType == -3 || recType == -4) {
                        SplitRecord split = new SplitRecord(recType);
                        PooledByteBuffer data = io.read(this.manager.getSlotSize());
                        split.readRecord(data);
                        split.setId(ByteUtils.doubleUnsignedShortToInt(this.getId(), id));
                        split.setFullyloaded(true);
                        return split;
                    }
                    if (recType == -5) {
                        PooledByteBuffer data = io.read(this.manager.getSlotSize());
                        int eId = ByteUtils.bytesToUnsignedShort(data.buffer);
                        int rId = ByteUtils.bytesToUnsignedShort(data.buffer);
                        data.buffer.rewind();
                        DBRecord rec = this.manager.getExtent(eId).read(rId, template, fullRead);
                        if (rec == null) {
                            data.returnBuffer();
                            throw new FatalIOException(NLS.bind((String)Messages.bTreeMsg_split_record_inconsistent, (Object)eId, (Object)rId), null);
                        }
                        rec.pointerToActual = ByteUtils.doubleUnsignedShortToInt(eId, rId);
                        rec.setId(ByteUtils.doubleUnsignedShortToInt(this.getId(), id));
                        SplitRecord pointer = new SplitRecord(recType);
                        pointer.readRecord(data);
                        pointer.setId(ByteUtils.doubleUnsignedShortToInt(eId, rId));
                        pointer.setFullyloaded(true);
                        return rec;
                    }
                    record = null;
                    record = template != null ? template : this.manager.getFactory().createRecord(recType, this.manager);
                    if (record != null) break block17;
                    return null;
                }
                catch (RuntimeException e) {
                    FatalIOException io2 = new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_read_slot_x_eid_y, (Object)id, (Object)this.getId()), e);
                    throw io2;
                }
            }
            boolean bl = proxy = !fullRead && this.manager.getFactory().shouldProxyLoad(recType);
            if (!proxy) {
                PooledByteBuffer data = io.read(this.manager.getSlotSize());
                record.readRecord(data);
                record.setFullyloaded(true);
            } else {
                record.setFullyloaded(false);
            }
            record.setId(ByteUtils.doubleUnsignedShortToInt(this.extentId, id));
            record.clean();
            return record;
        }
        return null;
    }

    void writeRecords(List<DBRecord> records, PooledByteBuffer recordPayload) throws FatalIOException {
        int i = 0;
        while (i < records.size()) {
            PooledByteBuffer payload;
            int recId;
            DBRecord currentRec = records.get(i);
            DBRecord nextRec = i < records.size() - 1 ? records.get(i + 1) : null;
            SplitRecord cSplit = null;
            if (currentRec.isSplit()) {
                cSplit = (SplitRecord)currentRec;
            }
            if (currentRec.getId() == -1) {
                recId = this.assignSlotId();
                currentRec.setId(ByteUtils.doubleUnsignedShortToInt(this.getId(), recId));
            } else {
                recId = ByteUtils.intToSecondUnsignedShort(currentRec.getId());
            }
            int offset = this.headerSize() + this.recordSizeWithHeader * recId;
            if (nextRec != null) {
                if (cSplit != null) {
                    if (cSplit.nextRecord == 65535) {
                        cSplit.nextRecord = this.assignSlotId();
                    }
                    nextRec.setRecordId(cSplit.nextRecord);
                }
            } else if (cSplit != null) {
                cSplit.nextRecord = 65535;
            }
            if (records.size() == 1) {
                payload = recordPayload;
            } else {
                payload = currentRec.writeRecord();
                payload.buffer.rewind();
            }
            PooledByteBuffer recHeader = PooledByteBuffer.INSTANCE.leaseByteBuffer(1);
            recHeader.buffer.put((byte)currentRec.getDataType());
            recHeader.buffer.rewind();
            Assert.isTrue((recHeader.buffer.limit() + payload.buffer.limit() <= this.recordSizeWithHeader ? 1 : 0) != 0);
            this.getIO().position(offset);
            this.getIO().write(recHeader.buffer);
            recHeader.returnBuffer();
            this.getIO().write(payload.buffer);
            if (records.size() > 1) {
                payload.returnBuffer();
            }
            currentRec.setAssignedNew(false);
            ++i;
        }
        if (records.size() > 1) {
            recordPayload.returnBuffer();
        }
    }

    public void deleteSingle(int id) throws FatalIOException {
        this.getIO();
        int offset = this.headerSize() + this.recordSizeWithHeader * id;
        PooledByteBuffer recHeader = PooledByteBuffer.INSTANCE.leaseByteBuffer(3);
        recHeader.buffer.put((byte)-1);
        recHeader.buffer.put(ByteUtils.unsignedShortToBytes(65535));
        recHeader.buffer.rewind();
        this.getIO().position(offset);
        this.getIO().write(recHeader.buffer);
        if (this.firstDeletedId == 65535) {
            this.firstDeletedId = id;
            this.lastDeletedId = id;
        } else {
            int previousDeletedOffset = this.headerSize() + this.recordSizeWithHeader * this.lastDeletedId;
            recHeader.buffer.rewind();
            recHeader.buffer.put((byte)-1);
            recHeader.buffer.put(ByteUtils.unsignedShortToBytes(id));
            recHeader.buffer.rewind();
            this.getIO().position(previousDeletedOffset);
            this.getIO().write(recHeader.buffer);
            this.lastDeletedId = id;
        }
        recHeader.returnBuffer();
        --this.usedSlots;
    }

    public boolean delete(int id) throws FatalIOException {
        byte recType;
        block14: {
            PooledByteBuffer recHeader;
            int offset;
            block13: {
                offset = this.headerSize() + this.recordSizeWithHeader * id;
                this.getIO().position(offset);
                recHeader = this.getIO().read(1);
                recType = recHeader.buffer.get();
                recHeader.returnBuffer();
                if (recType < 0) break block13;
                this.deleteSingle(id);
                return true;
            }
            try {
                if (recType != -2) break block14;
                this.getIO().position(offset + 2);
                recHeader = this.getIO().read(2);
                HashSet<Integer> idstodelete = new HashSet<Integer>(8);
                idstodelete.add(id);
                int nextRecId = ByteUtils.bytesToUnsignedShort(recHeader.buffer);
                recHeader.returnBuffer();
                while (nextRecId != 65535) {
                    boolean added = idstodelete.add(nextRecId);
                    if (!added) {
                        String idsToDelete = "";
                        for (Integer integer : idstodelete) {
                            idsToDelete = String.valueOf(idsToDelete) + integer.toString() + ", ";
                        }
                        Assert.isTrue((boolean)false, (String)NLS.bind((String)Messages.bTreeMsg_detected_loop, (Object)idsToDelete, (Object)nextRecId));
                    }
                    int nOffset = this.headerSize() + this.recordSizeWithHeader * nextRecId;
                    this.getIO().position(nOffset);
                    PooledByteBuffer nHeader = this.getIO().read(1);
                    byte nType = nHeader.buffer.get();
                    nHeader.returnBuffer();
                    if (nType == -3) {
                        PooledByteBuffer buf = this.getIO().read(2);
                        nextRecId = ByteUtils.bytesToUnsignedShort(buf.buffer);
                        nHeader.returnBuffer();
                        continue;
                    }
                    if (nType == -4) {
                        nextRecId = 65535;
                        continue;
                    }
                    Assert.isTrue((boolean)false, (String)NLS.bind((String)Messages.bTreeMsg_inconsitent_split, (Object)nType));
                }
                ArrayList inorder = new ArrayList(idstodelete);
                Collections.sort(inorder);
                for (Integer recId : inorder) {
                    this.deleteSingle(recId);
                }
                return true;
            }
            catch (RuntimeException e) {
                FatalIOException io = new FatalIOException(NLS.bind((String)Messages.bTreeMsg_exception_during_read_slot_x_eid_y, (Object)id, (Object)this.getId()), e);
                throw io;
            }
        }
        if (recType == -5) {
            PooledByteBuffer pointer = this.getIO().read(4);
            int extent = ByteUtils.bytesToUnsignedShort(pointer.buffer);
            int record = ByteUtils.bytesToUnsignedShort(pointer.buffer);
            pointer.returnBuffer();
            boolean deleted = this.manager.getExtent(extent).delete(record);
            if (deleted) {
                this.deleteSingle(id);
            } else {
                System.out.println(Messages.bTreeMsg_recorddeleted);
            }
            return deleted;
        }
        return false;
    }

    public int getSlotUsage() {
        this.getIO();
        return this.usedSlots;
    }

    public int getSlotsCapacity() {
        this.getIO();
        return this.availableSlots;
    }

    public SplitRecord convertToExtentPointer(DBRecord record, int nextExtent, int recordId) throws FatalIOException {
        Assert.isTrue((record.getId() != -1 ? 1 : 0) != 0, (String)"Source record id is -1");
        SplitRecord pointer = new SplitRecord(-5);
        pointer.setId(record.getId());
        pointer.setEntryPointerData(nextExtent, recordId);
        this.writeRecords(Collections.singletonList(pointer), pointer.writeRecord());
        record.pointerToActual = pointer.getEntryPointerData();
        return pointer;
    }

    public void close() throws FatalIOException {
        try {
            this.writeHeaders();
        }
        finally {
            this.getIO().close();
        }
    }

    public void printStats() {
        this.getIO();
        System.out.println("Extent id: " + this.getId());
        System.out.println("Size: " + this.usedSlots);
        System.out.println("Capacity: " + this.availableSlots);
        System.out.println("% full: " + (float)this.usedSlots / (float)this.availableSlots);
    }

    public void delete() throws FatalIOException {
        this.getIO().delete();
    }

    public void debugPrintRecords() {
        this.debugPrintRecords(System.out);
    }

    public List<Integer> getIds() {
        this.getIO();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int i = 0;
        while (i < this.lastUsedId + 1) {
            block4: {
                int type;
                DBRecord record = null;
                try {
                    record = this.read(i, null, true);
                }
                catch (FatalIOException fatalIOException) {
                    break block4;
                }
                if (record != null && (type = record.getDataType()) >= 0) {
                    ids.add(record.getId());
                }
            }
            ++i;
        }
        return ids;
    }

    public int getAvgRecordSize() {
        this.getIO();
        int totalSize = 0;
        int count = 0;
        int i = 0;
        while (i < this.lastUsedId + 1) {
            DBRecord record = null;
            try {
                record = this.read(i, null, true);
            }
            catch (FatalIOException fatalIOException) {}
            if (record != null) {
                totalSize += record.getSize();
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            count = 1;
        }
        int avg = totalSize / count;
        return avg;
    }

    public long getRecordsSize() {
        this.getIO();
        long totalSize = 0L;
        int i = 0;
        while (i < this.lastUsedId + 1) {
            DBRecord record = null;
            try {
                record = this.read(i, null, true);
            }
            catch (FatalIOException fatalIOException) {}
            if (record != null) {
                totalSize += (long)record.getSize();
            }
            ++i;
        }
        return totalSize;
    }

    public long getAllocatedSize() {
        return this.getIO().size();
    }

    public void debugDumpRecords(PrintStream stream) {
        this.getIO();
        int i = 0;
        while (i < this.lastUsedId + 1) {
            DBRecord record = null;
            try {
                record = this.read(i, null, true);
            }
            catch (FatalIOException e) {
                e.printStackTrace(stream);
            }
            if (record != null) {
                stream.println("Slot: " + i + " Record Datatype: " + record.getDataType());
                stream.print("Data: ");
                stream.println(record.toString());
            }
            ++i;
        }
    }

    public void debugPrintRecords(PrintStream stream) {
        stream.println("Deleted ids: (sorted, not in order of appearance)");
        try {
            List<Integer> deletedIds = this.getDeletedIds();
            Collections.sort(deletedIds);
            for (Integer ids : deletedIds) {
                stream.println(ids);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace(stream);
        }
    }

    public void debugRaw() {
        this.debugRaw(System.out);
    }

    public void debugRaw(PrintStream stream) {
        this.getIO().position(0);
        int totalBytes = this.headerSize() + this.recordSizeWithHeader * this.availableSlots;
        PooledByteBuffer buffer = this.getIO().read(totalBytes);
        int i = 0;
        while (i < buffer.buffer.limit()) {
            System.out.print(String.valueOf(buffer.buffer.get()) + ", ");
            ++i;
        }
        buffer.returnBuffer();
    }

    public List<Integer> getDeletedIds() {
        this.getIO();
        ArrayList<Integer> ints = new ArrayList<Integer>();
        int id = this.firstDeletedId;
        IO io = null;
        io = this.getIO().duplicate();
        while (id != 65535) {
            ints.add(id);
            int offset = this.headerSize() + this.recordSizeWithHeader * id;
            try {
                io.position(offset);
                PooledByteBuffer recHeader = io.read(3);
                try {
                    recHeader.buffer.rewind();
                    byte deletedType = recHeader.buffer.get();
                    if (deletedType != -1) {
                        throw new RuntimeException(NLS.bind((String)"id: {0} was not a deleted record", (Object)id));
                    }
                    id = ByteUtils.bytesToUnsignedShort(recHeader.buffer);
                }
                finally {
                    recHeader.returnBuffer();
                }
            }
            catch (FatalIOException e) {
                throw new RuntimeException(NLS.bind((String)"While looking at: {0}", (Object)id), e);
            }
        }
        return ints;
    }

    public PooledByteBuffer allocate(int recId, byte dataType) throws FatalIOException {
        int offset = this.headerSize() + this.recordSizeWithHeader * recId;
        this.getIO().position(offset);
        PooledByteBuffer header = PooledByteBuffer.INSTANCE.leaseByteBuffer(1);
        header.buffer.put(dataType);
        header.buffer.rewind();
        this.getIO().write(header.buffer);
        header.returnBuffer();
        return this.getIO().allocate(this.recordSizeWithHeader - 1);
    }

    public boolean flush() {
        return true;
    }

    public void ensureOpen() {
        this.getIO();
    }
}

