/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;

public class ThreadPriorityPolicy {
    private static final boolean ENABLE_THREAD_PRIORITIES;
    private static final UncaughtExceptions uncaught;

    static {
        uncaught = new UncaughtExceptions();
        ENABLE_THREAD_PRIORITIES = InternalAPI.Tweaks.ENABLE_THREAD_PRIORITIES;
    }

    public static void setMinimumPriority(Thread thread) {
        if (thread == null || !ENABLE_THREAD_PRIORITIES) {
            return;
        }
        thread.setPriority(1);
    }

    public static void setBackgroundProcessingPriority(Thread thread) {
        if (thread == null || !ENABLE_THREAD_PRIORITIES) {
            return;
        }
        Thread.currentThread().setPriority(2);
    }

    public static void initNewThread(Thread thread) {
        if (thread == null || !ENABLE_THREAD_PRIORITIES) {
            return;
        }
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        thread.setUncaughtExceptionHandler(uncaught);
    }

    public static void boostPriority(Thread backgroundThread, Thread callingThread) {
        int newPriority;
        if (backgroundThread == null || callingThread == null || !ENABLE_THREAD_PRIORITIES) {
            return;
        }
        int currentPriority = backgroundThread.getPriority();
        if (currentPriority < (newPriority = Math.max(5, callingThread.getPriority()))) {
            backgroundThread.setPriority(newPriority);
        }
    }

    private static class UncaughtExceptions
    implements Thread.UncaughtExceptionHandler {
        private UncaughtExceptions() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            Logger.logException(thread, "Uncaught exception", throwable);
        }
    }
}

