/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.management.ReferenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ReferencesPreferencesAccess {
    public static final ReferencesPreferencesAccess INSTANCE = new ReferencesPreferencesAccess();
    private final ConcurrentHashMap<String, FutureTask<List<StringMatcher>>> cachedMatchers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, FutureTask<Boolean>> cachedValues = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, FutureTask<List<String>>> cachedApprovers = new ConcurrentHashMap();

    private ReferencesPreferencesAccess() {
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences instancePrefs = scope.getNode("com.ibm.etools.references");
        instancePrefs.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                ReferencesPreferencesAccess.this.resetCaches();
                if ("referenceBrokenLinkSeverity".equals(event.getKey()) || "referenceMaxProblems".equals(event.getKey())) {
                    ReferenceManager.getReferenceManager().requestRebuildAllMarkers();
                } else {
                    InternalAPI.getRebuildJob().schedule();
                }
            }
        });
        DefaultScope d = new DefaultScope();
        IEclipsePreferences defaultPrefs = d.getNode("com.ibm.etools.references");
        ((IEclipsePreferences)defaultPrefs.parent()).addNodeChangeListener(new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
                if ("com.ibm.etools.references".equals(event.getChild().name())) {
                    ReferencesPreferencesAccess.this.resetCaches();
                    InternalAPI.getRebuildJob().schedule();
                }
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if ("com.ibm.etools.references".equals(event.getChild().name())) {
                    ReferencesPreferencesAccess.this.resetCaches();
                    InternalAPI.getRebuildJob().schedule();
                }
            }
        });
    }

    private void resetCaches() {
        this.cachedMatchers.clear();
        this.cachedValues.clear();
        this.cachedApprovers.clear();
    }

    public boolean isIgnoredDerived(IProject project) {
        if (project == null) {
            return false;
        }
        String cacheKey = "NO_PROJECT_SCOPE";
        FutureTask<Boolean> ignoredDerived = this.cachedValues.get(cacheKey);
        if (ignoredDerived == null) {
            ignoredDerived = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    IPreferencesService preferencesService = Platform.getPreferencesService();
                    IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope(), new ConfigurationScope(), new DefaultScope()};
                    Boolean ignoredDerived = preferencesService.getBoolean("com.ibm.etools.references", "referneceIgnoreDerived", true, lookupOrder);
                    return ignoredDerived;
                }
            });
            FutureTask<Boolean> old = this.cachedValues.putIfAbsent(cacheKey, ignoredDerived);
            if (old == null) {
                ignoredDerived.run();
            } else {
                ignoredDerived = old;
            }
        }
        boolean interrupted = false;
        while (true) {
            try {
                boolean bl = ignoredDerived.get();
                return bl;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause() == null ? e : e.getCause();
                throw new RuntimeException(t);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void addIgnoredResource(List<String> resources) {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope(), new ConfigurationScope(), new DefaultScope()};
        String encodedString = preferencesService.getString("com.ibm.etools.references", "referenceIgnoredPaths", "", lookupOrder);
        ArrayList<InternalAPI.ResourceApprovalEntry> paths = new ArrayList<InternalAPI.ResourceApprovalEntry>(Arrays.asList(InternalAPI.deserializeResourceApprovalPrefs(encodedString)));
        for (String path : resources) {
            InternalAPI.ResourceApprovalEntry entry = new InternalAPI.ResourceApprovalEntry();
            entry.stringItem = path;
            paths.add(entry);
        }
        String list = InternalAPI.serializeResourceApprovalPrefs(paths.toArray(new InternalAPI.ResourceApprovalEntry[paths.size()]));
        IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.etools.references");
        prefs.put("referenceIgnoredPaths", list);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException("Error modifying ignored resources preference", e);
        }
    }

    public List<StringMatcher> getEnabledIgnoredResources(IProject project) {
        String projectName = "NO_PROJECT_SCOPE";
        FutureTask<List<StringMatcher>> matcher = this.cachedMatchers.get(projectName);
        if (matcher == null) {
            matcher = new FutureTask<List<StringMatcher>>(new Callable<List<StringMatcher>>(){

                @Override
                public List<StringMatcher> call() throws Exception {
                    InternalAPI.ResourceApprovalEntry[] entries;
                    IPreferencesService preferencesService = Platform.getPreferencesService();
                    IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope(), new ConfigurationScope(), new DefaultScope()};
                    ArrayList<StringMatcher> matcher = new ArrayList<StringMatcher>();
                    String encodedString = preferencesService.getString("com.ibm.etools.references", "referenceIgnoredPaths", "", lookupOrder);
                    if (encodedString == null || encodedString.trim().length() == 0) {
                        return matcher;
                    }
                    InternalAPI.ResourceApprovalEntry[] resourceApprovalEntryArray = entries = InternalAPI.deserializeResourceApprovalPrefs(encodedString);
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InternalAPI.ResourceApprovalEntry entry = resourceApprovalEntryArray[n2];
                        if (entry.type != 1 && entry.enabled) {
                            StringMatcher sm = new StringMatcher(InternalAPI.getStringMatterText(entry.stringItem));
                            matcher.add(sm);
                        }
                        ++n2;
                    }
                    return matcher;
                }
            });
            FutureTask<List<StringMatcher>> old = this.cachedMatchers.putIfAbsent(projectName, matcher);
            if (old == null) {
                matcher.run();
            } else {
                matcher = old;
            }
        }
        boolean interrupted = false;
        while (true) {
            try {
                List<StringMatcher> list = matcher.get();
                return list;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause() == null ? e : e.getCause();
                throw new RuntimeException(t);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isSuspended() {
        FutureTask<Boolean> trackChanges = this.cachedValues.get("suspended");
        if (trackChanges == null) {
            trackChanges = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    IPreferencesService preferencesService = Platform.getPreferencesService();
                    IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope(), new ConfigurationScope(), new DefaultScope()};
                    return preferencesService.getBoolean("com.ibm.etools.references", "referenceSuspended", false, lookupOrder);
                }
            });
            FutureTask<Boolean> old = this.cachedValues.putIfAbsent("suspended", trackChanges);
            if (old == null) {
                trackChanges.run();
            } else {
                trackChanges = old;
            }
        }
        boolean interrupted = false;
        while (true) {
            try {
                boolean bl = trackChanges.get();
                return bl;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause() == null ? e : e.getCause();
                throw new RuntimeException(t);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public int getMaxProblems() {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope(), new ConfigurationScope(), new DefaultScope()};
        return preferencesService.getInt("com.ibm.etools.references", "referenceMaxProblems", -1, lookupOrder);
    }

    public List<String> getEnabledResourceApprovers(IProject project) {
        String projectName = "NO_PROJECT_SCOPE";
        FutureTask<List<String>> matcher = this.cachedApprovers.get(projectName);
        if (matcher == null) {
            matcher = new FutureTask<List<String>>(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    InternalAPI.ResourceApprovalEntry[] entries;
                    IScopeContext[] lookupOrder;
                    IPreferencesService preferencesService = Platform.getPreferencesService();
                    String encodedString = preferencesService.getString("com.ibm.etools.references", "referenceIgnoredPaths", "", lookupOrder = new IScopeContext[]{new InstanceScope(), new ConfigurationScope(), new DefaultScope()});
                    if (encodedString == null || encodedString.trim().length() == 0) {
                        return InternalAPI.getApproversIds();
                    }
                    ArrayList<String> enabledIds = new ArrayList<String>();
                    InternalAPI.ResourceApprovalEntry[] resourceApprovalEntryArray = entries = InternalAPI.deserializeResourceApprovalPrefs(encodedString);
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InternalAPI.ResourceApprovalEntry resourceApprovalEntry = resourceApprovalEntryArray[n2];
                        if (resourceApprovalEntry.type == 1 && resourceApprovalEntry.enabled) {
                            enabledIds.add(resourceApprovalEntry.approverId);
                        }
                        ++n2;
                    }
                    return enabledIds;
                }
            });
            FutureTask<List<String>> old = this.cachedApprovers.putIfAbsent(projectName, matcher);
            if (old == null) {
                matcher.run();
            } else {
                matcher = old;
            }
        }
        boolean interrupted = false;
        while (true) {
            try {
                List<String> list = matcher.get();
                return list;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause() == null ? e : e.getCause();
                throw new RuntimeException(t);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

