/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import com.ibm.etools.references.internal.ThreadPriorityPolicy;
import java.util.concurrent.ThreadFactory;

public final class ReferenceThreadFactrory
implements ThreadFactory {
    private ReferencesThread[] activeThreads = new ReferencesThread[0];
    private final String namePrefix;
    private final ThreadGroup group;

    public ReferenceThreadFactrory(ThreadGroup group, String namePrefix) {
        this.group = group;
        this.namePrefix = namePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable r) {
        ReferenceThreadFactrory referenceThreadFactrory = this;
        synchronized (referenceThreadFactrory) {
            int index = -1;
            int i = 0;
            while (i < this.activeThreads.length) {
                ReferencesThread thread = this.activeThreads[i];
                if (thread == null) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                index = this.activeThreads.length;
            }
            if (this.activeThreads.length < index + 1) {
                ReferencesThread[] newArray = new ReferencesThread[this.activeThreads.length + 1];
                System.arraycopy(this.activeThreads, 0, newArray, 0, this.activeThreads.length);
                this.activeThreads = newArray;
            }
            ReferencesThread t = new ReferencesThread(r, index);
            ThreadPriorityPolicy.initNewThread(t);
            this.activeThreads[index] = t;
            return t;
        }
    }

    public ThreadGroup getGroup() {
        return this.group;
    }

    private class ReferencesThread
    extends Thread {
        private final int number;

        public ReferencesThread(Runnable r, int number) {
            super(ReferenceThreadFactrory.this.group, r, String.valueOf(ReferenceThreadFactrory.this.namePrefix) + "-" + number);
            this.number = number;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                super.run();
            }
            catch (Throwable throwable) {
                ReferenceThreadFactrory referenceThreadFactrory = ReferenceThreadFactrory.this;
                synchronized (referenceThreadFactrory) {
                    ((ReferenceThreadFactrory)ReferenceThreadFactrory.this).activeThreads[this.number] = null;
                }
                throw throwable;
            }
            ReferenceThreadFactrory referenceThreadFactrory = ReferenceThreadFactrory.this;
            synchronized (referenceThreadFactrory) {
                ((ReferenceThreadFactrory)ReferenceThreadFactrory.this).activeThreads[this.number] = null;
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
        }
    }
}

