/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountUpDownLatch {
    private final Sync sync;

    public CountUpDownLatch(int count) {
        this.sync = new Sync(count);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void countDown() {
        this.sync.releaseShared(1);
    }

    public void countUp() {
        this.sync.releaseShared(-1);
    }

    public long getCount() {
        return this.sync.getCount();
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 2560988932245831418L;

        public Sync(int count) {
            this.setState(count);
        }

        public long getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int arg) {
            return this.getState() <= 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            int state;
            while (!this.compareAndSetState(state = this.getState(), state - arg)) {
            }
            return state - arg <= 0;
        }
    }
}

