/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal;

import com.ibm.cic.licensing.common.LicenseCheck;
import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.events.IReferenceLifecycleListener;
import com.ibm.etools.references.events.LifecycleEvent;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.PerfStatsListener;
import com.ibm.etools.references.internal.ThreadPriorityPolicy;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.ErrorRecovery;
import com.ibm.etools.references.internal.management.InternalReferenceManager;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.resource.FileVisitor;
import com.ibm.etools.references.internal.resource.ReferenceManagerStartupJob;
import com.ibm.etools.references.internal.resource.ResourceChangeListener;
import com.ibm.etools.references.internal.resource.Visitor;
import com.ibm.etools.references.internal.search.InternalSearchEngine;
import com.ibm.etools.references.internal.services.BrokenReferenceStrategyService;
import com.ibm.etools.references.internal.services.LinkDetectorService;
import com.ibm.etools.references.internal.services.LinkNodeModelService;
import com.ibm.etools.references.internal.services.LinkTransformerService;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.services.ReferenceResolverService;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.internal.services.SearchParticipantService;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchRequestor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.zip.Adler32;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin {
    public static final String WORKBENCH_CRASH_DETECTOR_MARKER = "workbench_crash_detector.marker";
    private static final String EXT_PT_CHEKSUM = "provider.checksum";
    private static final String EXT_PT_DBVER = "db.version";
    private static final String INDEXER_SETTINGS_FILE = "indexer.settings";
    public static final String PLUGIN_ID = "com.ibm.etools.references";
    private ReferenceManagerStartupJob startupJob = null;
    private static Activator plugin;
    private List<IReferenceLifecycleListener> lifecycleListeners;
    private static Properties settings;
    private static ServiceTracker bundleTracker;

    public static String getBundleId(Object code) {
        if (bundleTracker == null) {
            return null;
        }
        PackageAdmin packageAdmin = (PackageAdmin)bundleTracker.getService();
        if (code == null) {
            return null;
        }
        if (packageAdmin == null) {
            return null;
        }
        Bundle source = packageAdmin.getBundle(code.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    public static File getDatabaseDirectory() {
        File dbDir = null;
        IPath location = Activator.getDefault().getStateLocation();
        if (location != null) {
            dbDir = location.append("refDB").toFile();
            dbDir.mkdirs();
            return dbDir;
        }
        return null;
    }

    public static void handleCrash() {
        File[] files;
        File[] fileArray = files = Activator.getDatabaseDirectory().listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.delete()) {
                throw new RuntimeException(Messages.errorMsg_count_not_delete_files);
            }
            ++n2;
        }
    }

    public static void setSettings(FileInputStream stream) throws IOException {
        settings = new Properties();
        settings.load(stream);
    }

    public static Properties getIndexerSettings() {
        if (settings == null) {
            return new Properties();
        }
        return settings;
    }

    public void start(BundleContext context) throws Exception {
        IConfigurationElement[] elements;
        super.start(context);
        plugin = this;
        URL indexerSettingsURL = context.getBundle().getEntry(INDEXER_SETTINGS_FILE);
        InputStream settingsStream = indexerSettingsURL.toURI().toURL().openStream();
        settings = new Properties();
        settings.load(settingsStream);
        settingsStream.close();
        LicenseCheck.requestLicense((Plugin)this, (String)"com.ibm.etools.webtools.core.feature", (String)"7.0.0");
        ThreadPriorityPolicy.class.getName();
        InternalAPI.Tweaks.class.getName();
        InternalReferenceManager.class.getName();
        DefaultSearchRequestor.class.getName();
        ErrorEvent.PresentationHints.class.getName();
        ReferenceException.class.getName();
        ReferenceManager.class.getName();
        Visitor.class.getName();
        FileVisitor.class.getName();
        ILink.class.getName();
        Reference.class.getName();
        LinkNode.class.getName();
        SearchEngine.SearchHint.class.getName();
        SearchEngine.class.getName();
        InternalSearchEngine.class.getName();
        TextRange.class.getName();
        SearchRequestor.class.getName();
        ReferenceDatabase.class.getName();
        LifecycleEvent.Kind.class.getName();
        ErrorEvent.Kind.class.getName();
        ReferenceEvent.Kind.class.getName();
        if (Logger.PERF_ENABLED) {
            PerformanceStats.addListener((PerformanceStats.PerformanceListener)new PerfStatsListener());
        }
        long checksum = 0L;
        checksum ^= BrokenReferenceStrategyService.getInstance().checksum();
        checksum ^= LinkDetectorService.getInstance().checksum();
        checksum ^= LinkNodeModelService.getInstance().checksum();
        checksum ^= LinkTransformerService.getInstance().checksum();
        checksum ^= LinkTypeRegistry.getInstance().checksum();
        checksum ^= ReferenceGeneratorService.getInstance().checksum();
        checksum ^= ReferenceResolverService.getInstance().checksum();
        checksum ^= SearchParticipantService.getInstance().checksum();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.etools.references.ui", "ignoredPaths");
        IConfigurationElement[] iConfigurationElementArray = elements = point == null ? new IConfigurationElement[]{} : point.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            Adler32 a = new Adler32();
            Service.getChecksum(ce, a);
            checksum ^= a.getValue();
            ++n2;
        }
        String actualChecksum = Long.toString(checksum);
        boolean fullAnalysis = false;
        IPath location = this.getStateLocation();
        if (location != null) {
            File marker;
            File directory;
            block28: {
                Status s;
                directory = location.toFile();
                File checksumFile = new File(directory, EXT_PT_CHEKSUM);
                if (checksumFile.exists()) {
                    try {
                        BufferedInputStream url = new BufferedInputStream(checksumFile.toURI().toURL().openStream());
                        Properties p = new Properties();
                        p.load(url);
                        ((InputStream)url).close();
                        String expectedChecksum = p.getProperty("checksum");
                        if (!actualChecksum.equals(expectedChecksum)) {
                            p.setProperty("checksum", actualChecksum);
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(checksumFile));
                            p.store(out, "");
                            out.close();
                            fullAnalysis = true;
                            Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Contribution extension points have changed. Not using saved link database.");
                        }
                    }
                    catch (IOException e) {
                        s = new Status(4, PLUGIN_ID, "Could not read checksum", (Throwable)e);
                        Logger.log((IStatus)s);
                    }
                } else {
                    fullAnalysis = true;
                    Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Database files not present. Will perform full workspace analysis.");
                    try {
                        Properties p = new Properties();
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(checksumFile));
                        p.setProperty("checksum", actualChecksum);
                        p.store(out, "");
                        out.close();
                    }
                    catch (IOException e) {
                        s = new Status(4, PLUGIN_ID, "Could not create checksum", (Throwable)e);
                        Logger.log((IStatus)s);
                    }
                }
                try {
                    URL dbVersionURL = context.getBundle().getEntry(EXT_PT_DBVER);
                    InputStream bundleVStream = dbVersionURL.toURI().toURL().openStream();
                    Properties bVProperties = new Properties();
                    bVProperties.load(bundleVStream);
                    bundleVStream.close();
                    String actualVersion = bVProperties.getProperty("version", "0");
                    File dbVersionFile = new File(directory, EXT_PT_DBVER);
                    if (dbVersionFile.exists()) {
                        try {
                            BufferedInputStream url = new BufferedInputStream(dbVersionFile.toURI().toURL().openStream());
                            Properties p = new Properties();
                            p.load(url);
                            ((InputStream)url).close();
                            String foundVersion = p.getProperty("version");
                            if (foundVersion.equals(actualVersion)) break block28;
                            p.setProperty("version", actualVersion);
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dbVersionFile));
                            p.store(out, "");
                            out.close();
                            if (!fullAnalysis) {
                                fullAnalysis = true;
                                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "DB format has changed. Will rebuild database in new format");
                            }
                            break block28;
                        }
                        catch (IOException e) {
                            Status s2 = new Status(4, PLUGIN_ID, "Could not read version", (Throwable)e);
                            Logger.log((IStatus)s2);
                        }
                        break block28;
                    }
                    try {
                        Properties p = new Properties();
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dbVersionFile));
                        p.setProperty("version", actualVersion);
                        p.store(out, "");
                        out.close();
                    }
                    catch (IOException e) {
                        Status s3 = new Status(4, PLUGIN_ID, "Could not create db.version", (Throwable)e);
                        Logger.log((IStatus)s3);
                    }
                }
                catch (IOException e) {
                    s = new Status(4, PLUGIN_ID, "Could not find db.version in bundle", (Throwable)e);
                    Logger.log((IStatus)s);
                }
            }
            if ((marker = new File(directory, WORKBENCH_CRASH_DETECTOR_MARKER)).exists()) {
                if (!fullAnalysis) {
                    fullAnalysis = true;
                    Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Workspace crash detected. Not using saved link database.");
                }
            } else if (!marker.createNewFile()) {
                Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Could not create workspace crash detect marker. On next startup, all links will be rebuilt.");
            }
        } else {
            Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Could not create workspace crash detect marker. On next startup, all links will be rebuilt.");
        }
        if (InternalAPI.Tweaks.ALWAYS_CLEAR_DB) {
            Logger.logWarning(Logger.Category.REFERENCE_MANAGER, Logger.Mode.USER, "Always clear database option is set. Will perform full workspace analysis.");
            fullAnalysis = true;
        }
        this.startupJob = new ReferenceManagerStartupJob(fullAnalysis);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener());
        bundleTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        bundleTracker.open();
        Job notifyStartup = new Job(Messages.linkChangeNotification_job){

            protected IStatus run(IProgressMonitor monitor) {
                ThreadPriorityPolicy.setMinimumPriority(this.getThread());
                Activator.this.notifyLifecycleEvent(LifecycleEvent.Kind.STARTUP);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == ReferenceManager.class;
            }
        };
        if (fullAnalysis) {
            try {
                Activator.handleCrash();
            }
            catch (RuntimeException e) {
                InternalAPI.handleFrameworkException(ErrorRecovery.STARTUP_ERROR, NLS.bind((String)Messages.errorMsg_couldnotremovefiles, (Object)Activator.getDatabaseDirectory().toString()), e, EnumSet.of(ErrorEvent.PresentationHints.LOG, ErrorEvent.PresentationHints.BLOCK), true);
            }
        }
        ReferenceDatabase.READY_LATCH.countDown();
        notifyStartup.setSystem(true);
        notifyStartup.schedule();
        this.startupJob.schedule();
    }

    private void notifyLifecycleEvent(LifecycleEvent.Kind startup) {
        IConfigurationElement[] elements;
        this.lifecycleListeners = new ArrayList<IReferenceLifecycleListener>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PLUGIN_ID, "lifecycleListener");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Object o;
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    o = configurationElement.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "Ignoring contribution: " + configurationElement.getNamespaceIdentifier() + " Msg: " + e.getMessage());
                    break block5;
                }
                if (o instanceof IReferenceLifecycleListener) {
                    this.lifecycleListeners.add((IReferenceLifecycleListener)o);
                }
            }
            ++n2;
        }
        for (final IReferenceLifecycleListener listener : this.lifecycleListeners) {
            SafeRun.run(false, listener, new SafeRun.IRunnableWithResult<Object>(){

                @Override
                public Object run() throws Exception {
                    listener.handleLifecycleEvent(Collections.singletonList(new LifecycleEvent(LifecycleEvent.Kind.STARTUP)));
                    return null;
                }
            });
        }
    }

    public ReferenceManagerStartupJob getStartupJob() {
        return this.startupJob;
    }

    public void stop(BundleContext context) throws Exception {
        for (final IReferenceLifecycleListener listener : this.lifecycleListeners) {
            SafeRun.run(false, listener, new SafeRun.IRunnableWithResult<Object>(){

                @Override
                public Object run() throws Exception {
                    listener.handleLifecycleEvent(Collections.singletonList(new LifecycleEvent(LifecycleEvent.Kind.SHUTDOWN)));
                    return null;
                }
            });
        }
        ReferenceManager.getReferenceManager().initiateShutdown();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

