/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.events;

import com.ibm.etools.references.management.IReferenceElement;
import java.util.EventObject;

public final class ReferenceEvent
extends EventObject {
    private static final Object NULL = new Object();
    private static final long serialVersionUID = 1L;
    private final Kind kind;
    private final IReferenceElement changedElement;

    public ReferenceEvent(IReferenceElement original, IReferenceElement changedElement, Kind kind) {
        super(original == null ? NULL : original);
        this.changedElement = changedElement;
        this.kind = kind;
    }

    @Deprecated
    public IReferenceElement getReferenceElement() {
        if (this.kind == Kind.ADD) {
            return this.getChangedElement();
        }
        return this.getOriginalElement();
    }

    public IReferenceElement getOriginalElement() {
        if (NULL == this.getSource()) {
            return null;
        }
        return (IReferenceElement)this.getSource();
    }

    public IReferenceElement getChangedElement() {
        return this.changedElement;
    }

    public Kind getKind() {
        return this.kind;
    }

    @Override
    public String toString() {
        return String.valueOf(this.kind.name()) + " ON OLD=[" + this.getOriginalElement() + "], NEW=[" + this.getChangedElement() + "]";
    }

    public static enum Kind {
        NO_CHANGE,
        ADD,
        REMOVE,
        CHANGE,
        FATAL_ERROR,
        RESET;

    }
}

