/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.management.IReferenceStatus;
import com.ibm.etools.references.management.ReferenceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class Logger {
    public static final long ORIGIN = System.currentTimeMillis();
    public static final String PERFKEY_INDEXFILE = "com.ibm.etools.references/perf/indexFile";
    public static final String PERFKEY_INDEXFILE_DETECT = "com.ibm.etools.references/perf/indexFile/detectNewPhase";
    public static final String PERFKEY_INDEXFILE_REMOVE = "com.ibm.etools.references/perf/indexFile/removeNewPhase";
    public static final String PERFKEY_INDEXFILE_RESOLVE = "com.ibm.etools.references/perf/indexFile/resolvePhase";
    public static final String PERFKEY_INDEXFILE_RR_DEP = "com.ibm.etools.references/perf/indexFile/reResolveDependentPhase";
    public static final String PERFKEY_INDEXFILE_RR_INC = "com.ibm.etools.references/perf/indexFile/reResolveIncomingPhase";
    public static final String PERFKEY_INDEXFILE_RR_INCREF = "com.ibm.etools.references/perf/indexFile/reResolveIncomingReferencesPhase";
    public static final String PERFKEY_RESOLVER = "com.ibm.etools.references/perf/resolver";
    public static final String PERFKEY_DETECTOR = "com.ibm.etools.references/perf/detector";
    public static final String PERFKEY_GENERATOR = "com.ibm.etools.references/perf/generator";
    public static final String PERFKEY_TRANSFORMER = "com.ibm.etools.references/perf/transformer";
    public static final String PERFKEY_SEARCH = "com.ibm.etools.references/perf/search";
    public static boolean PERF_ENABLED = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf"));
    public static boolean PERF_INDEXFILE_ENABLED = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/indexFile"));
    public static boolean PERF_INDEXFILE_DETECT = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/indexFile/detectNewPhase"));
    public static boolean PERF_INDEXFILE_REMOVE = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/indexFile/removeNewPhase"));
    public static boolean PERF_INDEXFILE_RESOLVE = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/indexFile/resolvePhase"));
    public static boolean PERF_INDEXFILE_RR_DEP = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/indexFile/reResolveDependentPhase"));
    public static boolean PERF_INDEXFILE_RR_INC = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/indexFile/reResolveIncomingPhase"));
    public static boolean PERF_INDEXFILE_RR_INCREF = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/indexFile/reResolveIncomingReferencesPhase"));
    public static boolean PERF_RESOLVER_ENABLED = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/resolver"));
    public static boolean PERF_DETECTOR_ENABLED = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/detector"));
    public static boolean PERF_GENERATOR_ENABLED = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/generator"));
    public static boolean PERF_TRANSFORMER_ENABLED = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/transformer"));
    public static boolean PERF_SEARCH = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.etools.references/perf/search"));
    public static boolean SHOULD_TRACE_ACTIVE_DOC_REINDEXING;
    public static boolean SHOULD_TRACE_CACHE_STATS;
    public static boolean SHOULD_TRACE_STRING;
    public static boolean SHOULD_TRACE_DEBUG;
    public static boolean SHOULD_TRACE_DEBUG_CONDITIONS;
    public static boolean SHOULD_TRACE_DEBUG_CONDITIONS_DETAILED;
    public static boolean SHOULD_TRACE_EVENT;
    public static boolean SHOULD_TRACE_EVENT_DETAILED;
    public static boolean SHOULD_TRACE_EXTENT_MANAGER_DETAILED;
    public static boolean SHOULD_TRACE_JDT_DELTA;
    public static boolean SHOULD_TRACE_JDT_LINKS;
    public static boolean SHOULD_TRACE_JOB_STATE_CHANGES;
    public static boolean SHOULD_TRACE_PROCESSOR;
    public static boolean SHOULD_TRACE_QUERY;
    public static boolean SHOULD_TRACE_QUERY_TIMING;
    public static boolean SHOULD_TRACE_REFERENCE_MANAGER;
    public static boolean SHOULD_TRACE_RESOURCE_DELTA;
    public static boolean SHOULD_TRACE_SCHEDULE_LARGE;
    public static boolean SHOULD_TRACE_SCHEDULE_SMALL;
    public static boolean SHOULD_TRACE_SCHEDULE_REPLACEMENT;
    public static boolean SHOULD_TRACE_SLOWQUERY;
    public static boolean SHOULD_TRACE_TIMING;
    public static boolean SHOULD_TRACE_MARKERS;
    private static Field[] fieldCache;
    private static List<ILogListener> listeners;
    private static DecimalFormat format;

    static {
        Category[] all = Category.values();
        fieldCache = new Field[all.length];
        int i = 0;
        while (i < all.length) {
            try {
                Logger.fieldCache[i] = Logger.class.getField("SHOULD_TRACE_" + all[i].name());
            }
            catch (Exception e) {
                Logger.logException("Internal Logger Exception during field caching for:  " + all[i].name(), e);
            }
            ++i;
        }
        Category[] categoryArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            Category category = categoryArray[n2];
            Logger.setDebugOptionEnabled(category, Logger.getDefault(category));
            ++n2;
        }
        listeners = new ArrayList<ILogListener>();
        format = new DecimalFormat("######");
    }

    private static boolean shouldLog(Category category, Mode m, Severity severity) {
        if (m == Mode.DEV_MANDATORY && (!Platform.isRunning() || Platform.inDebugMode())) {
            return true;
        }
        return Logger.isEnabled(category);
    }

    public static final void log(Category c, Severity s, IStatus status) {
        Logger.log(c, s, Mode.DEV, status);
    }

    public static final void log(IStatus status) {
        if (Platform.isRunning()) {
            Activator.getDefault().getLog().log(status);
        } else {
            Logger.printStatus(status);
            Logger.notifyListeners(status);
        }
    }

    private static void notifyListeners(final IStatus status) {
        if (listeners != null && !listeners.isEmpty()) {
            for (final ILogListener listener : listeners) {
                SafeRun.run(listener, new SafeRun.IRunnableWithResult<Object>(){

                    @Override
                    public Object run() throws Exception {
                        listener.logging(status, "com.ibm.etools.references");
                        return null;
                    }
                });
            }
        }
    }

    private static void printStatus(IStatus status) {
        System.out.println(status.getMessage());
        if (status.getException() != null) {
            status.getException().printStackTrace();
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s = iStatusArray[n2];
            System.out.println(s);
            ++n2;
        }
    }

    public static final void log(Category c, Severity s, Mode m, IStatus status) {
        if (m == Mode.TRACE) {
            Logger.printStatus(status);
            Logger.notifyListeners(status);
        } else {
            Logger.log(status);
        }
    }

    public static boolean shouldTrace(Category category) {
        return Logger.shouldLog(category, Mode.DEV, Severity.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void trace(Category category, String message, Throwable ... e) {
        if (Logger.shouldTrace(category)) {
            String trace = "";
            if (InternalAPI.Tweaks.SHOULD_INCLUDE_TIME_IN_TRACE) {
                long relative = System.currentTimeMillis() - ORIGIN;
                DecimalFormat decimalFormat = format;
                synchronized (decimalFormat) {
                    trace = String.valueOf(trace) + format.format(relative) + " ";
                }
            }
            trace = String.valueOf(trace) + Thread.currentThread().getName() + " [" + category.name() + "] " + message;
            Status status = null;
            status = e != null && e.length == 1 ? new Status(1, "com.ibm.etools.references", trace, e[0]) : new Status(1, "com.ibm.etools.references", trace, null);
            Logger.log(category, Severity.INFO, Mode.TRACE, (IStatus)status);
        }
    }

    public static final void logWarning(Category category, Mode m, String message) {
        if (Logger.shouldLog(category, m, Severity.WARNING)) {
            String trace = String.valueOf(Thread.currentThread().getName()) + " [" + category.toString() + " : " + Severity.WARNING.name() + "] " + message;
            Status status = new Status(2, "com.ibm.etools.references", trace);
            Logger.log(category, Severity.WARNING, m, (IStatus)status);
        }
    }

    public static void logException(String message, Throwable e) {
        Logger.logException(Thread.currentThread(), message, e);
    }

    public static void logException(Thread thread, String message, Throwable e) {
        IReferenceStatus status = null;
        if (e instanceof ReferenceException) {
            status = ((ReferenceException)e).getStatus();
        } else if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
            if (message != null) {
                status = new MultiStatus("com.ibm.etools.references", 0, message, null);
            }
        }
        if (status != null) {
            Logger.log(status);
        } else {
            String trace = thread == null ? Thread.currentThread().getName() : thread.getName();
            trace = String.valueOf(trace) + (e == null ? "[ERROR]" : " [EXCEPTION] ") + message;
            status = new Status(4, "com.ibm.etools.references", trace, e);
            Logger.log(status);
        }
    }

    public static void addLogListener(ILogListener listener) {
        listeners.add(listener);
        if (Activator.getDefault() != null) {
            Activator.getDefault().getLog().addLogListener(listener);
        }
    }

    public static void removeLogListener(ILogListener listener) {
        listeners.remove(listener);
        if (Activator.getDefault() != null) {
            Activator.getDefault().getLog().removeLogListener(listener);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getDefault(Category option) {
        boolean theOption = false;
        if (Platform.isRunning()) {
            return Boolean.parseBoolean(Platform.getDebugOption((String)option.getOption()));
        }
        URL l = Logger.class.getResource("");
        if (l == null) return theOption;
        FileInputStream stream = null;
        File f = new File(l.toURI());
        String name = f.getName();
        while (name != null) {
            if ("com.ibm.etools.references".equals(name)) break;
            name = (f = f.getParentFile()) != null ? f.getName() : null;
        }
        f = new File(f, "/.options");
        stream = new FileInputStream(f);
        Properties p = new Properties();
        p.load(stream);
        boolean bl = Boolean.parseBoolean((String)p.get(option.getOption()));
        if (stream == null) return bl;
        try {
            stream.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        catch (Exception e) {
            try {
                Logger.logException("Internal exception in logger", e);
                if (stream == null) return theOption;
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
                return theOption;
            }
            catch (IOException iOException) {}
            return theOption;
        }
    }

    public static void setDebugOptionEnabled(Category category, boolean enabled) {
        try {
            fieldCache[category.ordinal()].set(null, enabled);
        }
        catch (Exception e) {
            Logger.logException("Internal Logger Exception during setDebugOptionEnabled() for " + category.name(), e);
        }
    }

    public static boolean isEnabled(Category category) {
        try {
            Boolean debug = (Boolean)fieldCache[Category.DEBUG.ordinal()].get(null);
            Boolean b = (Boolean)fieldCache[category.ordinal()].get(null);
            return b != false && debug != false;
        }
        catch (Exception e) {
            Logger.logException("Internal Logger Exception during isEnabled() for " + category.name(), e);
            return false;
        }
    }

    public static enum Category {
        REFERENCE_MANAGER,
        EVENT("/event"),
        EVENT_DETAILED("/event/detailed"),
        TIMING("/timing"),
        PROCESSOR,
        DEBUG,
        DEBUG_CONDITIONS("/debug/conditions"),
        DEBUG_CONDITIONS_DETAILED("/debug/conditions/detailed"),
        JOB_STATE_CHANGES("/jobstatechanges"),
        CACHE_STATS("/cachestats"),
        SLOWQUERY("/query/slow"),
        QUERY("/query"),
        QUERY_TIMING("/query/timing"),
        ACTIVE_DOC_REINDEXING("/activedoc/reindexing"),
        JDT_DELTA("/jdtDelta"),
        JDT_LINKS("/jdtLinks"),
        EXTENT_MANAGER_DETAILED("/extentmanager/detailed"),
        SCHEDULE_LARGE("/scheduler/schedule/large"),
        SCHEDULE_SMALL("/scheduler/schedule/small"),
        SCHEDULE_REPLACEMENT("/scheduler/schedule/replacements"),
        RESOURCE_DELTA("/resourceDelta"),
        MARKERS("/markers"),
        STRING("/string");

        private final String option;

        private Category() {
            this(null);
        }

        private Category(String option) {
            this.option = option == null ? "com.ibm.etools.references/debug" : "com.ibm.etools.references" + option;
        }

        public String getOption() {
            return this.option;
        }
    }

    public static enum Mode {
        USER,
        DEV,
        DEV_MANDATORY,
        TRACE;

    }

    public static enum Severity {
        WARNING,
        ERROR,
        INFO,
        DEBUG;

    }
}

