/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.providers.generators.WebAppRelativeGeneratorProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WebLinkWebAppRelativeGeneratorProvider
extends WebAppRelativeGeneratorProvider {
    @Override
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        Reference reference = this.createReference(link, transformResult, referenceType);
        if (reference == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(reference);
    }

    @Override
    public String renameReference(RefactoringGeneratorParameters params) {
        String newString = null;
        String noQuotes = AbstractWebProvider.trimQuotes(params.transformResult);
        Path targetPath = new Path((String)params.renameParameters.get("web.ref.abs.path.id"));
        IPath linkPath = this.getWebAppRootRelativePath((IPath)targetPath);
        if (linkPath != null) {
            linkPath = noQuotes.startsWith("/") || noQuotes.startsWith("\\") ? linkPath.makeAbsolute() : linkPath.makeRelative();
            newString = linkPath.toString();
            newString = URIUtil.addURIComponents(newString, this.getTargetContainer(params), noQuotes);
        }
        return newString;
    }

    @Override
    protected IPath getAbsolutePathFromLink(URIUtil.ParsedURI uri, ILink link) {
        IPath absPath = this.getWorkspacePathForWebAppRelativeLink(link, uri);
        return absPath;
    }
}

