/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.providers.generators.WebLinkGeneratorProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WebLinkCodebaseClassGeneratorProvider
extends WebLinkGeneratorProvider {
    @Override
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        Reference reference = this.createReference(link, transformResult, referenceType);
        if (reference == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(reference);
    }

    @Override
    protected Reference createReference(ILink link, String rawLink, String referenceType) {
        String noQuotes = AbstractWebProvider.trimQuotes(rawLink);
        String codebaseValue = link.getParameter("param.codebase");
        if (codebaseValue != null) {
            IPath codebasedPath = new Path(codebaseValue).append(noQuotes);
            noQuotes = codebasedPath.toString();
        }
        return super.createReference(link, noQuotes, referenceType);
    }

    @Override
    public String renameReference(RefactoringGeneratorParameters params) {
        String renamedResult = super.renameReference(new RefactoringGeneratorParameters(params.newReferenceTargetContainer, params.reference, params.transformResult, params.renameParameters, params.renameArguments));
        String codebaseValue = params.reference.getSource().getParameter("param.codebase");
        if (codebaseValue != null && renamedResult != null && renamedResult.startsWith(codebaseValue) && (renamedResult = renamedResult.substring(codebaseValue.length())).startsWith("/")) {
            renamedResult = renamedResult.substring(1);
        }
        return renamedResult;
    }
}

