/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.internal.providers.detectors;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import com.ibm.etools.references.web.internal.providers.detectors.CSSLinkDetector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class WebLinkDetector
extends CSSLinkDetector {
    private static HashMap<String, String[]> nameAttributeMap = new HashMap();
    private String baseHrefValue = null;
    private static final String[] EMPTY_ATTRIBUTE_SET = new String[0];

    static {
        nameAttributeMap.put("A", new String[]{"href"});
        nameAttributeMap.put("BASE", new String[]{"href"});
        nameAttributeMap.put("BODY", new String[]{"background"});
        nameAttributeMap.put("AREA", new String[]{"href"});
        nameAttributeMap.put("LINK", new String[]{"href"});
        nameAttributeMap.put("IMG", new String[]{"src", "mapfile", "usemap", "dynsrc", "authortimeimagesrc", "lowsrc"});
        nameAttributeMap.put("MAP", new String[]{"name"});
        nameAttributeMap.put("OBJECT", new String[]{"codebase", "classid", "archive", "usemap", "data"});
        nameAttributeMap.put("EMBED", new String[]{"src"});
        nameAttributeMap.put("Q", new String[]{"cite"});
        nameAttributeMap.put("BLOCKQUOTE", new String[]{"cite"});
        nameAttributeMap.put("INS", new String[]{"cite"});
        nameAttributeMap.put("DEL", new String[]{"cite"});
        nameAttributeMap.put("OL", new String[]{"imgsrc"});
        nameAttributeMap.put("UL", new String[]{"imgsrc"});
        nameAttributeMap.put("FORM", new String[]{"action"});
        nameAttributeMap.put("INPUT", new String[]{"src"});
        nameAttributeMap.put("TEXTAREA", new String[]{"src"});
        nameAttributeMap.put("TABLE", new String[]{"imgsrc"});
        nameAttributeMap.put("TR", new String[]{"background"});
        nameAttributeMap.put("TH", new String[]{"background"});
        nameAttributeMap.put("TD", new String[]{"background"});
        nameAttributeMap.put("SCRIPT", new String[]{"src"});
        nameAttributeMap.put("FRAME", new String[]{"src"});
        nameAttributeMap.put("IFRAME", new String[]{"src"});
        nameAttributeMap.put("APPLET", new String[]{"code", "codebase", "archive"});
        nameAttributeMap.put("SERVLET", new String[]{"code"});
        nameAttributeMap.put("ssi:include".toUpperCase(), new String[]{"file", "virtual"});
        nameAttributeMap.put("ssi:fsize".toUpperCase(), new String[]{"file"});
        nameAttributeMap.put("ssi:flastmod".toUpperCase(), new String[]{"file"});
    }

    private void addLinkParameters(ReferenceElementFactory factory, Node n, String nName, String linkType, ILink desc) {
        String codebaseValue;
        if ("web.basehref.link".equals(linkType)) {
            this.baseHrefValue = WebLinkDetector.trimQuotes(desc.getLinkText());
        } else if (this.baseHrefValue != null) {
            factory.addParam(desc, "param.base.href", this.baseHrefValue);
        }
        if ((linkType == "web.classresource.link" || linkType == "web.separatedresources.link") && (codebaseValue = AbstractWebProvider.getAttributeValueForTag(n, nName, "codebase")) != null) {
            factory.addParam(desc, "param.codebase", codebaseValue);
        }
    }

    @Override
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
            Node n = iter.nextNode();
            while (n != null) {
                links.addAll(this.handleCSS(factory, model, n));
                String domNodeName = n.getNodeName();
                if (domNodeName != null) {
                    Attr attr;
                    String[] detectedAttributes = nameAttributeMap.get(domNodeName.toUpperCase());
                    if (detectedAttributes == null) {
                        detectedAttributes = EMPTY_ATTRIBUTE_SET;
                    }
                    IDOMElement domElement = (IDOMElement)n;
                    if (detectedAttributes.length != 0) {
                        NamedNodeMap domAttributeNodes = n.getAttributes();
                        int length = domAttributeNodes.getLength();
                        int i = 0;
                        while (i < length) {
                            String linkType;
                            Node domAttributeItem = domAttributeNodes.item(i);
                            String linkName = null;
                            String domAttName = domAttributeItem.getNodeName();
                            if (domNodeName.equalsIgnoreCase("MAP")) {
                                linkName = domAttributeItem.getNodeValue();
                                linkType = this.getLinkType(domNodeName, domAttName);
                                ILink desc = AbstractWebProvider.createLink(new CreateLinkParameter(factory, domElement, null, linkType, linkName));
                                links.add(desc);
                                break;
                            }
                            if (domAttName.equalsIgnoreCase("name") && domNodeName.equalsIgnoreCase("A")) {
                                linkName = domAttributeItem.getNodeValue();
                                linkType = this.getLinkType(domNodeName, domAttName);
                                ILink desc = AbstractWebProvider.createLink(new CreateLinkParameter(factory, domElement, null, linkType, linkName));
                                links.add(desc);
                            }
                            String[] stringArray = detectedAttributes;
                            int n2 = detectedAttributes.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String detectedAttribute = stringArray[n3];
                                if (domAttName.compareToIgnoreCase(detectedAttribute) == 0) {
                                    String linkType2 = this.getLinkType(domNodeName, domAttName);
                                    IDOMAttr attr2 = (IDOMAttr)domAttributeItem;
                                    ILink webLink = AbstractWebProvider.createLink(new CreateLinkParameter(factory, domElement, (IDOMNode)attr2, linkType2, linkName));
                                    this.addLinkParameters(factory, n, domNodeName, linkType2, webLink);
                                    links.add(webLink);
                                    break;
                                }
                                ++n3;
                            }
                            ++i;
                        }
                    }
                    if (InternalAPI.Tweaks.SHOULD_INDEX_HTML_ID_ATTRIBUTE && (attr = domElement.getAttributeNode("id")) != null) {
                        String linkName = attr.getValue();
                        String linkType = this.getLinkType(domNodeName, "id");
                        ILink desc = AbstractWebProvider.createLink(new CreateLinkParameter(factory, domElement, null, linkType, linkName, true));
                        links.add(desc);
                    }
                }
                n = iter.nextNode();
            }
        }
        this.baseHrefValue = null;
        return links;
    }

    private String getLinkType(String nodeName, String attName) {
        String linkType = "web.commonlink";
        if (nodeName.equalsIgnoreCase("ssi:include")) {
            if (attName.equalsIgnoreCase("virtual")) {
                linkType = "web.docrootonly.link";
            }
        } else if (nodeName.equalsIgnoreCase("APPLET")) {
            if (attName.equalsIgnoreCase("code")) {
                linkType = "web.classresource.link";
            } else if (attName.equalsIgnoreCase("archive")) {
                linkType = "web.separatedresources.link";
            }
        } else if (nodeName.equalsIgnoreCase("OBJECT")) {
            if (attName.equalsIgnoreCase("classid") || attName.equalsIgnoreCase("data")) {
                linkType = "web.classresource.link";
            } else if (attName.equalsIgnoreCase("archive")) {
                linkType = "web.separatedresources.link";
            }
        } else if (nodeName.equalsIgnoreCase("BASE") && attName.equalsIgnoreCase("href")) {
            linkType = "web.basehref.link";
        }
        return linkType;
    }

    private List<ILink> handleCSS(ReferenceElementFactory factory, IDOMModel model, Node n) {
        ArrayList<ILink> styleLinks = new ArrayList<ILink>();
        if (factory == null || model == null || n == null) {
            return styleLinks;
        }
        if (n instanceof IDOMElement) {
            IDOMElement e = (IDOMElement)n;
            String nName = n.getNodeName();
            boolean hasStyleAttr = false;
            hasStyleAttr = e.hasAttribute("style");
            if (nName.equals("style") || hasStyleAttr) {
                TextRange contextRange;
                List<ILink> links;
                int contextStartOffset = e.getStartOffset();
                int contextLength = e.getEndOffset() - contextStartOffset;
                IStructuredDocument str = model.getStructuredDocument();
                int clines = str.getLineOfOffset(contextStartOffset);
                String contextText = null;
                try {
                    contextText = str.get(contextStartOffset, contextLength);
                }
                catch (BadLocationException badLocationException) {}
                if (contextText != null && (links = this.reParse(factory, contextText, !hasStyleAttr, contextRange = new TextRange(contextStartOffset, contextLength, clines))) != null) {
                    styleLinks.addAll(links);
                }
            }
        }
        return styleLinks;
    }
}

