/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.internal.providers.detectors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.css.core.internal.parser.CSSSourceParser;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class CSSLinkDetector
extends AbstractWebProvider
implements ILinkDetectorProvider {
    private ILink createCSSLink(ReferenceElementFactory factory, IStructuredDocumentRegion node, ITextRegion region, String name, String text, TextRange globalRange) {
        int offset;
        String regionText = node.getText(region);
        int offset2 = offset = node.getStartOffset(region) + regionText.indexOf(text);
        IStructuredDocument structuredDocument = node.getParentDocument();
        int contextStartOffset = node.getStartOffset();
        int contextLength = node.getEndOffset() - contextStartOffset;
        int valueStartOffset = offset2;
        int valueLength = text.length();
        try {
            String contextText = structuredDocument.get(contextStartOffset, contextLength);
            String valueText = structuredDocument.get(valueStartOffset, valueLength);
            TextRange linkRange = new TextRange(valueStartOffset + globalRange.getOffset(), valueLength, structuredDocument.getLineOfOffset(valueStartOffset) + globalRange.getLinenumber());
            TextRange contextRange = new TextRange(contextStartOffset + globalRange.getOffset(), contextLength, structuredDocument.getLineOfOffset(contextStartOffset) + globalRange.getLinenumber());
            return factory.createLink("wst.css.link", name, contextText, contextRange, valueText, linkRange, false);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IStructuredDocument createFlatModel(String text, boolean declaration) {
        RegionParser parser;
        IModelManager mm = StructuredModelManager.getModelManager();
        IStructuredDocument model = mm.createStructuredDocumentFor(ContentTypeIdForCSS.ContentTypeID_CSS);
        if (declaration && (parser = model.getParser()) instanceof CSSSourceParser) {
            ((CSSSourceParser)parser).setParserMode(1);
        }
        model.setText(null, text);
        return model;
    }

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        List<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof ICSSModel) {
            ICSSModel model = (ICSSModel)sharedModel.getSharedModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            links = this.handleFlatNodes(factory, structuredDocument.getRegionList(), new TextRange(0, 0, 0));
        }
        return links;
    }

    protected List<ILink> handleFlatNodes(ReferenceElementFactory factory, IStructuredDocumentRegionList nodeList, TextRange range) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        Enumeration e = nodeList.elements();
        while (e.hasMoreElements()) {
            IStructuredDocumentRegion node = (IStructuredDocumentRegion)e.nextElement();
            if (node == null) continue;
            String nodeType = CSSUtil.getStructuredDocumentRegionType((IStructuredDocumentRegion)node);
            if (nodeType == "IMPORT") {
                this.handleImportRule(factory, links, node, range);
                continue;
            }
            ITextRegionList regions = node.getRegions();
            int size = regions.size();
            int i = 0;
            while (i < size) {
                String regionType;
                ITextRegion region = regions.get(i);
                if (region != null && ((regionType = region.getType()) == "DECLARATION_VALUE_URI" || regionType == "URI")) {
                    this.handleURI(factory, links, node, region, range);
                }
                ++i;
            }
        }
        return links;
    }

    private void handleImportRule(ReferenceElementFactory factory, List<ILink> links, IStructuredDocumentRegion node, TextRange range) {
        ITextRegionList regions = node.getRegions();
        int size = regions.size();
        int i = 0;
        while (i < size) {
            ITextRegion region = regions.get(i);
            if (region != null) {
                String type = region.getType();
                if (type == "URI") {
                    this.handleURI(factory, links, node, region, range);
                } else if (type == "STRING") {
                    this.handleSTRING(factory, links, node, region, range);
                }
            }
            ++i;
        }
    }

    private void handleSTRING(ReferenceElementFactory factory, List<ILink> links, IStructuredDocumentRegion node, ITextRegion region, TextRange range) {
        String regionText = node.getText(region);
        String text = CSSUtil.extractStringContents((String)regionText);
        ILink cssLink = this.createCSSLink(factory, node, region, null, text, range);
        links.add(cssLink);
    }

    private void handleURI(ReferenceElementFactory factory, List<ILink> links, IStructuredDocumentRegion node, ITextRegion region, TextRange range) {
        String regionText = node.getText(region);
        String text = CSSUtil.extractUriContents((String)regionText);
        ILink cssLink = this.createCSSLink(factory, node, region, null, text, range);
        links.add(cssLink);
    }

    protected List<ILink> reParse(ReferenceElementFactory factory, String content, boolean styleTag, TextRange range) {
        List<ILink> links = new Vector<ILink>();
        IStructuredDocument cssFlatModel = null;
        cssFlatModel = !styleTag ? this.createFlatModel(content, true) : this.createFlatModel(content, false);
        if (cssFlatModel != null) {
            links = this.handleFlatNodes(factory, cssFlatModel.getRegionList(), range);
        }
        return links;
    }
}

