/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web;

import com.ibm.etools.references.web.URIUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WebUtil {
    private static final HashMap<IProject, IVirtualComponent> componentCache = new LinkedHashMap<IProject, IVirtualComponent>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<IProject, IVirtualComponent> eldest) {
            return this.size() >= 10;
        }
    };

    public static IContainer getContainer(IPath path) {
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        switch (path.segmentCount()) {
            case 0: {
                return root;
            }
            case 1: {
                return root.getProject(path.segment(0));
            }
        }
        return root.getFolder(path);
    }

    public static IVirtualComponent findComponent(IResource resource) {
        return resource == null ? null : WebUtil.getCachedComponent(resource.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IVirtualComponent getCachedComponent(IProject project) {
        Class<WebUtil> clazz = WebUtil.class;
        synchronized (WebUtil.class) {
            IVirtualComponent component = componentCache.get(project);
            if (component == null && (component = ComponentCore.createComponent((IProject)project)) != null) {
                componentCache.put(project, component);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return component;
        }
    }

    public static IPath getWorkspaceRelativeDocRootPath(IVirtualComponent component) {
        IVirtualFolder folder;
        if (component != null && (folder = component.getRootFolder()) != null) {
            return folder.getWorkspaceRelativePath();
        }
        return null;
    }

    public static IPath getProjectRelativeDocRootPath(IVirtualComponent component) {
        IVirtualFolder folder;
        if (component != null && (folder = component.getRootFolder()) != null) {
            return folder.getProjectRelativePath();
        }
        return null;
    }

    public static IContainer getDocumentRootContainer(IVirtualComponent component) {
        return WebUtil.getContainer(WebUtil.getWorkspaceRelativeDocRootPath(component));
    }

    public static IContainer getDocumentRootContainer(IResource file) {
        return file == null ? null : WebUtil.getDocumentRootContainer(WebUtil.findComponent(file));
    }

    public static IPath getDocumentRootRelativePath(IFile file) {
        IContainer container = WebUtil.getDocumentRootContainer((IResource)file);
        if (container == null) {
            return null;
        }
        IPath filePath = file.getFullPath();
        int matchSegs = filePath.matchingFirstSegments(container.getFullPath());
        filePath = filePath.removeFirstSegments(matchSegs).makeAbsolute();
        return filePath;
    }

    public static final IPath getWorkspacePathForRelativeURI(IFile container, URIUtil.ParsedURI uri) {
        IPath absPath = null;
        if (uri.path.length() == 0 && uri.fragment != null) {
            absPath = container.getFullPath();
        } else {
            absPath = container.getParent().getFullPath().append(uri.path);
            IContainer docRootFolder = WebUtil.getDocumentRootContainer((IResource)container);
            if (docRootFolder == null) {
                return absPath;
            }
            IPath filePath = container.getFullPath();
            int maxDoubleDotLimit = 0;
            if (docRootFolder.getFullPath().isPrefixOf(filePath)) {
                int matches = filePath.matchingFirstSegments(docRootFolder.getFullPath());
                filePath = filePath.removeFirstSegments(matches);
                filePath = filePath.removeLastSegments(1);
                maxDoubleDotLimit = Math.max(0, filePath.segmentCount());
            }
            int doubleDotCount = 0;
            String[] split = uri.path.split("/");
            int i = 0;
            while (i < split.length) {
                if ("..".equals(split[i])) {
                    ++doubleDotCount;
                } else if (!".".equals(split[i])) break;
                ++i;
            }
            if (doubleDotCount > maxDoubleDotLimit) {
                if (doubleDotCount - maxDoubleDotLimit > 1) {
                    return null;
                }
                Path p = new Path(uri.path);
                if ((p = p.removeFirstSegments(doubleDotCount)).segmentCount() == 0) {
                    return null;
                }
                int i2 = 1;
                while (i2 < p.segmentCount()) {
                    IContainer docRoot;
                    IPath possibleContextRoot = p.uptoSegment(i2);
                    IProject project = WebUtil.getProjectWithContextRoot(possibleContextRoot = possibleContextRoot.makeAbsolute());
                    if (project != null && (docRoot = WebUtil.getDocumentRootContainer((IResource)project)) != null) {
                        absPath = docRoot.getFullPath().append(p.removeFirstSegments(i2));
                        break;
                    }
                    ++i2;
                }
            } else {
                return absPath;
            }
        }
        return absPath;
    }

    public static final IPath getWorkspacePathForServerContextURI(IFile container, URIUtil.ParsedURI uri) {
        IPath absPath = null;
        Path uriPath = new Path(uri.path);
        if (uriPath.segmentCount() == 0) {
            return null;
        }
        Assert.isLegal((boolean)uriPath.isAbsolute(), (String)"This method only handles absolute-style links");
        String actualDocRoot = ComponentUtilities.getServerContextRoot((IProject)container.getProject());
        if (actualDocRoot == null) {
            if (uriPath.toString().startsWith("/")) {
                return uriPath;
            }
            return null;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (container.getProject().equals((Object)projects[i])) {
                IProject swap = projects[0];
                projects[0] = projects[i];
                projects[i] = swap;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < uriPath.segmentCount()) {
            IPath possibleContextRootPath = uriPath.uptoSegment(i);
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                String alternateContextRoot = ComponentUtilities.getServerContextRoot((IProject)project);
                if (alternateContextRoot != null) {
                    IContainer crossProjectFolder;
                    Path alternativeDocRootPath = new Path(alternateContextRoot);
                    if (possibleContextRootPath.equals((Object)(alternativeDocRootPath = alternativeDocRootPath.makeAbsolute())) && (crossProjectFolder = WebUtil.getDocumentRootContainer(WebUtil.findComponent((IResource)project))) != null) {
                        IPath path;
                        absPath = path = crossProjectFolder.getFullPath().append(uriPath.removeFirstSegments(i));
                        break;
                    }
                }
                ++n2;
            }
            ++i;
        }
        return absPath;
    }

    private static IProject getProjectWithContextRoot(IPath contextRoot) {
        Assert.isLegal((boolean)contextRoot.isAbsolute(), (String)"This method only works with absolute IPaths");
        IProject[] project = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < project.length) {
            String actualDocRoot = ComponentUtilities.getServerContextRoot((IProject)project[i]);
            if (actualDocRoot != null) {
                Path actualDocRootPath = new Path(actualDocRoot);
                if (contextRoot.equals((Object)(actualDocRootPath = actualDocRootPath.makeAbsolute()))) {
                    return project[i];
                }
            }
            ++i;
        }
        return null;
    }

    public static final IPath convertFileURLToWorkspacePath(String fileUrlPath, IProject project) {
        String path = fileUrlPath;
        if (path.startsWith("file:///")) {
            path = path.substring("file:///".length());
        } else if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        }
        Path p = new Path(path);
        IPath fullPathOfPath = WebUtil.getFullPathOfPath((IPath)p, project);
        return fullPathOfPath;
    }

    private static final IPath getFullPathOfPath(IPath fullLocalIPath, IProject project) {
        if (project == null) {
            return null;
        }
        IPath projLoc = project.getLocation();
        if (projLoc != null && projLoc.isPrefixOf(fullLocalIPath)) {
            int seg = projLoc.segmentCount();
            return project.getFullPath().append(fullLocalIPath.removeFirstSegments(seg));
        }
        return null;
    }

    public static IPath getAbsolutePathFromURI(IFile container, URIUtil.ParsedURI uri) {
        IPath absPath = null;
        if (uri.scheme != null) {
            if (uri.scheme.equals("file")) {
                String filePath = uri.path;
                if (uri.authority != null && uri.authority.length() > 0) {
                    filePath = String.valueOf(uri.authority) + uri.path;
                }
                absPath = WebUtil.convertFileURLToWorkspacePath(filePath, container.getProject());
            }
        } else {
            absPath = uri.path.startsWith("/") || uri.path.startsWith("\\") ? WebUtil.getWorkspacePathForServerContextURI(container, uri) : WebUtil.getWorkspacePathForRelativeURI(container, uri);
        }
        return absPath;
    }

    public static final IPath getWebAppRootRelativePath(IPath targetPath) {
        IContainer docRootFolder;
        IFile targetFile;
        IPath linkPath = null;
        if (targetPath != null && (targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath)) != null && (docRootFolder = WebUtil.getDocumentRootContainer((IResource)targetFile)) != null) {
            IPath docRootFolderPath = docRootFolder.getFullPath();
            int matchingFirstSegments = targetPath.matchingFirstSegments(docRootFolderPath);
            linkPath = targetPath.removeFirstSegments(matchingFirstSegments);
        }
        return linkPath;
    }
}

