/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.web.WebUtil;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;

public class URIUtil {
    private static Pattern PARSER = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static ParsedURI ERROR = URIUtil.parse("");

    public static String makeAbsoluteURI(String baseURI, String relativeURI) {
        ParsedURI base = URIUtil.parse(baseURI);
        ParsedURI resolvee = URIUtil.parse(relativeURI);
        if (resolvee.scheme != null) {
            return resolvee.toString();
        }
        String newString = "";
        if (base.scheme != null) {
            newString = String.valueOf(newString) + base.scheme;
        }
        if (resolvee.authority != null && resolvee.authority.length() > 0) {
            newString = String.valueOf(newString) + resolvee.authority;
            newString = String.valueOf(newString) + resolvee.path;
        } else {
            if (base.authority != null) {
                newString = String.valueOf(newString) + base.authority;
            }
            if (resolvee.path != null && (resolvee.path.startsWith("/") || resolvee.path.length() == 0)) {
                newString = String.valueOf(newString) + resolvee.path;
            } else {
                String resolveePathString = resolvee.path == null ? "" : resolvee.path;
                Path resolveePath = new Path(resolveePathString);
                String basePathString = base.path == null ? "" : base.path;
                Path basePath = new Path(basePathString);
                basePath = basePath.removeLastSegments(1);
                basePath = basePath.append((IPath)resolveePath);
                newString = String.valueOf(newString) + basePath.toString();
            }
        }
        if (resolvee.query != null) {
            newString = String.valueOf(newString) + "?" + resolvee.query;
        }
        if (resolvee.fragment != null) {
            newString = String.valueOf(newString) + "#" + resolvee.fragment;
        }
        return newString;
    }

    public static String rename(Set<ProviderArguments> args, IProject project, String relativeToURI, String originalURI, String targetURI, String newContextRoot) {
        IFile file;
        Path path;
        Assert.isLegal((project != null ? 1 : 0) != 0, (String)"project param can't be null");
        Assert.isLegal((relativeToURI != null ? 1 : 0) != 0, (String)"relativeToURI param can't be null");
        Assert.isLegal((originalURI != null ? 1 : 0) != 0, (String)"originalURI param can't be null");
        Assert.isLegal((targetURI != null ? 1 : 0) != 0, (String)"targetURI param can't be null");
        ProviderArguments style = null;
        style = args.contains(ProviderArguments.LINKSTYLE_ABSOLUTE) ? ProviderArguments.LINKSTYLE_ABSOLUTE : (args.contains(ProviderArguments.LINKSTYLE_PRESERVE) ? ProviderArguments.LINKSTYLE_PRESERVE : (args.contains(ProviderArguments.LINKSTYLE_RELATIVE) ? ProviderArguments.LINKSTYLE_RELATIVE : ProviderArguments.LINKSTYLE_PRESERVE));
        boolean originalIsAbsolute = false;
        ParsedURI targetParsedURI = URIUtil.parse(targetURI);
        ParsedURI uri = URIUtil.parse(originalURI);
        ParsedURI relativeTo = URIUtil.parse(relativeToURI);
        if ("file".equals(uri.scheme)) {
            path = new Path(uri.path);
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (file != null) {
                uri.path = file.getFullPath().toString();
                uri.scheme = null;
                originalIsAbsolute = true;
            }
        }
        if ("file".equals(targetParsedURI.scheme)) {
            path = new Path(targetParsedURI.path);
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (file != null) {
                targetParsedURI.path = file.getFullPath().toString();
                targetParsedURI.scheme = null;
            }
        }
        if (targetParsedURI.scheme == null && "file".equals(uri.scheme)) {
            uri.scheme = null;
        }
        if (uri.path.startsWith("/") || uri.path.startsWith("\\")) {
            originalIsAbsolute = true;
        } else {
            uri = URIUtil.parse(URIUtil.makeAbsoluteURI(relativeToURI, originalURI).toString());
        }
        if (!targetParsedURI.path.startsWith("/") && !targetParsedURI.path.startsWith("\\")) {
            targetParsedURI = URIUtil.parse(URIUtil.makeAbsoluteURI(relativeToURI, targetURI).toString());
        }
        String newString = "";
        if (uri.scheme != null) {
            newString = String.valueOf(newString) + uri.scheme;
            newString = "file".equals(uri.scheme) ? String.valueOf(newString) + ":///" : String.valueOf(newString) + "://";
        }
        if (uri.authority != null) {
            newString = String.valueOf(newString) + uri.authority;
        }
        if (uri.path != null) {
            Path targetPath = new Path(targetParsedURI.path);
            if (originalIsAbsolute) {
                if (style == ProviderArguments.LINKSTYLE_ABSOLUTE || style == ProviderArguments.LINKSTYLE_PRESERVE) {
                    try {
                        newString = String.valueOf(newString) + URIUtil.createAbsPath(project, (IPath)targetPath, newContextRoot);
                    }
                    catch (RuntimeException runtimeException) {
                        newString = String.valueOf(newString) + targetPath;
                    }
                } else {
                    newString = uri.scheme != null ? String.valueOf(newString) + targetPath.toString() : (uri.path.length() == 0 ? String.valueOf(newString) + uri.path : String.valueOf(newString) + URIUtil.createRelPath(relativeTo.path, (IPath)targetPath, newContextRoot));
                }
            } else if (style == ProviderArguments.LINKSTYLE_RELATIVE || style == ProviderArguments.LINKSTYLE_PRESERVE) {
                newString = uri.scheme != null ? String.valueOf(newString) + targetPath.toString() : (uri.path.length() == 0 ? String.valueOf(newString) + uri.path : String.valueOf(newString) + URIUtil.createRelPath(relativeTo.path, (IPath)targetPath, newContextRoot));
            } else {
                try {
                    newString = String.valueOf(newString) + URIUtil.createAbsPath(project, (IPath)targetPath, newContextRoot);
                }
                catch (RuntimeException runtimeException) {
                    newString = String.valueOf(newString) + targetPath;
                }
            }
        }
        if (uri.query != null) {
            newString = String.valueOf(newString) + "?" + uri.query;
        }
        if (uri.fragment != null) {
            newString = String.valueOf(newString) + "#" + uri.fragment;
        }
        return newString;
    }

    @Deprecated
    public static String rename(Set<ProviderArguments> args, IProject project, String relativeToURI, String originalURI, String targetURI) {
        return URIUtil.rename(args, project, relativeToURI, originalURI, targetURI, null);
    }

    private static String createRelPath(String relativeToPath, IPath targetPath, String newContextRoot) {
        IPath renamed = null;
        Path anchorPoint = new Path(relativeToPath);
        IContainer sourceDocRoot = WebUtil.getDocumentRootContainer((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(anchorPoint.segment(0)));
        IContainer targetDocRoot = WebUtil.getDocumentRootContainer((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(targetPath.segment(0)));
        if (sourceDocRoot != null) {
            anchorPoint = anchorPoint.uptoSegment(1).append(anchorPoint.removeFirstSegments(anchorPoint.matchingFirstSegments(sourceDocRoot.getFullPath())));
        } else {
            Logger.logWarning((Logger.Category)Logger.Category.DEBUG, (Logger.Mode)Logger.Mode.USER, (String)("Warning: Could not retrieve document root container for project: " + anchorPoint.segment(0)));
        }
        if (targetDocRoot != null) {
            targetPath = targetPath.uptoSegment(1).append(targetPath.removeFirstSegments(targetPath.matchingFirstSegments(targetDocRoot.getFullPath())));
        } else {
            Logger.logWarning((Logger.Category)Logger.Category.DEBUG, (Logger.Mode)Logger.Mode.USER, (String)("Warning: Could not retrieve document root container for project: " + targetPath.segment(0)));
        }
        String newPath = "";
        int matchingSegments = anchorPoint.matchingFirstSegments(targetPath);
        if (matchingSegments == anchorPoint.segmentCount()) {
            newPath = targetPath.lastSegment();
        } else if (anchorPoint.segment(0).equals(targetPath.segment(0))) {
            renamed = anchorPoint.removeFirstSegments(matchingSegments);
            IPath targetPathDiff = targetPath.removeFirstSegments(matchingSegments);
            int numberOfDoubleDots = renamed.segmentCount() - 1;
            int i = 0;
            while (i < numberOfDoubleDots) {
                newPath = String.valueOf(newPath) + "../";
                ++i;
            }
            newPath = String.valueOf(newPath) + targetPathDiff.toString();
        } else {
            int smatches = sourceDocRoot == null ? 0 : anchorPoint.matchingFirstSegments(sourceDocRoot.getFullPath());
            int tmatches = targetDocRoot == null ? 0 : targetPath.matchingFirstSegments(targetDocRoot.getFullPath());
            renamed = anchorPoint.removeFirstSegments(smatches);
            IPath targetPathDiff = targetPath.removeFirstSegments(tmatches);
            int numberOfDoubleDots = renamed.segmentCount();
            int i = 0;
            while (i < numberOfDoubleDots) {
                newPath = String.valueOf(newPath) + "../";
                ++i;
            }
            newPath = String.valueOf(newPath) + URIUtil.getContextRoot(ResourcesPlugin.getWorkspace().getRoot().getProject(targetPath.segment(0)), newContextRoot) + "/";
            newPath = String.valueOf(newPath) + targetPathDiff.toString();
        }
        return newPath;
    }

    private static String getContextRoot(IProject project, String newContextRootOverride) {
        if (newContextRootOverride != null) {
            return newContextRootOverride;
        }
        return ComponentUtilities.getServerContextRoot((IProject)project);
    }

    private static String createAbsPath(IProject project, IPath targetPath, String newContextRoot) {
        IPath docRootPath;
        IProject targetProject = project;
        String abPath = "";
        if (targetPath.isAbsolute() && targetPath.segmentCount() >= 2) {
            targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(targetPath.segment(0));
        }
        if ((docRootPath = WebUtil.getWorkspaceRelativeDocRootPath(WebUtil.findComponent((IResource)targetProject))) == null) {
            throw new RuntimeException("Could not find doc root");
        }
        int segments = targetPath.matchingFirstSegments(docRootPath);
        IPath docRootRelative = targetPath.removeFirstSegments(segments).makeAbsolute();
        String actualDocRoot = URIUtil.getContextRoot(targetProject, newContextRoot);
        if (actualDocRoot == null) {
            abPath = String.valueOf(abPath) + docRootRelative.toString();
            throw new RuntimeException("Could not find doc root");
        }
        Path withContext = new Path(actualDocRoot);
        withContext = withContext.append(docRootRelative).makeAbsolute();
        abPath = String.valueOf(abPath) + withContext.toString();
        return abPath;
    }

    public static String renameAndMakeRelative(String relativeToURI, IProject project, String originalURI, String targetURI) {
        return URIUtil.rename(EnumSet.of(ProviderArguments.LINKSTYLE_RELATIVE), project, relativeToURI, originalURI, targetURI);
    }

    public static String renameAndMakeAbsolute(String relativeToURI, IProject project, String originalURI, String targetURI) {
        return URIUtil.rename(EnumSet.of(ProviderArguments.LINKSTYLE_ABSOLUTE), project, relativeToURI, originalURI, targetURI);
    }

    public static String renameAndPreserveStyle(String relativeToURI, IProject project, String originalURI, String targetURI) {
        return URIUtil.rename(EnumSet.of(ProviderArguments.LINKSTYLE_PRESERVE), project, relativeToURI, originalURI, targetURI);
    }

    public static ParsedURI parse(String uri) {
        String massaged = uri;
        if (massaged == null) {
            massaged = "";
        }
        char[] chars = massaged.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '<' || chars[i] == '>') {
                return ERROR;
            }
            ++i;
        }
        Matcher matcher = PARSER.matcher(massaged);
        ParsedURI pUri = new ParsedURI();
        while (matcher.find()) {
            int groups = matcher.groupCount();
            if (groups <= 1) continue;
            pUri.scheme = matcher.group(2);
            pUri.authority = matcher.group(4);
            pUri.path = matcher.group(5);
            pUri.query = matcher.group(7);
            pUri.fragment = matcher.group(9);
        }
        return pUri;
    }

    public static String addURIComponents(String currentResult, IFile relativeTo, String originalURI) {
        String result = currentResult;
        ParsedURI uri = URIUtil.parse(originalURI);
        if (uri != null) {
            if (uri.scheme != null && uri.authority != null) {
                result = String.valueOf(uri.scheme) + uri.authority + result;
            } else if (uri.scheme != null) {
                result = String.valueOf(uri.scheme) + result;
            } else if (uri.authority != null) {
                result = String.valueOf(uri.authority) + result;
            }
            if (uri.query != null) {
                result = String.valueOf(result) + "?" + uri.query;
            }
            if (uri.fragment != null) {
                result = String.valueOf(result) + "#" + uri.fragment;
            }
        }
        return result;
    }

    public static class ParsedURI {
        public String scheme;
        public String authority;
        public String path;
        public String query;
        public String fragment;

        public String toString() {
            String newString = "";
            if (this.scheme != null) {
                newString = String.valueOf(newString) + this.scheme + "://";
            }
            if (this.authority != null) {
                newString = String.valueOf(newString) + this.authority;
            }
            if (this.path != null) {
                newString = String.valueOf(newString) + this.path;
            }
            if (this.query != null) {
                newString = String.valueOf(newString) + "?" + this.query;
            }
            if (this.fragment != null) {
                newString = String.valueOf(newString) + "#" + this.fragment;
            }
            return newString;
        }
    }
}

