/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.IProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AbstractWebProvider
implements IProvider {
    private static final Pattern commentPattern = Pattern.compile("<!--.*?-->");

    private static TextRange getDOMElementRange(IDOMElement element, boolean includeTags) {
        TextRange range;
        IStructuredDocument doc;
        IStructuredDocument iStructuredDocument = doc = element == null ? null : element.getStructuredDocument();
        if (includeTags) {
            int clines;
            int contextStartOffset = element == null ? 0 : element.getStartOffset();
            int contextLength = element == null ? 0 : element.getEndOffset() - contextStartOffset;
            try {
                clines = element == null ? 1 : doc.getNumberOfLines(0, contextStartOffset + contextLength);
            }
            catch (BadLocationException badLocationException) {
                clines = 1;
            }
            range = new TextRange(contextStartOffset, contextLength, clines);
        } else {
            int vlines;
            int valueStartOffset = element == null ? 0 : element.getStartEndOffset();
            int valueLength = element == null ? 0 : element.getEndStartOffset() - valueStartOffset;
            try {
                vlines = element == null ? 1 : doc.getNumberOfLines(0, valueStartOffset + valueLength);
            }
            catch (BadLocationException badLocationException) {
                vlines = 1;
            }
            range = new TextRange(valueStartOffset, valueLength, vlines);
        }
        return range;
    }

    private static TextRange getAttributeValueRange(IDOMAttr attributrOrElement) {
        int vlines;
        IStructuredDocument doc = attributrOrElement.getStructuredDocument();
        int valueStartOffset = attributrOrElement.getValueRegionStartOffset();
        int valueLength = attributrOrElement.getValueRegionText() == null ? 0 : attributrOrElement.getValueRegionText().length();
        try {
            vlines = doc.getNumberOfLines(0, valueStartOffset + valueLength);
        }
        catch (BadLocationException badLocationException) {
            vlines = 1;
        }
        return new TextRange(valueStartOffset, valueLength, vlines);
    }

    public static ILink createLink(CreateLinkParameter parameterObject) {
        TextRange linkRange;
        Assert.isNotNull((Object)parameterObject.factory, (String)"factory can not be null");
        Assert.isNotNull((Object)parameterObject.contextElement, (String)"contextNode can not be null");
        Assert.isNotNull((Object)parameterObject.linkTypeId, (String)"linkId can not be null");
        IStructuredDocument doc = parameterObject.contextElement.getStructuredDocument();
        TextRange contextRange = AbstractWebProvider.getDOMElementRange(parameterObject.contextElement, true);
        if (parameterObject.linkNode == null) {
            linkRange = TextRange.EMPTY;
        } else if (parameterObject.linkNode.getNodeType() == 2) {
            IDOMAttr attr = (IDOMAttr)parameterObject.linkNode;
            linkRange = AbstractWebProvider.getAttributeValueRange(attr);
        } else if (parameterObject.linkNode.getNodeType() == 1) {
            linkRange = AbstractWebProvider.getDOMElementRange((IDOMElement)parameterObject.linkNode, false);
        } else {
            Assert.isLegal((boolean)false, (String)("Illegal node type: " + parameterObject.linkNode));
            linkRange = TextRange.EMPTY;
        }
        try {
            String contextText = doc.get(contextRange.getOffset(), contextRange.getLength());
            String valueText = doc.get(linkRange.getOffset(), linkRange.getLength());
            if (parameterObject.linkNode != null && parameterObject.linkNode.getNodeType() == 2) {
                int index;
                IDOMAttr attr = (IDOMAttr)parameterObject.linkNode;
                if (linkRange.getLength() == 0 && attr.getValueRegionText() == null && attr.getValueSource() != null && (index = contextText.indexOf(valueText = attr.getValueSource())) != -1) {
                    int vlines;
                    int valueStartOffset = contextRange.getOffset() + index;
                    int valueLength = valueText.length();
                    try {
                        vlines = doc.getNumberOfLines(0, valueStartOffset);
                    }
                    catch (BadLocationException badLocationException) {
                        vlines = 1;
                    }
                    linkRange = new TextRange(valueStartOffset, valueLength, vlines);
                }
            }
            ILink link = parameterObject.factory.createLink(parameterObject.linkTypeId, parameterObject.name, contextText, contextRange, valueText, linkRange, parameterObject.endPoint);
            if (!parameterObject.contextElement.isChildEditable()) {
                parameterObject.factory.addParam(link, "editable", "0");
            }
            return link;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Deprecated
    public static ILink createLink(ReferenceElementFactory factory, IStructuredDocument str, IDOMElement domElement, IDOMAttr attr, String linkType, String name) {
        CreateLinkParameter param = new CreateLinkParameter(factory, domElement, (IDOMNode)attr, linkType, name);
        return AbstractWebProvider.createLink(param);
    }

    @Deprecated
    public static ILink createLink(ReferenceElementFactory factory, IDOMElement contextNode, IDOMAttr attribute, String linkId, String name) {
        Assert.isNotNull((Object)factory, (String)"factory can not be null");
        Assert.isNotNull((Object)contextNode, (String)"contextNode can not be null");
        Assert.isNotNull((Object)linkId, (String)"linkId can not be null");
        CreateLinkParameter param = new CreateLinkParameter(factory, contextNode, (IDOMNode)attribute, linkId, name);
        return AbstractWebProvider.createLink(param);
    }

    @Deprecated
    public static ILink createLink(ReferenceElementFactory factory, IDOMElement contextNode, IDOMElement linkChild, String linkId, String name) {
        Assert.isNotNull((Object)factory, (String)"factory can not be null");
        Assert.isNotNull((Object)contextNode, (String)"contextNode can not be null");
        Assert.isNotNull((Object)linkId, (String)"linkId can not be null");
        CreateLinkParameter param = new CreateLinkParameter(factory, contextNode, (IDOMNode)linkChild, linkId, name);
        return AbstractWebProvider.createLink(param);
    }

    public static String getTextContent(IDOMElement element) {
        if (element == null) {
            return null;
        }
        IStructuredDocument str = element.getStructuredDocument();
        int valueStartOffset = element.getStartEndOffset();
        int valueLength = element.getEndStartOffset() - valueStartOffset;
        try {
            return str.get(valueStartOffset, valueLength);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static String getTextContentForAttribute(IDOMAttr linkAttribute) {
        if (linkAttribute == null) {
            return null;
        }
        String valueText = linkAttribute.getValue();
        if (valueText == null) {
            IStructuredDocument str = linkAttribute.getStructuredDocument();
            int valueStartOffset = linkAttribute.getValueRegionStartOffset();
            int valueLength = linkAttribute.getValueRegionText() == null ? 0 : linkAttribute.getValueRegionText().length();
            try {
                valueText = str.get(valueStartOffset, valueLength);
                if (valueLength == 0 && linkAttribute.getValueRegionText() == null && linkAttribute.getValueSource() != null) {
                    valueText = linkAttribute.getValueSource();
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return valueText;
    }

    public static String trimQuotes(String string) {
        if (string == null) {
            return null;
        }
        String result = null;
        result = string.trim();
        if (AbstractWebProvider.hasQuotes(result)) {
            result = result.substring(1, result.length() - 1);
        }
        Matcher matcher = commentPattern.matcher(result);
        result = matcher.replaceAll("").trim();
        return result;
    }

    public static String getQuoteChar(String string) {
        Assert.isNotNull((Object)string, (String)"String cannot be null");
        String s = string.trim();
        char[] chars = s.toCharArray();
        if (chars.length >= 2 && (chars[0] == '\'' && chars[chars.length - 1] == '\'' || chars[0] == '\"' && chars[chars.length - 1] == '\"')) {
            return Character.toString(chars[0]);
        }
        return null;
    }

    public static boolean hasQuotes(String string) {
        Assert.isNotNull((Object)string, (String)"String cannot be null");
        String s = string.trim();
        char[] chars = s.toCharArray();
        return chars.length >= 2 && (chars[0] == '\'' && chars[chars.length - 1] == '\'' || chars[0] == '\"' && chars[chars.length - 1] == '\"');
    }

    public static IDOMElement getNode(NodeList childNodes, String string) {
        Assert.isNotNull((Object)childNodes, (String)"childNodes cannot be null");
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeName().equalsIgnoreCase(string)) {
                return (IDOMElement)childNodes.item(i);
            }
            ++i;
        }
        return null;
    }

    public static List<IDOMElement> getNodes(NodeList childNodes, String string) {
        Assert.isNotNull((Object)childNodes, (String)"childNodes cannot be null");
        ArrayList<IDOMElement> nodes = new ArrayList<IDOMElement>();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeName().equalsIgnoreCase(string)) {
                nodes.add((IDOMElement)childNodes.item(i));
            }
            ++i;
        }
        return nodes;
    }

    public static String getAttributeValueForTag(Node tagNode, String tagName, String attributeName) {
        Assert.isNotNull((Object)tagNode, (String)"tagNode cannot be null");
        String attributeValue = null;
        if (tagNode.getNodeName().equals(tagName)) {
            NamedNodeMap attributeNodes = tagNode.getAttributes();
            int length = attributeNodes.getLength();
            int i = 0;
            while (i < length) {
                Node attributeNode = attributeNodes.item(i);
                String attName = attributeNode.getNodeName();
                if (attName.equalsIgnoreCase(attributeName)) {
                    attributeValue = AbstractWebProvider.getTextContentForAttribute((IDOMAttr)attributeNode);
                    if (attributeValue == null) break;
                    attributeValue = attributeValue.trim();
                    break;
                }
                ++i;
            }
        }
        return attributeValue;
    }

    public static void addLinksForTagAndAttributes(IDOMElement domElement, String tagName, String[] attributeNames, List<ILink> links, ReferenceElementFactory factory, String linkType) {
        Assert.isNotNull((Object)domElement, (String)"domElement cannot be null");
        Assert.isNotNull((Object)tagName, (String)"tagName cannot be null");
        Assert.isNotNull((Object)attributeNames, (String)"attributeNames[] cannot be null");
        Assert.isNotNull(links, (String)"links cannot be null");
        Assert.isNotNull((Object)factory, (String)"factory cannot be null");
        Assert.isNotNull((Object)linkType, (String)"linkType cannot be null");
        String nodeName = domElement.getNodeName();
        if (tagName.equalsIgnoreCase(nodeName)) {
            NamedNodeMap attributeNodes = domElement.getAttributes();
            int length = attributeNodes.getLength();
            int i = 0;
            while (i < length) {
                Node item = attributeNodes.item(i);
                String attName = item.getNodeName();
                String[] stringArray = attributeNames;
                int n = attributeNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String attributeName = stringArray[n2];
                    if (attName.equalsIgnoreCase(attributeName)) {
                        IDOMAttr attr = (IDOMAttr)item;
                        CreateLinkParameter param = new CreateLinkParameter(factory, domElement, (IDOMNode)attr, linkType, null);
                        ILink link = AbstractWebProvider.createLink(param);
                        links.add(link);
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }

    public static boolean isDynamicLink(String linkString) {
        if (linkString == null) {
            return false;
        }
        return AbstractWebProvider.isDynamicJspExpressionScriptlet(linkString) || linkString.toLowerCase().startsWith("javascript:");
    }

    private static boolean isDynamicJspExpressionScriptlet(String linkString) {
        int elEnd;
        boolean jsp;
        if (linkString == null) {
            return false;
        }
        int jspDeclarations = linkString.indexOf("<%");
        boolean bl = jsp = jspDeclarations > -1;
        if (jsp) {
            return true;
        }
        int el = linkString.indexOf("${");
        return el > -1 && (elEnd = linkString.indexOf(125, el)) > -1;
    }

    public static TextRange createTrimmedRange(ILink link) {
        return AbstractWebProvider.createTrimmedRange(link, AbstractWebProvider.trimQuotes(link.getLinkText()));
    }

    public static TextRange createTrimmedRange(ILink link, String trimmed) {
        if (trimmed == null) {
            return new TextRange(0, link.getLinkLocation().getLength(), link.getLinkLocation().getLinenumber());
        }
        String original = link.getLinkText();
        int offset = original.indexOf(trimmed);
        int length = trimmed.length();
        TextRange range = new TextRange(offset, length, link.getLinkLocation().getLinenumber());
        return range;
    }
}

