/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.ui.internal.quickfix;

import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.ui.quickfix.ReferenceQuickFix;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.ui.internal.nls.Messages;
import com.ibm.etools.references.web.ui.internal.quickfix.ProjectFacetUtil;
import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webtools.webpage.wizard.NewWebPageWizard;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class WebPageQuickFix
extends ReferenceQuickFix {
    protected Map<String, Object> run(Set<IResolvedReference> referencesToFix, IProgressMonitor monitor) {
        String fileName = null;
        IProject project = null;
        IPath folder = null;
        IResolvedReference random = referencesToFix.iterator().next();
        String brokenLinkTxt = random.getModelInstanceIdReference();
        URIUtil.ParsedURI uri = URIUtil.parse((String)brokenLinkTxt);
        Path path = new Path(uri.path);
        fileName = path.hasTrailingSeparator() ? "" : path.lastSegment();
        project = random.getReference().getSource().getContainer().getResource().getProject();
        folder = path.uptoSegment(path.segmentCount() - 1);
        if (folder.segmentCount() == 0) {
            return null;
        }
        IDataModel dataModel = DataModelFactory.createDataModel((String)"com.ibm.etools.webtools.webpage.core.WebPageCreationDataModelProvider");
        dataModel.setProperty("IWebPageDataModelProperties.FILE_NAME", (Object)fileName);
        dataModel.setProperty("IWebPageCreationDataModelProperties.FOLDER", (Object)folder.toString());
        dataModel.setProperty("IWebPageCreationDataModelProperties.PROJECT", (Object)project);
        DataModelPropertyDescriptor[] templateDescs = dataModel.getValidPropertyDescriptors("IWebPageDataModelProperties.TEMPLATE");
        IFacetedProject fp = ProjectFacetUtil.getFacetedProject(project);
        boolean isPortlet = false;
        if (fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet("jsr.base")) || fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet("ibmportlet.base"))) {
            isPortlet = true;
        }
        int i = 0;
        while (i < templateDescs.length) {
            ITemplateDescriptor templateDescriptor = (ITemplateDescriptor)templateDescs[i].getPropertyValue();
            if (isPortlet) {
                if ("com.ibm.etools.portlet.jsp.BasicPortletJSPTemplate".equals(templateDescriptor.getID())) {
                    dataModel.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)templateDescriptor);
                    break;
                }
            } else if ("com.ibm.etools.webtools.webpage.BasicJSPTemplate".equals(templateDescriptor.getID())) {
                dataModel.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)templateDescriptor);
                break;
            }
            ++i;
        }
        NewWebPageWizard wizard = new NewWebPageWizard(dataModel);
        wizard.setOpenEditorAfterCreation(false);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            String newFileName = dataModel.getStringProperty("IWebPageDataModelProperties.FILE_NAME");
            String folderName = dataModel.getStringProperty("IWebPageCreationDataModelProperties.FOLDER");
            Path newPath = new Path(folderName);
            newPath = newPath.append(newFileName);
            IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)newPath);
            HashMap<String, Object> targetDescription = new HashMap<String, Object>();
            targetDescription.put("web.ref.abs.path.id", newFile.getFullPath().toPortableString());
            return targetDescription;
        }
        return null;
    }

    public String getDescription() {
        return Messages.quickfix_creates_a_new_page;
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return Messages.quickfix_create_new_page;
    }
}

