/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal.providers.generators;

import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.providers.resolver.WebLinkResolverProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ModuleRelativeReferenceUtil {
    public static Reference createModuleRelativeReference(ILink link, String referenceType, String transformResult) {
        Reference reference = null;
        String targetModule = StrutsSearchUtil.getModuleForLinkTarget(link, null);
        String noQuotes = AbstractWebProvider.trimQuotes((String)transformResult);
        if (!(noQuotes.startsWith("http") || noQuotes.startsWith("www") || noQuotes.startsWith("/"))) {
            reference = new Reference(link, referenceType);
            reference.setFragmentLocation(new TextRange(0, link.getLinkLocation().getLength(), link.getLinkLocation().getLinenumber()));
            reference.setBrokenStatus(BrokenStatus.BROKEN);
            return reference;
        }
        boolean moduleAttributeSet = link.getParameter("param.struts.module") != null;
        String moduleParsedFromPath = StrutsSearchUtil.parseModuleFromPath(link.getContainer().getResource().getProject(), noQuotes);
        if (moduleParsedFromPath != null && moduleParsedFromPath.equals(targetModule) && !moduleAttributeSet) {
            noQuotes = noQuotes.substring(targetModule.length());
        }
        URIUtil.ParsedURI uri = URIUtil.parse((String)noQuotes);
        IContainer container = WebUtil.getDocumentRootContainer((IResource)link.getContainer().getResource());
        IPath moduleRootDir = container.getFullPath().append(targetModule);
        IPath targetPath = moduleRootDir.append(uri.path);
        reference = WebLinkResolverProvider.createWebLinkReference((ILink)link, (String)referenceType, (URIUtil.ParsedURI)uri, (IPath)targetPath);
        return reference;
    }
}

