/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.javaee.providers.resolvers.WebXMLResolverProvider;
import com.ibm.etools.references.web.struts.internal.providers.generators.ConfigFileReferenceGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConfigFileToServletReferenceGenerator
implements IReferenceGeneratorProvider {
    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        return Status.OK_STATUS;
    }

    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        if (TextRange.EMPTY.equals((Object)link.getLinkLocation())) {
            return Collections.emptyList();
        }
        String type = AbstractWebProvider.trimQuotes((String)transformResult);
        Reference ref = null;
        if (referenceType.equals("javaee.servletmapping.ref")) {
            String param = link.getParameter("attributeParam");
            String linkType = link.getSpecializedType().getId();
            if (linkType.equals("struts.action.link") && ("forward".equals(param) || "include".equals(param)) || linkType.equals("struts.forward.link") || linkType.equals("struts.actioninput.link") || linkType.equals("struts.exceptionpath.link")) {
                boolean expansion = ConfigFileReferenceGenerator.shouldExpand(link, transformResult);
                if (!expansion) {
                    ref = WebXMLResolverProvider.createServletMappingReference((ILink)link, (String)type);
                } else {
                    ArrayList<Reference> refs = new ArrayList<Reference>();
                    ILink enclosingAction = ConfigFileReferenceGenerator.getEnclosingActionLink(link);
                    List<String> datas = ConfigFileReferenceGenerator.getExpanded(enclosingAction, type);
                    for (String expandedValue : datas) {
                        ref = WebXMLResolverProvider.createServletMappingReference((ILink)link, (String)expandedValue);
                        if (ref == null) continue;
                        ref.addParameter("bultin.param.brokenlinktext", expandedValue);
                        refs.add(ref);
                    }
                    return refs;
                }
            }
        }
        if (ref != null) {
            return Collections.singletonList(ref);
        }
        return Collections.emptyList();
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        return AbstractWebProvider.trimQuotes((String)params.transformResult);
    }
}

