/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.javaee.providers.resolvers.JDTReferenceResolver;
import com.ibm.etools.references.web.providers.generators.WebLinkFullWebAppRelativeGeneratorProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.references.web.struts.internal.nls.ErrorMessages;
import com.ibm.etools.references.web.struts.internal.providers.resolvers.StrutsConfigFileResolver;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ConfigFileReferenceGenerator
extends WebLinkFullWebAppRelativeGeneratorProvider
implements IReferenceGeneratorProvider {
    public static ILink getEnclosingActionLink(ILink innerLink) throws ReferenceException {
        if (innerLink.getSpecializedType().getId().equals("struts.action.link")) {
            return innerLink;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)"struts.action.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{innerLink.getContainer().getResource()});
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)req, null);
        Set links = req.getMatches();
        for (ILink link : links) {
            if (!link.getContextLocation().contains(innerLink.getContextLocation())) continue;
            return link;
        }
        return null;
    }

    static List<String> getExpanded(ILink link, String type) {
        ArrayList<String> expanded = new ArrayList<String>();
        String actionPath = null;
        actionPath = link.getSpecializedType().getId().equals("struts.action.link") ? link.getName() : link.getParameter("struts.paramScope");
        if (actionPath == null) {
            return expanded;
        }
        ActionMappingWildcardUtil util = new ActionMappingWildcardUtil(link.getContainer().getResource().getProject(), actionPath);
        Collection resolvedReferences = link.resolveIncomingReference("struts.action.ref", null);
        for (IResolvedReference resolvedReference : resolvedReferences) {
            String expandedTypeName;
            String referenceText = resolvedReference.getFragmentText();
            if (referenceText == null) continue;
            referenceText = StrutsSearchUtil.depatternActionString(link.getContainer().getResource().getProject(), referenceText, null);
            if (!referenceText.startsWith("/")) {
                referenceText = "/" + referenceText;
            }
            if (expanded.contains(expandedTypeName = util.getConcreteAttributeValue(type, referenceText))) continue;
            expanded.add(expandedTypeName);
        }
        return expanded;
    }

    static boolean shouldExpand(ILink link, String transformResult) {
        boolean expansion = false;
        IProject project = link.getContainer().getResource().getProject();
        if (ActionMappingWildcardUtil.attributeHasTokens((IProject)project, (String)transformResult)) {
            expansion = true;
        }
        return expansion;
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        ILink source;
        if ("javaee.javatype.nodeid".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        if ("web.reference.workspacePath".equals(params.reference.getReferenceType())) {
            ILink source2 = params.reference.getSource();
            if (source2 != null) {
                return this.getRenameForActionAttributeStatus(source2);
            }
        } else if ("struts.action.ref".equals(params.reference.getReferenceType())) {
            ILink source3 = params.reference.getSource();
            if (source3 != null) {
                return this.getRenameForActionAttributeStatus(source3);
            }
        } else if ("struts.formbean.ref".equals(params.reference.getReferenceType()) && (source = params.reference.getSource()) != null) {
            return this.getRenameForActionAttributeStatus(source);
        }
        return super.checkRenameReference(new RefactoringGeneratorParameters(params.newReferenceTargetContainer, params.reference, params.transformResult, params.renameParameters, params.renameArguments));
    }

    protected Reference createReference(ILink link, String rawLink, String referenceType) {
        Reference result = null;
        String linkPath = AbstractWebProvider.trimQuotes((String)rawLink);
        String module = StrutsSearchUtil.getModuleForLinkTarget(link, null);
        if (!linkPath.endsWith(".jsp")) {
            result = super.createReference(link, rawLink, referenceType);
            if (result != null) {
                result.addParameter("param.struts.module", module);
            }
        } else if (module != null) {
            boolean moduleAttributeSet;
            URIUtil.ParsedURI uri = URIUtil.parse((String)linkPath);
            String parsedPathModule = StrutsSearchUtil.parseModuleFromPath(link.getContainer().getResource().getProject(), uri.path);
            boolean bl = moduleAttributeSet = link.getParameter("param.struts.module") != null;
            if (!uri.path.startsWith("/")) {
                uri.path = "/" + uri.path;
            }
            if (parsedPathModule != null && !parsedPathModule.equals(module) || moduleAttributeSet) {
                uri.path = String.valueOf(module) + uri.path;
            }
            Path uriPath = new Path(uri.path);
            result = super.createReference(link, uriPath.toPortableString(), referenceType);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        block13: {
            block21: {
                block19: {
                    block20: {
                        block17: {
                            block18: {
                                block11: {
                                    block16: {
                                        block15: {
                                            block12: {
                                                block14: {
                                                    type = AbstractWebProvider.trimQuotes((String)transformResult);
                                                    ref = null;
                                                    if (!referenceType.equals("struts.action.ref")) break block11;
                                                    if (!link.getSpecializedType().getId().equals("struts.action.link")) break block12;
                                                    param = link.getParameter("attributeParam");
                                                    if (!"forward".equals(param) && !"include".equals(param)) break block13;
                                                    expansion = ConfigFileReferenceGenerator.shouldExpand(link, transformResult);
                                                    if (expansion) break block14;
                                                    ref = StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, type);
                                                    break block13;
                                                }
                                                refs = new ArrayList<Reference>();
                                                datas = ConfigFileReferenceGenerator.getExpanded(link, type);
                                                var11_28 = datas.iterator();
                                                if (true) ** GOTO lbl91
                                            }
                                            if (!link.getSpecializedType().getId().equals("struts.actionextends.link")) break block15;
                                            ref = StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, type);
                                            break block13;
                                        }
                                        if (!link.getSpecializedType().getId().equals("struts.forward.link") && !link.getSpecializedType().getId().equals("struts.actioninput.link")) break block13;
                                        expansion = ConfigFileReferenceGenerator.shouldExpand(link, transformResult);
                                        if (expansion) break block16;
                                        ref = StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, type);
                                        break block13;
                                    }
                                    refs = new ArrayList<Reference>();
                                    datas = ConfigFileReferenceGenerator.getExpanded(ConfigFileReferenceGenerator.getEnclosingActionLink(link), type);
                                    expandedValue = datas.iterator();
                                    if (true) ** GOTO lbl98
                                }
                                if ("struts.forward.ref".equals(referenceType)) {
                                    result = AbstractWebProvider.trimQuotes((String)transformResult);
                                    ref = StrutsConfigFileResolver.createStrutsForwardReference(link, referenceType, result);
                                    if (ref != null) {
                                        return Collections.singletonList(ref);
                                    }
                                    return Collections.emptyList();
                                }
                                if (!referenceType.equals("struts.formbean.ref")) break block17;
                                expansion = ConfigFileReferenceGenerator.shouldExpand(link, transformResult);
                                if (expansion) break block18;
                                ref = StrutsConfigFileResolver.createStrutsFormbeanReference(link, referenceType, type);
                                break block13;
                            }
                            enclosingAction = ConfigFileReferenceGenerator.getEnclosingActionLink(link);
                            if (enclosingAction == null) break block13;
                            refs = new ArrayList<Reference>();
                            datas = ConfigFileReferenceGenerator.getExpanded(enclosingAction, type);
                            var11_29 = datas.iterator();
                            if (true) ** GOTO lbl105
                        }
                        if (!referenceType.equals("javaee.javatype.nodeid")) break block19;
                        if (TextRange.EMPTY.equals((Object)link.getLinkLocation())) {
                            return Collections.emptyList();
                        }
                        param = link.getParameter("attributeParam");
                        if (!"type".equals(param) && !link.getSpecializedType().getId().equals("struts.formbean.link") && !link.getSpecializedType().getId().equals("struts.javatype.link") && !link.getSpecializedType().getId().equals("struts.exception.link") && !link.getSpecializedType().getId().equals("struts.form.property.link")) break block13;
                        expansion = ConfigFileReferenceGenerator.shouldExpand(link, transformResult);
                        if (expansion) break block20;
                        ref = JDTReferenceResolver.createReference((ILink)link, (String)type, null);
                        break block13;
                    }
                    refs = new ArrayList<Reference>();
                    datas = ConfigFileReferenceGenerator.getExpanded(link, type);
                    var11_30 = datas.iterator();
                    if (true) ** GOTO lbl112
                }
                if (!referenceType.equals("web.reference.workspacePath")) break block13;
                if (TextRange.EMPTY.equals((Object)link.getLinkLocation())) {
                    return Collections.emptyList();
                }
                if (link.getSpecializedType().getId().equals("struts.action.link") && "type".equals(param = link.getParameter("attributeParam"))) {
                    return Collections.emptyList();
                }
                expansion = ConfigFileReferenceGenerator.shouldExpand(link, transformResult);
                if (expansion) break block21;
                ref = this.createReference(link, transformResult, referenceType);
                break block13;
            }
            enclosingAction = ConfigFileReferenceGenerator.getEnclosingActionLink(link);
            if (enclosingAction == null) break block13;
            refs = new ArrayList<Reference>();
            datas = ConfigFileReferenceGenerator.getExpanded(enclosingAction, type);
            var11_31 = datas.iterator();
            if (true) ** GOTO lbl119
        }
        if (ref != null) {
            return Collections.singletonList(ref);
        }
        return Collections.emptyList();
        do {
            if ((ref = StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, expandedValue = var11_28.next())) == null) continue;
            ref.addParameter("bultin.param.brokenlinktext", expandedValue);
            refs.add(ref);
lbl91:
            // 3 sources

        } while (var11_28.hasNext());
        return refs;
        do {
            if ((ref = StrutsConfigFileResolver.createStrutsActionReference(link, referenceType, expandedValue = expandedValue.next())) == null) continue;
            ref.addParameter("bultin.param.brokenlinktext", expandedValue);
            refs.add(ref);
lbl98:
            // 3 sources

        } while (expandedValue.hasNext());
        return refs;
        do {
            if ((ref = StrutsConfigFileResolver.createStrutsFormbeanReference(link, referenceType, expandedValue = var11_29.next())) == null) continue;
            ref.addParameter("bultin.param.brokenlinktext", expandedValue);
            refs.add(ref);
lbl105:
            // 3 sources

        } while (var11_29.hasNext());
        return refs;
        do {
            if ((ref = JDTReferenceResolver.createReference((ILink)link, (String)(expandedValue = var11_30.next()), null)) == null) continue;
            ref.addParameter("bultin.param.brokenlinktext", expandedValue);
            refs.add(ref);
lbl112:
            // 3 sources

        } while (var11_30.hasNext());
        return refs;
        do {
            if ((ref = this.createReference(link, expandedValue = var11_31.next(), referenceType)) == null) continue;
            ref.addParameter("bultin.param.brokenlinktext", expandedValue);
            refs.add(ref);
lbl119:
            // 3 sources

        } while (var11_31.hasNext());
        return refs;
    }

    private String getActionPath(ILink source) {
        String linkType = source.getSpecializedType().getId();
        String actionPath = null;
        if (linkType.equals("struts.action.link")) {
            actionPath = source.getName();
        } else if (linkType.equals("struts.actioninput.link")) {
            actionPath = source.getName();
        } else if (linkType.equals("struts.forward.link")) {
            actionPath = source.getParameter("struts.paramScope");
        } else if (linkType.equals("struts.exceptionpath.link")) {
            actionPath = source.getParameter("struts.paramScope");
        } else if (linkType.equals("struts.actionformbean.link")) {
            actionPath = source.getName();
        }
        return actionPath;
    }

    private String getRenameForActionAttributeNewValue(RefactoringGeneratorParameters params) {
        String newString = null;
        if (params.renameParameters.containsKey("web.ref.abs.path.id")) {
            String noQuotes = AbstractWebProvider.trimQuotes((String)params.transformResult);
            Path targetPath = new Path((String)params.renameParameters.get("web.ref.abs.path.id"));
            IPath linkPath = this.getWebAppRootRelativePath((IPath)targetPath);
            if (linkPath != null) {
                linkPath = linkPath.makeAbsolute();
                newString = linkPath.toString();
                newString = URIUtil.addURIComponents((String)newString, (IFile)this.getTargetContainer(params), (String)noQuotes);
            }
        } else if (params.renameParameters.containsKey("actionName.id")) {
            newString = (String)params.renameParameters.get("actionName.id");
        } else if (params.renameParameters.containsKey("strutsformbean.id")) {
            newString = (String)params.renameParameters.get("strutsformbean.id");
        }
        return newString;
    }

    private String getRenameForActionAttributeOldValue(ILink source, boolean depattern) {
        String linkType = source.getSpecializedType().getId();
        String linkValue = null;
        if (linkType.equals("struts.action.link")) {
            linkValue = AbstractWebProvider.trimQuotes((String)source.getLinkText());
        } else if (linkType.equals("struts.actioninput.link")) {
            linkValue = AbstractWebProvider.trimQuotes((String)source.getLinkText());
        } else if (linkType.equals("struts.forward.link")) {
            linkValue = AbstractWebProvider.trimQuotes((String)source.getLinkText());
        } else if (linkType.equals("struts.exceptionpath.link")) {
            linkValue = AbstractWebProvider.trimQuotes((String)source.getLinkText());
        } else if (linkType.equals("struts.actionformbean.link")) {
            linkValue = AbstractWebProvider.trimQuotes((String)source.getLinkText());
        }
        if (depattern) {
            linkValue = StrutsSearchUtil.depatternActionString(source.getContainer().getResource().getProject(), linkValue, null);
        }
        return linkValue;
    }

    private IStatus getRenameForActionAttributeStatus(ILink source) {
        String actionPath = this.getActionPath(source);
        String attributeValue = this.getRenameForActionAttributeOldValue(source, false);
        if (!this.isRenameForActionAttributeValid(source)) {
            return new Status(1, "com.ibm.etools.references.web.struts", NLS.bind((String)ErrorMessages.refactoring_error_cannot_update_wildcard_actions, (Object[])new String[]{attributeValue, actionPath}));
        }
        return Status.OK_STATUS;
    }

    private String getRenameForActionAttributeValue(ILink source, String newValue) {
        String oldValue = this.getRenameForActionAttributeOldValue(source, true);
        return this.isRenameForActionAttributeValid(source) ? newValue : oldValue;
    }

    private boolean isRenameForActionAttributeValid(ILink source) {
        String actionPath = this.getActionPath(source);
        String attributeValue = this.getRenameForActionAttributeOldValue(source, true);
        if (actionPath == null || attributeValue == null) {
            return true;
        }
        ActionMappingWildcardUtil wcu = new ActionMappingWildcardUtil(source.getContainer().getResource().getProject(), actionPath);
        return !wcu.actionHasWildcards() || !wcu.attributeHasTokens(attributeValue);
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        if ("web.reference.workspacePath".equals(params.reference.getReferenceType())) {
            ILink source = params.reference.getSource();
            if (source != null) {
                String newValue = this.getRenameForActionAttributeNewValue(params);
                newValue = this.getRenameForActionAttributeValue(source, newValue);
                return newValue;
            }
        } else {
            ILink source;
            if ("javaee.javatype.nodeid".equals(params.reference.getReferenceType())) {
                return (String)params.renameParameters.get("typeName.id");
            }
            if ("struts.action.ref".equals(params.reference.getReferenceType())) {
                ILink source2 = params.reference.getSource();
                if (source2 != null) {
                    String newValue = this.getRenameForActionAttributeNewValue(params);
                    newValue = this.getRenameForActionAttributeValue(source2, newValue);
                    return StrutsSearchUtil.patternActionString(params.reference.getSource().getContainer().getResource().getProject(), newValue, null);
                }
            } else if ("struts.formbean.ref".equals(params.reference.getReferenceType()) && (source = params.reference.getSource()) != null) {
                String newValue = this.getRenameForActionAttributeNewValue(params);
                newValue = this.getRenameForActionAttributeValue(source, newValue);
                return newValue;
            }
        }
        return super.renameReference(new RefactoringGeneratorParameters(params.newReferenceTargetContainer, params.reference, params.transformResult, params.renameParameters, params.renameArguments));
    }
}

