/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.struts.internal.StrutsXMLFileCache;
import com.ibm.etools.references.web.struts.servletProvider.IStrutsServletProvider;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class StrutsSearchUtil {
    private static Object SYNC = new Object();
    private static Collection<IStrutsServletProvider> strutsServletProviders;

    public static Set<ILink> applicableToModule(String module, Set<ILink> configFiles, IProgressMonitor monitor) throws ReferenceException {
        Assert.isNotNull((Object)module);
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)configFiles.size());
        HashSet<ILink> applicable = new HashSet<ILink>(configFiles.size());
        for (ILink configFileLink : configFiles) {
            String moduleName = StrutsSearchUtil.getModuleForConfigFile(configFileLink, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
            if (!module.equals(moduleName)) continue;
            applicable.add(configFileLink);
        }
        if (monitor != null) {
            monitor.done();
        }
        return applicable;
    }

    public static Collection<IPath> convertFilesToDocRootRelativePaths(Collection<IFile> links) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (IFile file : links) {
            IPath container = WebUtil.getDocumentRootContainer((IResource)file).getFullPath();
            if (container == null) continue;
            IPath scPath = file.getFullPath();
            int matches = scPath.matchingFirstSegments(container);
            scPath = scPath.removeFirstSegments(matches).makeAbsolute();
            paths.add(scPath);
        }
        return paths;
    }

    public static Collection<IFile> convertLinksToFiles(Collection<ILink> links) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (ILink link : links) {
            files.add((IFile)link.getContainer().getResource());
        }
        return files;
    }

    public static Collection<String> convertPathsToStrings(Collection<IPath> links) {
        ArrayList<String> paths = new ArrayList<String>();
        for (IPath path : links) {
            paths.add(path.toString());
        }
        return paths;
    }

    public static String depatternActionString(IProject project, String actionString, IProgressMonitor monitor) throws ReferenceException {
        String parsedActionPath;
        Collection<String> urlPatterns = StrutsSearchUtil.getStrutsServletMappings(project, SearchEngine.createSearchScope((IResource[])new IResource[]{project}), monitor);
        String string = parsedActionPath = actionString != null ? URIUtil.parse((String)actionString).path : null;
        if (parsedActionPath != null && !parsedActionPath.startsWith("/")) {
            parsedActionPath = "/" + parsedActionPath;
        }
        String dePatterned = null;
        if (project == null || actionString == null || parsedActionPath == null || urlPatterns == null || urlPatterns.isEmpty()) {
            return dePatterned;
        }
        for (String urlPattern : urlPatterns) {
            String matchPattern = urlPattern;
            StringMatcher matcher = new StringMatcher(matchPattern);
            if (!matcher.match(parsedActionPath)) continue;
            if (urlPattern.startsWith("*.")) {
                int dotIndex = parsedActionPath.lastIndexOf(".");
                dePatterned = parsedActionPath.substring(0, dotIndex);
                break;
            }
            if (!urlPattern.startsWith("/") || !urlPattern.endsWith("/*")) continue;
            String prefix = urlPattern.substring(0, urlPattern.lastIndexOf("/*"));
            dePatterned = parsedActionPath.replaceFirst(prefix, "");
            break;
        }
        if (dePatterned == null) {
            return actionString;
        }
        if (!dePatterned.startsWith("/")) {
            dePatterned = "/" + dePatterned;
        }
        return dePatterned;
    }

    private static boolean equalOrBothNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null ? o1.equals(o2) : o2.equals(o1);
    }

    public static ILink getActionExtendsLinkForAction(ILink actionLink) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{actionLink.getContainer().getResource()});
        Set<ILink> links = StrutsSearchUtil.getLinksOfType("struts.actionextends.link", scope, null);
        links = StrutsSearchUtil.rangeFilter(links, actionLink.getContextLocation());
        if ((links = StrutsSearchUtil.paramFilter(links, "struts.link.subtype", "extends")).isEmpty()) {
            return null;
        }
        return links.iterator().next();
    }

    public static ILink getActionJavaTarget(ILink managedbean, String concreteType) {
        Collection rrs = managedbean.resolveReference("javaee.javatype.nodeid", null);
        for (IResolvedReference resolvedReference : rrs) {
            ILink target = resolvedReference.getTarget();
            if (target == null) continue;
            String targetType = target.getName();
            if (concreteType == null || !concreteType.equals(targetType)) continue;
            return target;
        }
        return null;
    }

    public static Set<IResolvedReference> getActionMappingIncomingReferences(IProject project, String actionPath, String module, IProgressMonitor monitor) throws ReferenceException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        HashSet<IResolvedReference> result = new HashSet<IResolvedReference>();
        ILink actionLink = StrutsSearchUtil.getActionMappingLink(project, actionPath, module, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        if (actionLink != null) {
            Collection referencesToAction = actionLink.resolveIncomingReference("struts.action.ref", (IProgressMonitor)new NullProgressMonitor());
            mon.setWorkRemaining(referencesToAction.size());
            for (IResolvedReference r : referencesToAction) {
                result.add(r);
                mon.worked(1);
            }
        }
        if (monitor != null) {
            monitor.done();
        }
        return result;
    }

    public static ILink getActionMappingLink(IProject project, String actionPath, String module, IProgressMonitor monitor) throws ReferenceException {
        Set matches;
        if (actionPath == null) {
            return null;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        SearchPattern typePattern = SearchPattern.createPattern((String)"struts.action.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern namePattern = SearchPattern.createPattern((String)actionPath, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern pattern = SearchPattern.createAndPattern((SearchPattern)namePattern, (SearchPattern)typePattern);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        SearchScope scope = StrutsSearchUtil.getModuleScope(project, module, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        if (monitor != null) {
            monitor.done();
        }
        if (!(matches = requestor.getMatches()).isEmpty()) {
            return (ILink)matches.iterator().next();
        }
        if (StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)project)) {
            Set<ILink> actionLinks = StrutsSearchUtil.getAllActionsForModule(project, module, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
            for (ILink actionLink : actionLinks) {
                ActionMappingWildcardUtil wcUtil = new ActionMappingWildcardUtil(actionLink.getContainer().getResource().getProject(), actionLink.getName());
                if (!wcUtil.actionPathMatchesPattern(actionPath)) continue;
                return actionLink;
            }
        }
        return null;
    }

    public static ILink getActionTargetForActionExtendsLink(ILink actionLink) {
        Collection rrs = actionLink.resolveReference("struts.action.ref", null);
        for (IResolvedReference resolvedReference : rrs) {
            if (resolvedReference.getBrokenStatus() != BrokenStatus.NOTBROKEN) continue;
            return resolvedReference.getTarget();
        }
        return null;
    }

    public static Set<ILink> getAllActionMappings(SearchScope scope, IProgressMonitor monitor) throws ReferenceException {
        SearchPattern typePattern = SearchPattern.createPattern((String)"struts.action.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(typePattern, scope, (SearchRequestor)requestor, monitor);
        Set matches = requestor.getMatches();
        return matches;
    }

    public static Set<ILink> getAllActionMappingsInStrutsConfigFile(IResource strutsConfigFile, IProgressMonitor monitor) throws ReferenceException {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{strutsConfigFile});
        return StrutsSearchUtil.getAllActionMappings(scope, monitor);
    }

    public static Set<ILink> getAllActionsForModule(IProject project, String moduleName, IProgressMonitor monitor) throws ReferenceException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SearchScope scope = StrutsSearchUtil.getModuleScope(project, moduleName, (IProgressMonitor)mon.newChild(1));
        Set<ILink> links = StrutsSearchUtil.getAllActionMappings(scope, (IProgressMonitor)mon.newChild(1));
        if (monitor != null) {
            monitor.done();
        }
        return links;
    }

    public static Set<ILink> getAllExceptions(SearchScope scope, IProgressMonitor monitor) {
        Set<ILink> exceptions = StrutsSearchUtil.getLinksOfType("struts.exception.link", scope, monitor);
        exceptions = StrutsSearchUtil.paramFilter(exceptions, "struts.link.subtype", null);
        return exceptions;
    }

    public static Set<ILink> getAllFormBeans(SearchScope scope, IProgressMonitor monitor) throws ReferenceException {
        SearchPattern typePattern = SearchPattern.createPattern((String)"struts.formbean.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(typePattern, scope, (SearchRequestor)requestor, monitor);
        Set matches = requestor.getMatches();
        return matches;
    }

    public static Set<ILink> getAllForwards(SearchScope scope, IProgressMonitor monitor) {
        return StrutsSearchUtil.getLinksOfType("struts.forward.link", scope, monitor);
    }

    public static Collection<IStrutsServletProvider> getEnabledProviders(final IProject project) {
        ArrayList<IStrutsServletProvider> enabled = new ArrayList<IStrutsServletProvider>();
        if (!project.isAccessible()) {
            return enabled;
        }
        Collection<IStrutsServletProvider> providers = StrutsSearchUtil.getServletExtensionContributors();
        for (final IStrutsServletProvider provider : providers) {
            IStrutsServletProvider enabledProvider = (IStrutsServletProvider)InternalAPI.run((Object)provider, (InternalAPI.InternalRunnableWithResult)new InternalAPI.InternalRunnableWithResult<IStrutsServletProvider>(){

                public IStrutsServletProvider run() throws Exception {
                    if (provider.isValid(project)) {
                        return provider;
                    }
                    return null;
                }
            });
            if (enabledProvider == null) continue;
            enabled.add(enabledProvider);
        }
        return enabled;
    }

    public static ILink getExceptionExtendsLinkForException(ILink exceptionLink) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{exceptionLink.getContainer().getResource()});
        Set<ILink> links = StrutsSearchUtil.getLinksOfType("struts.exception.link", scope, null);
        links = StrutsSearchUtil.rangeFilter(links, exceptionLink.getContextLocation());
        if ((links = StrutsSearchUtil.paramFilter(links, "struts.link.subtype", "extends")).isEmpty()) {
            return null;
        }
        return links.iterator().next();
    }

    public static ILink getExceptionLink(IProject project, String typeClass, String module, IProgressMonitor monitor) throws ReferenceException {
        Set matches;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SearchPattern typePattern = SearchPattern.createPattern((String)"struts.exception.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern namePattern = SearchPattern.createPattern((String)typeClass, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern pattern = SearchPattern.createAndPattern((SearchPattern)namePattern, (SearchPattern)typePattern);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        SearchScope scope = StrutsSearchUtil.getModuleScope(project, module, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        if (monitor != null) {
            monitor.done();
        }
        if (!(matches = requestor.getMatches()).isEmpty()) {
            return (ILink)matches.iterator().next();
        }
        return null;
    }

    public static ILink getExceptionPathLinkForException(ILink source) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{source.getContainer().getResource()});
        Set<ILink> links = StrutsSearchUtil.getLinksOfType("struts.exceptionpath.link", scope, null);
        if ((links = StrutsSearchUtil.rangeFilter(links, source.getContextLocation())).isEmpty()) {
            return null;
        }
        return links.iterator().next();
    }

    public static ILink getFileTarget(ILink link, String concreteTargetPath) {
        if (link == null) {
            return null;
        }
        Collection rrs = link.resolveReference("web.reference.workspacePath", null);
        if (!rrs.isEmpty()) {
            if (concreteTargetPath != null) {
                for (IResolvedReference rr : rrs) {
                    ILink target;
                    String linkPath;
                    if (rr.getBrokenStatus() == BrokenStatus.BROKEN || rr.getBrokenStatus() == BrokenStatus.IGNORED || (linkPath = (target = rr.getTarget()).getPath().toString()) == null) continue;
                    if (linkPath.endsWith(concreteTargetPath)) {
                        return target;
                    }
                    String facesExpandedValue = ReferenceManager.getReferenceManager().expandLinkText(link.getSpecializedType(), concreteTargetPath, link.getContainer().getResource(), Collections.emptySet());
                    if (!linkPath.endsWith(facesExpandedValue)) continue;
                    return target;
                }
            } else {
                return ((IResolvedReference)rrs.iterator().next()).getTarget();
            }
        }
        return null;
    }

    public static ILink getFormBeanExtendsLinkForFormBean(ILink formBeanLink) {
        if (formBeanLink == null) {
            return null;
        }
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{formBeanLink.getContainer().getResource()});
        Set<ILink> links = StrutsSearchUtil.getLinksOfType("struts.actionformbean.link", scope, null);
        links = StrutsSearchUtil.rangeFilter(links, formBeanLink.getContextLocation());
        if ((links = StrutsSearchUtil.paramFilter(links, "struts.link.subtype", "extends")).isEmpty()) {
            return null;
        }
        return links.iterator().next();
    }

    public static ILink getFormBeanLink(IProject project, String name, String module, IProgressMonitor monitor) throws ReferenceException {
        Set matches;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SearchPattern typePattern = SearchPattern.createPattern((String)"struts.formbean.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern namePattern = SearchPattern.createPattern((String)name, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern pattern = SearchPattern.createAndPattern((SearchPattern)namePattern, (SearchPattern)typePattern);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        SearchScope scope = StrutsSearchUtil.getModuleScope(project, module, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        if (monitor != null) {
            monitor.done();
        }
        if (!(matches = requestor.getMatches()).isEmpty()) {
            return (ILink)matches.iterator().next();
        }
        return null;
    }

    public static ILink getFormBeanLinkForAction(ILink actionLink) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{actionLink.getContainer().getResource()});
        Set<ILink> links = StrutsSearchUtil.getLinksOfType("struts.actionformbean.link", scope, null);
        if ((links = StrutsSearchUtil.rangeFilter(links, actionLink.getContextLocation())).isEmpty()) {
            return null;
        }
        return links.iterator().next();
    }

    public static Set<ILink> getFormBeanProperties(ILink formBeanLink) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{formBeanLink.getContainer().getResource()});
        Set<ILink> links = StrutsSearchUtil.getLinksOfType("struts.form.property.link", scope, null);
        links = StrutsSearchUtil.rangeFilter(links, formBeanLink.getContextLocation());
        return links;
    }

    public static ILink getFormBeanTargetForFormBeanLink(ILink formBeanLink) {
        Collection rrs = formBeanLink.resolveReference("struts.formbean.ref", null);
        for (IResolvedReference resolvedReference : rrs) {
            if (resolvedReference.getBrokenStatus() != BrokenStatus.NOTBROKEN) continue;
            return resolvedReference.getTarget();
        }
        return null;
    }

    public static ILink getForwardExtendsLinkForForward(ILink forwardLink) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{forwardLink.getContainer().getResource()});
        Set<ILink> links = StrutsSearchUtil.getLinksOfType("struts.forwardextends.link", scope, null);
        links = StrutsSearchUtil.rangeFilter(links, forwardLink.getContextLocation());
        if ((links = StrutsSearchUtil.paramFilter(links, "struts.link.subtype", "extends")).isEmpty()) {
            return null;
        }
        return links.iterator().next();
    }

    public static ILink getForwardLink(IProject project, String name, String module, IProgressMonitor monitor) throws ReferenceException {
        Set matches;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SearchPattern typePattern = SearchPattern.createPattern((String)"struts.forward.link", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern namePattern = SearchPattern.createPattern((String)name, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        SearchPattern pattern = SearchPattern.createAndPattern((SearchPattern)namePattern, (SearchPattern)typePattern);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        SearchScope scope = StrutsSearchUtil.getModuleScope(project, module, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        if (monitor != null) {
            monitor.done();
        }
        if (!(matches = requestor.getMatches()).isEmpty()) {
            return (ILink)matches.iterator().next();
        }
        return null;
    }

    public static ILink getForwardTarget(ILink handle) {
        Collection rrs = handle.resolveReference("struts.forward.ref", null);
        for (IResolvedReference resolvedReference : rrs) {
            if (resolvedReference.getBrokenStatus() != BrokenStatus.NOTBROKEN) continue;
            return resolvedReference.getTarget();
        }
        return null;
    }

    public static ILink getForwardTargetForForwardExtendsLink(ILink forwardLink) {
        Collection rrs = forwardLink.resolveReference("struts.forward.ref", null);
        for (IResolvedReference resolvedReference : rrs) {
            if (resolvedReference.getBrokenStatus() != BrokenStatus.NOTBROKEN) continue;
            return resolvedReference.getTarget();
        }
        return null;
    }

    public static Set<ILink> getGlobalExceptions(IProject project, String module, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SearchScope scope = StrutsSearchUtil.getModuleScope(project, module, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        Set<ILink> exceptions = StrutsSearchUtil.getAllExceptions(scope, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        exceptions = StrutsSearchUtil.paramFilter(exceptions, "struts.paramScope", "global");
        return exceptions;
    }

    public static Set<ILink> getGlobalForwards(IProject project, String module, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SearchScope scope = StrutsSearchUtil.getModuleScope(project, module, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        Set<ILink> forwards = StrutsSearchUtil.getAllForwards(scope, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        forwards = StrutsSearchUtil.paramFilter(forwards, "struts.paramScope", "global");
        return forwards;
    }

    private static QualifiedName getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null) {
            return null;
        }
        return new QualifiedName(element.getNamespaceIdentifier(), id);
    }

    public static ILink getInputForActionMapping(ILink actionMappingHandle, IProgressMonitor monitor) {
        if (actionMappingHandle == null) {
            return null;
        }
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{actionMappingHandle.getContainer().getResource()});
        Set<ILink> links = StrutsSearchUtil.getLinksOfType("struts.actioninput.link", scope, monitor);
        if ((links = StrutsSearchUtil.rangeFilter(links, actionMappingHandle.getContextLocation())).isEmpty()) {
            return null;
        }
        return links.iterator().next();
    }

    public static ILink getJavaTarget(ILink managedbean) {
        Collection rrs = managedbean.resolveReference("javaee.javatype.nodeid", null);
        if (!rrs.isEmpty()) {
            return ((IResolvedReference)rrs.iterator().next()).getTarget();
        }
        return null;
    }

    private static Set<ILink> getLinksOfType(String type, SearchScope scope, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        SearchPattern typePattern = SearchPattern.createPattern((String)type, (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(typePattern, scope, (SearchRequestor)requestor, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon));
        if (monitor != null) {
            monitor.done();
        }
        Set matches = requestor.getMatches();
        return matches;
    }

    public static Set<ILink> getLocalExceptions(ILink actionMappingHandle, IProgressMonitor monitor) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{actionMappingHandle.getContainer().getResource()});
        Set<ILink> exceptions = StrutsSearchUtil.getAllExceptions(scope, monitor);
        exceptions = StrutsSearchUtil.rangeFilter(exceptions, actionMappingHandle.getContextLocation());
        return exceptions;
    }

    public static Set<ILink> getLocalForwards(ILink actionMappingHandle, IProgressMonitor monitor) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{actionMappingHandle.getContainer().getResource()});
        Set<ILink> forwards = StrutsSearchUtil.getAllForwards(scope, monitor);
        forwards = StrutsSearchUtil.rangeFilter(forwards, actionMappingHandle.getContextLocation());
        return forwards;
    }

    public static Set<ILink> getMessageResources(SearchScope scope, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        SearchPattern typePattern = SearchPattern.createPattern((String)"struts.javaproperties", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(typePattern, scope, (SearchRequestor)requestor, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon));
        if (monitor != null) {
            monitor.done();
        }
        Set matches = requestor.getMatches();
        return matches;
    }

    private static String getModuleForConfigFile(ILink link, IProgressMonitor monitor) throws ReferenceException {
        SpecializedType type = ReferenceManager.getReferenceManager().getLinkType("builtin.file.nodeid");
        SpecializedType scType = ReferenceManager.getReferenceManager().getLinkType("struts.config.nodeid");
        if (type.equals((Object)link.getSpecializedType())) {
            return StrutsSearchUtil.getModuleForConfigFile((LinkNode<? extends IResource>)link.getContainer(), monitor);
        }
        if (scType.equals((Object)link.getSpecializedType())) {
            return link.getParameter("param.struts.module");
        }
        return null;
    }

    private static String getModuleForConfigFile(LinkNode<? extends IResource> linkNode, IProgressMonitor monitor) throws ReferenceException {
        Collection links = linkNode.getLinks(ReferenceManager.getReferenceManager().getLinkType("struts.config.nodeid"), SpecializedType.Depth.ZERO, monitor);
        ILink scLink = null;
        if (!links.isEmpty()) {
            scLink = (ILink)links.iterator().next();
        }
        if (scLink != null) {
            return scLink.getParameter("param.struts.module");
        }
        return null;
    }

    public static String getModuleForIFile(IFile file, IProgressMonitor monitor) {
        IPath path;
        Set<ILink> configFiles = StrutsSearchUtil.getStrutsConfigFileLinks(file.getProject(), monitor);
        if (configFiles != null) {
            for (ILink cfgLink : configFiles) {
                IFile cfg = (IFile)cfgLink.getContainer().getResource();
                if (!cfg.equals((Object)file)) continue;
                return StrutsSearchUtil.getModuleForConfigFile(cfgLink, monitor);
            }
        }
        if ((path = WebUtil.getDocumentRootRelativePath((IFile)file)) != null && path.segmentCount() > 0) {
            String potentialModule = path.segment(0);
            if (potentialModule != null && path.isAbsolute()) {
                potentialModule = String.valueOf('/') + potentialModule;
            }
            try {
                Set<String> modules = StrutsSearchUtil.getModulesForProject(file.getProject(), monitor);
                if (modules.contains(potentialModule)) {
                    return potentialModule;
                }
            }
            catch (ReferenceException referenceException) {}
            return "";
        }
        return "";
    }

    public static String getModuleForILink(ILink link, IProgressMonitor monitor) {
        if (link == null) {
            return null;
        }
        IResource resource = link.getContainer().getResource();
        if (resource instanceof IFile) {
            return StrutsSearchUtil.getModuleForIFile((IFile)link.getContainer().getResource(), monitor);
        }
        return null;
    }

    public static String getModuleForLinkTarget(ILink link, IProgressMonitor monitor) {
        String targetModule = null;
        ILink sourceLink = link;
        if (sourceLink != null) {
            String tempModule;
            String sourceType = sourceLink.getSpecializedType().getId();
            targetModule = StrutsSearchUtil.getModuleForILink(link, monitor);
            if (targetModule == null) {
                targetModule = "";
            }
            if ("struts.exception.link".equals(sourceType)) {
                sourceLink = StrutsSearchUtil.getExceptionPathLinkForException(sourceLink);
            }
            String targetPath = AbstractWebProvider.trimQuotes((String)sourceLink.getLinkText());
            IProject project = sourceLink.getContainer().getResource().getProject();
            boolean defaultModule = targetModule.equals("");
            if (sourceType.equals("struts.forward.link")) {
                String moduleInPath = sourceLink.getParameter("struts.param.contextrelative");
                boolean contextRelative = false;
                if (moduleInPath != null) {
                    contextRelative = moduleInPath.equals(Boolean.TRUE.toString());
                }
                if (StrutsProjectCoreUtil.isStruts1_1((IProject)project)) {
                    if (contextRelative || defaultModule) {
                        targetModule = StrutsSearchUtil.parseModuleFromPath(project, targetPath);
                    }
                } else if (StrutsProjectCoreUtil.isStruts1_2((IProject)project)) {
                    String tempModule2 = sourceLink.getParameter("param.struts.module");
                    if (tempModule2 == null) {
                        if (contextRelative || defaultModule) {
                            targetModule = StrutsSearchUtil.parseModuleFromPath(project, targetPath);
                        }
                    } else {
                        targetModule = tempModule2;
                    }
                } else if (StrutsProjectCoreUtil.isStruts1_3((IProject)project)) {
                    String tempModule3 = sourceLink.getParameter("param.struts.module");
                    if (tempModule3 == null) {
                        if (defaultModule) {
                            targetModule = StrutsSearchUtil.parseModuleFromPath(project, targetPath);
                        }
                    } else {
                        targetModule = tempModule3;
                    }
                }
            } else if (sourceType.equals("struts.jsp.htmlink.link") || sourceType.equals("struts.jsp.action.link") || sourceType.equals("struts.jsp.page.link")) {
                String tempModule4;
                targetModule = StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)project) ? ((tempModule4 = sourceLink.getParameter("param.struts.module")) == null ? StrutsSearchUtil.parseModuleFromPath(project, targetPath) : tempModule4) : StrutsSearchUtil.parseModuleFromPath(project, targetPath);
            } else if (!sourceType.equals("struts.jsp.form.link") && defaultModule && (tempModule = StrutsSearchUtil.parseModuleFromPath(project, targetPath)) != null) {
                targetModule = tempModule;
            }
        }
        return targetModule;
    }

    public static SearchScope getModuleScope(IProject project, String module, IProgressMonitor monitor) throws ReferenceException {
        Set<ILink> configFiles = StrutsSearchUtil.getStrutsConfigFilesInAModule(project, module, monitor);
        ArrayList<IResource> files = new ArrayList<IResource>();
        for (ILink link : configFiles) {
            files.add(link.getContainer().getResource());
        }
        return SearchEngine.createSearchScope(files);
    }

    public static Set<String> getModulesForProject(IProject project, IProgressMonitor monitor) throws ReferenceException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        HashSet<String> modules = new HashSet<String>();
        Set<ILink> strutsConfigs = StrutsSearchUtil.getStrutsConfigFileLinks(project, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
        mon.setWorkRemaining(strutsConfigs.size());
        for (ILink link : strutsConfigs) {
            String mod = StrutsSearchUtil.getModuleForConfigFile(link, StrutsSearchUtil.monitorFor(monitor, (IProgressMonitor)mon.newChild(1)));
            if (mod == null) continue;
            modules.add(mod);
        }
        if (monitor != null) {
            monitor.done();
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<IStrutsServletProvider> getServletExtensionContributors() {
        Object object = SYNC;
        synchronized (object) {
            if (strutsServletProviders == null) {
                IConfigurationElement[] elements;
                strutsServletProviders = new HashSet<IStrutsServletProvider>();
                IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.etools.references.web.struts.strutsServletProvider");
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    final IConfigurationElement cElement = iConfigurationElementArray[n2];
                    IStrutsServletProvider provider = (IStrutsServletProvider)InternalAPI.run(StrutsSearchUtil.class, (InternalAPI.InternalRunnableWithResult)new InternalAPI.InternalRunnableWithResult<IStrutsServletProvider>(){

                        protected String getFriendlyMsg(Object delegateCode) {
                            String id = "Plugin id: {0}, contributing plugin: {1}";
                            QualifiedName name = StrutsSearchUtil.getId(cElement);
                            if (name == null) {
                                try {
                                    id = NLS.bind((String)id, (Object)"none", (Object)cElement.getContributor().getName());
                                }
                                catch (InvalidRegistryObjectException e) {
                                    id = NLS.bind((String)id, (Object)"none", (Object)NLS.bind((String)"Unknown: {0}", (Object)e.getMessage()));
                                }
                            } else {
                                try {
                                    id = NLS.bind((String)id, (Object)name.toString(), (Object)cElement.getContributor().getName());
                                }
                                catch (InvalidRegistryObjectException e) {
                                    id = NLS.bind((String)id, (Object)name.toString(), (Object)NLS.bind((String)"Unknown: {0}", (Object)e.getMessage()));
                                }
                            }
                            return NLS.bind((String)"Error in {0} during provider instantation for extension point: {1}", (Object)this.getPluginId(delegateCode), (Object)id);
                        }

                        public IStrutsServletProvider run() throws Exception {
                            return (IStrutsServletProvider)cElement.createExecutableExtension("class");
                        }
                    });
                    if (provider != null) {
                        strutsServletProviders.add(provider);
                    }
                    ++n2;
                }
            }
            return strutsServletProviders;
        }
    }

    public static ILink getStrutsConfig(IFile file) {
        Collection<Object> links;
        SpecializedType type = ReferenceManager.getReferenceManager().getLinkType("struts.config.nodeid");
        LinkNode linkNode = ReferenceManager.getReferenceManager().getLinkNode(file);
        try {
            links = linkNode.getLinks(type, SpecializedType.Depth.ZERO, null);
        }
        catch (ReferenceException referenceException) {
            links = Collections.emptyList();
        }
        if (!links.isEmpty()) {
            return (ILink)links.iterator().next();
        }
        return null;
    }

    public static Set<ILink> getStrutsConfigFileLinks(IProject project, IProgressMonitor monitor) throws ReferenceException {
        SearchPattern typePattern = SearchPattern.createPattern((String)"struts.config.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        List<IFile> aproximateFiles = StrutsXMLFileCache.INSTANCE.getXMLFiles(project);
        SearchScope scope = SearchEngine.createSearchScope(aproximateFiles);
        new SearchEngine().search(typePattern, scope, (SearchRequestor)requestor, monitor);
        Set matches = requestor.getMatches();
        return matches;
    }

    public static Set<ILink> getStrutsConfigFilesInAModule(IProject project, String moduleName, IProgressMonitor monitor) throws ReferenceException {
        if (moduleName == null) {
            return Collections.emptySet();
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Set<ILink> links = StrutsSearchUtil.getStrutsConfigFileLinks(project, (IProgressMonitor)mon.newChild(1));
        Set<ILink> moduleLinks = StrutsSearchUtil.applicableToModule(moduleName, links, (IProgressMonitor)mon.newChild(1));
        if (monitor != null) {
            monitor.done();
        }
        return moduleLinks;
    }

    @Deprecated
    public static List<ILink> getStrutsConfigFilesInProject(IProject project) {
        try {
            ArrayList<ILink> configFiles = new ArrayList<ILink>();
            SearchPattern typePattern = SearchPattern.createPattern((String)"javaee.webxml.initparam", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            DefaultSearchRequestor requestor = new DefaultSearchRequestor();
            new SearchEngine().search(typePattern, SearchEngine.createSearchScope((IResource[])new IResource[]{project}), (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            Set matches = requestor.getMatches();
            for (ILink match : matches) {
                Collection references = match.resolveReference("web.reference.workspacePath", null);
                for (IResolvedReference ref : references) {
                    if (ref == null) continue;
                    configFiles.add(ref.getTarget());
                }
            }
            return configFiles;
        }
        catch (ReferenceException referenceException) {
            return null;
        }
    }

    public static Collection<IFile> getStrutsConfigIFiles(IProject project) {
        Set<ILink> scLinks = StrutsSearchUtil.getStrutsConfigFileLinks(project, null);
        return StrutsSearchUtil.convertLinksToFiles(scLinks);
    }

    public static Collection<IFile> getStrutsConfigIFiles(IProject project, String module) {
        Set<ILink> scLinks = StrutsSearchUtil.getStrutsConfigFilesInAModule(project, module, null);
        return StrutsSearchUtil.convertLinksToFiles(scLinks);
    }

    public static ILink getStrutsServlet(IProject project, final SearchScope scope, final IProgressMonitor monitor) {
        ILink link = null;
        Collection<IStrutsServletProvider> providers = StrutsSearchUtil.getEnabledProviders(project);
        for (final IStrutsServletProvider provider : providers) {
            link = (ILink)InternalAPI.run((Object)provider, (InternalAPI.InternalRunnableWithResult)new InternalAPI.InternalRunnableWithResult<ILink>(){

                public ILink run() throws Exception {
                    return provider.getStrutsServletLink(scope, monitor);
                }
            });
            if (link != null) break;
        }
        return link;
    }

    public static Collection<String> getStrutsServletMappings(IProject project, final SearchScope scope, final IProgressMonitor monitor) throws ReferenceException {
        ArrayList<String> mappings = new ArrayList<String>();
        Collection<IStrutsServletProvider> providers = StrutsSearchUtil.getEnabledProviders(project);
        for (final IStrutsServletProvider provider : providers) {
            Collection results = (Collection)InternalAPI.run((Object)provider, (InternalAPI.InternalRunnableWithResult)new InternalAPI.InternalRunnableWithResult<Collection<String>>(){

                public Collection<String> run() throws Exception {
                    return provider.getStrutsURLPattern(scope, monitor);
                }
            });
            if (results == null) continue;
            mappings.addAll(results);
        }
        return mappings;
    }

    public static String getStrutsServletName(IProject project, SearchScope scope, IProgressMonitor monitor) {
        ILink strutsServlet = StrutsSearchUtil.getStrutsServlet(project, scope, monitor);
        String result = "";
        if (strutsServlet != null) {
            result = strutsServlet.getName();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    private static IProgressMonitor monitorFor(IProgressMonitor rootMonitor, IProgressMonitor subMonitor) {
        if (rootMonitor == null || rootMonitor instanceof NullProgressMonitor) {
            return rootMonitor;
        }
        return subMonitor;
    }

    private static Set<ILink> paramFilter(Set<ILink> links, String attribute, String attributeValue) {
        Assert.isNotNull((Object)attribute);
        Iterator<ILink> iterator = links.iterator();
        while (iterator.hasNext()) {
            ILink link = iterator.next();
            if (StrutsSearchUtil.equalOrBothNull(attributeValue, link.getParameter(attribute))) continue;
            iterator.remove();
        }
        return links;
    }

    public static String parseModuleFromPath(IProject project, String targetPath) {
        String result = "";
        if (targetPath != null && project != null) {
            String pathToParse = targetPath;
            if (!pathToParse.startsWith("/")) {
                pathToParse = "/" + pathToParse;
            }
            Set<String> modules = StrutsSearchUtil.getModulesForProject(project, null);
            modules.remove("");
            for (String element : modules) {
                String module = element;
                if (!pathToParse.startsWith(module) || module.length() <= result.length() || pathToParse.charAt(module.length()) != '/') continue;
                result = module;
            }
            String prjName = "/" + project.getName();
            if (result.equals("") && result.startsWith(prjName)) {
                if (pathToParse.startsWith(prjName) && pathToParse.indexOf("/", 1) > 0) {
                    pathToParse = pathToParse.substring(prjName.length());
                }
                for (String element : modules) {
                    String module = element;
                    if (!pathToParse.startsWith(module) || module.length() <= result.length()) continue;
                    result = module;
                }
            }
        }
        return result;
    }

    public static String patternActionString(IProject project, String actionString, IProgressMonitor monitor) {
        String urlPattern;
        Collection<String> urlPatterns = StrutsSearchUtil.getStrutsServletMappings(project, SearchEngine.createSearchScope((IResource[])new IResource[]{project}), monitor);
        if (urlPatterns == null || urlPatterns.size() == 0) {
            return actionString;
        }
        String result = "";
        String tempActionString = actionString;
        if (!tempActionString.startsWith("/")) {
            tempActionString = "/" + tempActionString;
        }
        if ((urlPattern = urlPatterns.iterator().next()).startsWith("*.")) {
            result = String.valueOf(tempActionString) + "." + urlPattern.substring(2);
        } else if (urlPattern.startsWith("/") && urlPattern.endsWith("/*")) {
            String prefix = urlPattern.substring(0, urlPattern.length() - 2);
            result = String.valueOf(prefix) + tempActionString;
        } else {
            result = String.valueOf(tempActionString) + ".do";
        }
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }

    private static Set<ILink> rangeFilter(Set<ILink> links, TextRange container) {
        Iterator<ILink> iterator = links.iterator();
        while (iterator.hasNext()) {
            ILink link = iterator.next();
            if (container.contains(link.getContextLocation())) continue;
            iterator.remove();
        }
        return links;
    }
}

