/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.struts.internal;

import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.BrokenReferenceData;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.services.providers.IBrokenReferenceStrategyProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class StrutsBrokenReferenceStrategyProvider
implements IBrokenReferenceStrategyProvider {
    public Collection<BrokenReference> findBrokenReferences(ILink link, Set<IResolvedReference> resolvedReferences) {
        IResolvedReference brokenRef;
        Set<IResolvedReference> matches = resolvedReferences;
        HashSet<IResolvedReference> brokenSet = new HashSet<IResolvedReference>();
        HashSet<IResolvedReference> notBrokenSet = new HashSet<IResolvedReference>();
        for (IResolvedReference resolvedReference : matches) {
            if (resolvedReference.getBrokenStatus() == BrokenStatus.IGNORED) continue;
            if (resolvedReference.getBrokenStatus() == BrokenStatus.NOTBROKEN) {
                notBrokenSet.add(resolvedReference);
                continue;
            }
            brokenSet.add(resolvedReference);
        }
        Iterator it = notBrokenSet.iterator();
        IProject project = link.getContainer().getResource().getProject();
        String actionServletName = StrutsSearchUtil.getStrutsServletName(project, SearchEngine.createSearchScope((IResource[])new IResource[]{project}), null);
        while (it.hasNext()) {
            ILink servlet;
            IResolvedReference ref = (IResolvedReference)it.next();
            String refType = ref.getReferenceType();
            if (ref.getSource() == null) continue;
            String linkType = ref.getSource().getSpecializedType().toString();
            String param = link.getParameter("attributeParam");
            if ((!linkType.equals("struts.action.link") || !"forward".equals(param) && !"include".equals(param)) && !linkType.equals("struts.forward.link") && !linkType.equals("struts.actioninput.link") && !linkType.equals("struts.exceptionpath.link") || !refType.equals("javaee.servletmapping.ref") || (servlet = ref.getTarget()) == null || !actionServletName.equalsIgnoreCase(servlet.getName())) continue;
            it.remove();
        }
        if (!notBrokenSet.isEmpty()) {
            Iterator iterator = brokenSet.iterator();
            block2: while (iterator.hasNext()) {
                brokenRef = (IResolvedReference)iterator.next();
                TextRange range = brokenRef.getFragmentLocation();
                if (range == null) continue;
                for (IResolvedReference notBrokenRef : notBrokenSet) {
                    TextRange nBrknRange;
                    if (!this.hasSameTarget(brokenRef, notBrokenRef) || (nBrknRange = notBrokenRef.getFragmentLocation()) == null || !nBrknRange.intersets(range)) continue;
                    iterator.remove();
                    continue block2;
                }
            }
        }
        ArrayList<BrokenReference> brokenRefs = new ArrayList<BrokenReference>();
        brokenRef = null;
        Iterator itr = brokenSet.iterator();
        if (itr.hasNext()) {
            brokenRef = (IResolvedReference)itr.next();
            itr.remove();
        }
        while (brokenRef != null) {
            ArrayList<IResolvedReference> potentialTargets = new ArrayList<IResolvedReference>();
            potentialTargets.add(brokenRef);
            Iterator i2 = brokenSet.iterator();
            while (i2.hasNext()) {
                IResolvedReference brokenRef2 = (IResolvedReference)i2.next();
                boolean same = this.hasSameTarget(brokenRef, brokenRef2);
                if (!same) continue;
                i2.remove();
            }
            String text = brokenRef.getFragmentText();
            String customText = brokenRef.getReference().getParameter("bultin.param.brokenlinktext");
            if (customText != null) {
                text = customText;
            }
            if (brokenRef.getFragmentLocation() != null) {
                TextRange brokenRange;
                BrokenReferenceData data = new BrokenReferenceData();
                data.brokenReferenceRange = brokenRange = new TextRange(brokenRef.getFragmentLocation().getOffset() + brokenRef.getSource().getLinkLocation().getOffset(), brokenRef.getFragmentLocation().getLength(), brokenRef.getFragmentLocation().getLinenumber());
                data.description = text;
                data.resource = link.getContainer().getResource();
                data.source = link;
                data.potentialTargets = potentialTargets;
                data.brokenResolvedReferenceId = brokenRef.getId();
                data.brokenText = text;
                brokenRefs.add(new BrokenReference(data));
            }
            if ((itr = brokenSet.iterator()).hasNext()) {
                brokenRef = (IResolvedReference)itr.next();
                itr.remove();
                continue;
            }
            brokenRef = null;
        }
        return brokenRefs;
    }

    private boolean hasSameTarget(IResolvedReference ref1, IResolvedReference ref2) {
        if (!ActionMappingWildcardUtil.attributeHasTokens((IProject)ref1.getSource().getContainer().getResource().getProject(), (String)ref1.getSource().getLinkText())) {
            return true;
        }
        String ref1BrokenLinkText = ref1.getReference().getParameter("bultin.param.brokenlinktext");
        String ref2BrokenLinkText = ref2.getReference().getParameter("bultin.param.brokenlinktext");
        return ref1BrokenLinkText != null && ref1BrokenLinkText.equals(ref2BrokenLinkText);
    }
}

