/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.providers.resolvers;

import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.services.providers.CheckedReferenceRename;
import com.ibm.etools.references.services.providers.IReferenceResolverProvider;
import com.ibm.etools.references.services.providers.RefactoringResolverParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.javaee.taglib.WebEEUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class WebXMLResolverProvider
extends AbstractWebProvider
implements IReferenceResolverProvider {
    public String createLink(Reference reference, LinkNode<IFile> linkNode) {
        return null;
    }

    public String getModelInstanceIdReference(Reference reference) {
        return "web.jst.webxml";
    }

    public Map<String, Object> renameReference(RefactoringResolverParameters params) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if ("javaee.webxml.servlet.name.reference".equals(params.resolvedReference.getReferenceType())) {
            if (params.targetLink != null) {
                paramMap.put("javaee.webxml.servlet.name.id", params.targetLink.getName());
            }
        } else if ("javaee.servletmapping.ref".equals(params.resolvedReference.getReferenceType()) && params.targetLink != null) {
            paramMap.put("javaee.param.servleturlpattern.id", params.targetLink.getName());
        }
        return paramMap;
    }

    public IResolvedReference resolveReference(ReferenceElementFactory factory, Reference reference, IResolvedReference previousResult) throws ReferenceException {
        IResolvedReference result = null;
        if ("javaee.webxml.servlet.name.reference".equals(reference.getReferenceType())) {
            String servletName = reference.getParameter("javaee.webxml.servlet.name.id");
            SearchPattern typePattern = SearchPattern.createPattern((String)"javaee.webxml.servlet", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            SearchPattern namePattern = SearchPattern.createPattern((String)servletName, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            if (reference.getSource() != null && reference.getSource().getContainer() != null) {
                ILink resolved;
                SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{reference.getSource().getContainer().getResource()});
                DefaultSearchRequestor requestor = new DefaultSearchRequestor();
                new SearchEngine().search(namePattern.and(typePattern), scope, (SearchRequestor)requestor, null);
                Set matches = requestor.getMatches();
                if (matches.size() == 1 && (resolved = (ILink)matches.iterator().next()) != null) {
                    result = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, resolved, null, false);
                }
            }
            if (result == null) {
                result = factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "web.jst.webxml", false);
            }
        } else if ("javaee.servletmapping.ref".equals(reference.getReferenceType())) {
            String path = reference.getParameter("javaee.param.servleturlpattern.id");
            String stringProject = reference.getParameter("javaee.param.project.id");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(stringProject);
            if (project != null) {
                IPath webxmlpath = WebEEUtil.getWebXmlPath(project);
                if (path != null && webxmlpath != null) {
                    SearchScope scope = SearchEngine.createSearchScope((IPath[])new IPath[]{webxmlpath});
                    SearchPattern pattern = SearchPattern.createPattern((String)"javaee.webxml.smapping", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
                    DefaultSearchRequestor requestor = new DefaultSearchRequestor();
                    new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, null);
                    Set matches = requestor.getMatches();
                    for (ILink link : matches) {
                        ILink target;
                        Collection targets;
                        StringMatcher matcher;
                        String urlMapping = link.getName();
                        if (urlMapping == null) continue;
                        if (urlMapping.indexOf(42) == -1) {
                            ILink target2;
                            Collection targets2;
                            if (!path.equals(urlMapping) || (targets2 = link.resolveReference("javaee.webxml.servlet.name.reference", null)).size() < 1 || (target2 = ((IResolvedReference)targets2.iterator().next()).getTarget()) == null) continue;
                            result = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, target2, null, false);
                            break;
                        }
                        String matchPattern = urlMapping;
                        if (!matchPattern.startsWith("*")) {
                            matchPattern = "*" + matchPattern;
                        }
                        if (!matchPattern.endsWith("*")) {
                            matchPattern = String.valueOf(matchPattern) + "*";
                        }
                        if (!(matcher = new StringMatcher(matchPattern)).match(path.toString()) || (targets = link.resolveReference("javaee.webxml.servlet.name.reference", null)).size() < 1 || (target = ((IResolvedReference)targets.iterator().next()).getTarget()) == null) continue;
                        result = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, target, null, false);
                        break;
                    }
                }
            }
            if (result == null) {
                result = factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "web.jst.webxml", false);
            }
        }
        return result;
    }

    public static Reference createServletMappingReference(ILink link, URIUtil.ParsedURI uri, IPath absPath) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(absPath.segment(0));
        IContainer container = WebUtil.getDocumentRootContainer((IResource)project);
        if (container == null) {
            return null;
        }
        int matchingFirstSegs = absPath.matchingFirstSegments(container.getFullPath());
        if (matchingFirstSegs == 0) {
            return null;
        }
        absPath = absPath.removeFirstSegments(matchingFirstSegs).makeAbsolute();
        Reference reference = new Reference(link, "javaee.servletmapping.ref");
        reference.addParameter("javaee.param.servleturlpattern.id", absPath.toPortableString());
        reference.addParameter("javaee.param.project.id", project.getName());
        reference.setFragmentLocation(WebXMLResolverProvider.createTrimmedRange((ILink)link));
        if (!project.equals((Object)link.getContainer().getResource().getProject())) {
            reference.setCrossProject(true);
        }
        return reference;
    }

    public static Reference createServletMappingReference(ILink link, String servletReference) {
        Path absPath = new Path(servletReference);
        absPath = absPath.makeAbsolute();
        Reference reference = new Reference(link, "javaee.servletmapping.ref");
        reference.addParameter("javaee.param.servleturlpattern.id", absPath.toPortableString());
        reference.addParameter("javaee.param.project.id", link.getContainer().getResource().getProject().getName());
        reference.setFragmentLocation(WebXMLResolverProvider.createTrimmedRange((ILink)link));
        return reference;
    }

    public CheckedReferenceRename checkRenameReference(RefactoringResolverParameters params) {
        CheckedReferenceRename rename = new CheckedReferenceRename();
        rename.setRenameParameters(this.renameReference(params));
        rename.setRenameValidationStatus(Status.OK_STATUS);
        return rename;
    }
}

