/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.providers.resolvers;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.services.providers.CheckedReferenceRename;
import com.ibm.etools.references.services.providers.IReferenceResolverProvider2;
import com.ibm.etools.references.services.providers.RefactoringResolverParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.javaee.providers.resolvers.SearchUtil;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;

public class JDTReferenceResolver
implements IReferenceResolverProvider2 {
    private static final boolean ENABLED = true;

    public String createLink(Reference reference, LinkNode<IFile> linkNode) {
        return null;
    }

    public Map<String, Object> renameReference(RefactoringResolverParameters params) {
        return params.targetDescription;
    }

    public static Reference createReference(ILink link, String typeName, String methodName) {
        String signature;
        String realTypeName;
        String trimmedMethodName;
        String type;
        block6: {
            type = "jdt.reference";
            if (methodName == null || methodName.equals("")) {
                type = "javaee.javatype.nodeid";
            }
            String trimmedTypeName = AbstractWebProvider.trimQuotes((String)typeName);
            trimmedMethodName = AbstractWebProvider.trimQuotes((String)methodName);
            realTypeName = null;
            try {
                signature = Signature.createTypeSignature((String)typeName, (boolean)false);
                int kind = Signature.getTypeSignatureKind((String)signature);
                if (kind == 4) {
                    signature = Signature.getElementType((String)signature);
                    kind = Signature.getTypeSignatureKind((String)signature);
                }
                if (kind != 2) break block6;
                return null;
            }
            catch (Exception exception) {
                Reference ref = new Reference(link, type);
                ref.setBrokenStatus(BrokenStatus.BROKEN);
                ref.setFragmentLocation(AbstractWebProvider.createTrimmedRange((ILink)link, (String)trimmedTypeName));
                return ref;
            }
        }
        signature = Signature.getTypeErasure((String)signature);
        realTypeName = Signature.toString((String)signature);
        Reference newReference = new Reference(link, type);
        newReference.addParameter("typeName.id", realTypeName);
        newReference.addParameter("bultin.param.brokenlinktext", realTypeName);
        if (methodName != null) {
            newReference.addParameter("methodName.id", trimmedMethodName);
        }
        newReference.setCrossProject(true);
        newReference.setFragmentLocation(AbstractWebProvider.createTrimmedRange((ILink)link));
        return newReference;
    }

    public static Reference createPropertiesResourceReference(ILink link, String propertyFile) {
        Reference newReference = new Reference(link, "javaee.propertiesresource");
        newReference.addParameter("propertiesFile.id", propertyFile);
        newReference.setFragmentLocation(AbstractWebProvider.createTrimmedRange((ILink)link));
        return newReference;
    }

    public IResolvedReference resolveReference(ReferenceElementFactory referenceFactory, Reference reference, IResolvedReference previousResult) throws ReferenceException {
        return null;
    }

    public IResolvedReference resolveReference(ReferenceElementFactory factory, Reference reference, IResolvedReference previousResult, IProgressMonitor monitor) throws ReferenceException {
        if (ReferenceManager.getReferenceManager().isBeingForcedReset()) {
            throw new OperationCanceledException();
        }
        IgnoredCancelationMonitor noCancel = new IgnoredCancelationMonitor(monitor);
        InternalAPI.waitForReadiness();
        IResolvedReference ref = null;
        if ("jdt.reference".equals(reference.getReferenceType())) {
            String typeName = reference.getParameter("typeName.id");
            String methodName = reference.getParameter("methodName.id");
            if (typeName == null && previousResult != null && previousResult.getTarget() != null) {
                typeName = previousResult.getTarget().getSpecializedType().getId().equals("javaee.jdt.publicmethod") ? previousResult.getTarget().getParameter("typeName.id") : previousResult.getTarget().getLinkText();
            }
            typeName = AbstractWebProvider.trimQuotes((String)typeName);
            noCancel.beginTask("", 100000);
            SubProgressMonitor submon = new SubProgressMonitor((IProgressMonitor)noCancel, 100000, 4);
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)submon, (String)NLS.bind((String)"Lookup {0}", (Object)(String.valueOf(typeName) + "#" + methodName + "()")), (int)3);
            sub.subTask(NLS.bind((String)"Lookup {0}", (Object)(String.valueOf(typeName) + "#" + methodName + "()")));
            IProject project = reference.getSource().getContainer().getResource().getProject();
            ILink link = SearchUtil.addOrLocateMethodLink(project, typeName, methodName, (IProgressMonitor)sub);
            if (link == null) {
                BrokenStatus status = BrokenStatus.BROKEN;
                if (reference.getBrokenStatus() == BrokenStatus.IGNORED) {
                    status = BrokenStatus.IGNORED;
                }
                ref = factory.createResolvedReference(status, reference, null, this.getModelInstanceId(typeName, methodName));
            } else {
                ref = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, link, null);
            }
            submon.done();
        } else if ("javaee.javatype.nodeid".equals(reference.getReferenceType())) {
            String typeName = reference.getParameter("typeName.id");
            noCancel.beginTask("", 100000);
            SubProgressMonitor submon = new SubProgressMonitor((IProgressMonitor)noCancel, 100000, 4);
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)submon, (String)NLS.bind((String)"Lookup {0}", (Object)typeName), (int)3);
            IProject project = reference.getSource().getContainer().getResource().getProject();
            ILink link = null;
            link = SearchUtil.addOrLocateTypeLink(project, typeName, (IProgressMonitor)sub);
            if (link == null) {
                BrokenStatus status = BrokenStatus.BROKEN;
                if (reference.getBrokenStatus() == BrokenStatus.IGNORED) {
                    status = BrokenStatus.IGNORED;
                }
                ref = factory.createResolvedReference(status, reference, null, this.getModelInstanceId(typeName, null));
            } else {
                ref = factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, link, null);
            }
            submon.done();
        } else if ("javaee.propertiesresource".equals(reference.getReferenceType())) {
            String propertiesFile = reference.getParameter("propertiesFile.id");
            SearchPattern typePattern = SearchPattern.createPattern((String)"javaee.properties.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            SearchPattern namePattern = SearchPattern.createPattern((String)propertiesFile, (SearchType)SearchType.BY_LINKNAME, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{reference.getSource().getContainer().getResource().getProject()});
            DefaultSearchRequestor requestor = new DefaultSearchRequestor();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)noCancel);
            sub.beginTask("", 1);
            new SearchEngine().search(namePattern.and(typePattern), scope, (SearchRequestor)requestor, (IProgressMonitor)sub.newChild(1, 7));
            Set matches = requestor.getMatches();
            ref = matches.size() == 1 ? factory.createResolvedReference(BrokenStatus.NOTBROKEN, reference, (ILink)matches.iterator().next(), null) : factory.createResolvedReference(BrokenStatus.BROKEN, reference, null, "javaee.javaproperties");
        }
        return ref;
    }

    private String getModelInstanceId(String typeName, String methodName) {
        if (methodName == null) {
            return "jdt:" + typeName;
        }
        return "jdt:" + typeName + ":" + methodName;
    }

    public String getModelInstanceIdReference(Reference reference) {
        if (reference.getReferenceType().equals("javaee.propertiesresource")) {
            return "javaee.properties.nodeid";
        }
        String typeName = reference.getParameter("typeName.id");
        String methodName = reference.getParameter("methodName.id");
        typeName = typeName == null ? "javaee.javatype.nodeid" : AbstractWebProvider.trimQuotes((String)typeName);
        return this.getModelInstanceId(typeName, methodName);
    }

    public CheckedReferenceRename checkRenameReference(RefactoringResolverParameters params) {
        CheckedReferenceRename rename = new CheckedReferenceRename();
        rename.setRenameParameters(this.renameReference(params));
        rename.setRenameValidationStatus(Status.OK_STATUS);
        return rename;
    }

    private class IgnoredCancelationMonitor
    extends ProgressMonitorWrapper {
        protected IgnoredCancelationMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public boolean isCanceled() {
            return false;
        }
    }
}

