/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.providers.node;

import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.services.providers.ILinkNodeModelProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class JavaNodeProvider
implements ILinkNodeModelProvider {
    public SharedModel getSharedModel(LinkNode<IResource> linkNode) throws IOException, CoreException {
        List<String> ext = Arrays.asList(JavaCore.getJavaLikeExtensions());
        if (ext.contains(linkNode.getResource().getFullPath().getFileExtension())) {
            return new SharedModel("javaee.javatype.nodeid", linkNode.getResource(), linkNode){

                protected void doRelease() {
                }
            };
        }
        return null;
    }

    public String getModelInstanceId(LinkNode<IResource> linkNode) {
        IFile file = (IFile)linkNode.getResource();
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
        return JavaNodeProvider.getFullyQualifiedName(cu);
    }

    public static String getFullyQualifiedName(ICompilationUnit cu) {
        String name;
        IType type;
        if (cu != null && (type = cu.getType(name = JavaNodeProvider.getNameWithoutJavaLikeExtension(cu.getElementName()))) != null) {
            return type.getFullyQualifiedName();
        }
        return null;
    }

    public static String getNameWithoutJavaLikeExtension(String fileName) {
        int index = JavaNodeProvider.indexOfJavaLikeExtension(fileName);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    private static int indexOfJavaLikeExtension(String fileName) {
        int fileNameLength = fileName.length();
        char[][] javaLikeExtensions = JavaNodeProvider.stringArrayToCharArrays(JavaCore.getJavaLikeExtensions());
        int i = 0;
        int length = javaLikeExtensions.length;
        while (i < length) {
            block4: {
                char[] extension = javaLikeExtensions[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                int dotIndex = extensionStart - 1;
                if (dotIndex >= 0 && fileName.charAt(dotIndex) == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (fileName.charAt(extensionStart + j) == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return dotIndex;
                }
            }
            ++i;
        }
        return -1;
    }

    private static char[][] stringArrayToCharArrays(String[] strings) {
        char[][] charArray = new char[strings.length][];
        int i = 0;
        while (i < strings.length) {
            charArray[i] = strings[i].toCharArray();
            ++i;
        }
        return charArray;
    }
}

