/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.providers.jdt;

import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.web.javaee.internal.providers.jdt.JDTResolvedReference;
import com.ibm.etools.references.web.javaee.internal.providers.jdt.JDTUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;

public final class JDTLink
implements ILink {
    LinkNode<? extends IResource> container;
    public SpecializedType specializedType;
    TextRange contextLocation;
    TextRange location;
    String text;
    String contextText;
    boolean endpoint;
    String name;
    private final String handleId;
    String extPath;

    public int getId() {
        return -99;
    }

    public JDTLink(String handleId) {
        this.handleId = handleId;
    }

    public IJavaElement getJavaElement() {
        return JavaCore.create((String)this.handleId);
    }

    public IPath getPath() {
        if (this.extPath != null) {
            return new Path(this.extPath);
        }
        return this.getContainer().getResource().getFullPath();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof JDTLink) {
            return this.handleId.equals(((JDTLink)obj).handleId);
        }
        return false;
    }

    public final IReferenceElement.ElementType getElementType() {
        return IReferenceElement.ElementType.LINK;
    }

    public LinkNode<IResource> getContainer() {
        return this.container;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public TextRange getContextLocation() {
        return this.contextLocation;
    }

    public String getContextText() {
        return this.contextText;
    }

    public TextRange getLinkLocation() {
        return this.location;
    }

    public ILink getOriginal() {
        return this;
    }

    public String getLinkText() {
        return this.text;
    }

    public boolean isEndPoint() {
        return false;
    }

    public SpecializedType getSpecializedType() {
        return this.specializedType;
    }

    public Collection<IResolvedReference> resolveReference(String referenceType, IProgressMonitor monitor) {
        if (this.getSpecializedType().getId().equals("javaee.javatype.nodeid")) {
            return Collections.emptyList();
        }
        if (this.getContainer() == null) {
            IType type;
            IJavaElement element = JavaCore.create((String)this.handleId);
            if (element.getElementType() == 9 && !"void".equals(this.text) && (type = JDTUtils.searchSystemType(this.text)) != null) {
                JDTLink targetLink = JDTUtils.createTypeLink(type);
                JDTResolvedReference resolvedReference = new JDTResolvedReference(this, targetLink, "jdt.reference");
                return Collections.singleton(resolvedReference);
            }
        } else {
            IProject p = this.getContainer().getResource().getProject();
            if (!"void".equals(this.text)) {
                JDTLink link = JDTUtils.createJDTTypeLink(JavaCore.create((IProject)p), this.text, null);
                JDTResolvedReference resolvedReference = new JDTResolvedReference(this, link, "jdt.reference");
                return Collections.singleton(resolvedReference);
            }
        }
        return Collections.emptyList();
    }

    public Collection<IResolvedReference> resolveReference(String referenceType, SearchScope scope, IProgressMonitor progressMonitor) throws ReferenceException {
        return this.resolveReference(referenceType, progressMonitor);
    }

    public Collection<IResolvedReference> resolveIncomingReference(String referenceType, SearchScope scope, IProgressMonitor progressMonitor) throws ReferenceException {
        SearchPattern pattern = null;
        pattern = this.getSpecializedType().getId().equals("javaee.javatype.nodeid") ? SearchPattern.createPattern((String)"javaee.javatype.nodeid", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.REFERENCE, (int)0) : SearchPattern.createPattern((String)"jdt.reference", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.REFERENCE, (int)0);
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)req, progressMonitor);
        HashSet<IResolvedReference> references = new HashSet<IResolvedReference>();
        Set matches = req.getMatches();
        for (Reference ref : matches) {
            String handle;
            if (this.getSpecializedType().getId().equals("javaee.javatype.nodeid")) {
                handle = ref.getParameter("typeName.id");
                if (handle == null || !handle.equals(this.name)) continue;
                references.addAll(ref.resolve());
                continue;
            }
            handle = ref.getParameter("methodName.id");
            if (handle == null || !handle.equals(this.name)) continue;
            references.addAll(ref.resolve());
        }
        if (referenceType == null) {
            return references;
        }
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            IResolvedReference resolved = (IResolvedReference)iterator.next();
            if (referenceType.equals(resolved.getReferenceType())) continue;
            iterator.remove();
        }
        return references;
    }

    public Collection<IResolvedReference> resolveIncomingReference(String referenceType, IProgressMonitor monitor) throws ReferenceException {
        return this.resolveIncomingReference(referenceType, SearchEngine.createWorkspaceScope(), monitor);
    }

    public List<String> getReferenceTypes() {
        if (this.getSpecializedType().getId().equals("javaee.javatype.nodeid")) {
            return Collections.emptyList();
        }
        return Collections.singletonList("jdt.reference");
    }

    public boolean isValid() {
        return true;
    }

    public String toString() {
        String path = this.container == null ? this.extPath : this.container.getResource().getFullPath().toString();
        return String.valueOf(this.getElementType().name()) + " Type: [" + this.getSpecializedType().getId() + "] LinkText: [" + this.getLinkText() + "] " + " Name: [" + this.getName() + "] Path: [" + path + "]";
    }

    public String getName() {
        return this.name;
    }

    public String getParameter(String key) {
        if ("javaee.handle".equals(key)) {
            return this.handleId;
        }
        if ("typeName.id".equals(key)) {
            IJavaElement e = JavaCore.create((String)this.handleId);
            if (e.getElementType() == 7) {
                return ((IType)e).getFullyQualifiedName();
            }
            if (e.getElementType() == 9) {
                try {
                    return Signature.toString((String)((IMethod)e).getReturnType());
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        return null;
    }

    public Collection<BrokenReference> findBrokenReferences(IProgressMonitor monitor) throws ReferenceException {
        return Collections.emptyList();
    }

    public boolean isBroken(IProgressMonitor monitor) {
        return false;
    }

    public boolean isCrossProjectAddressable() {
        IJavaElement element = JavaCore.create((String)this.handleId);
        return element.getResource() == null;
    }

    public Collection<BrokenReference> findBrokenReferences(IProgressMonitor monitor, boolean forceCrossProjectReferences) throws ReferenceException {
        return Collections.emptyList();
    }
}

