/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.providers.generators;

import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.javaee.providers.resolvers.JDTReferenceResolver;
import com.ibm.etools.references.web.javaee.providers.resolvers.WebXMLResolverProvider;
import com.ibm.etools.references.web.providers.generators.WebLinkGeneratorProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JSPLinkGeneratorProvider
extends WebLinkGeneratorProvider {
    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        Reference reference = null;
        if ("javaee.javatype.nodeid".equals(referenceType)) {
            String noQuotes = AbstractWebProvider.trimQuotes((String)transformResult);
            reference = JDTReferenceResolver.createReference(link, noQuotes, null);
        } else if ("javaee.servletmapping.ref".equals(referenceType)) {
            String noQuotes = AbstractWebProvider.trimQuotes((String)transformResult);
            if (noQuotes == null || noQuotes.length() == 0) {
                return Collections.emptyList();
            }
            reference = this.createReference(link, transformResult, referenceType);
        }
        if (reference == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(reference);
    }

    protected Reference createReference(ILink link, String rawLink, String referenceType) {
        String noQuotes = AbstractWebProvider.trimQuotes((String)rawLink);
        if (AbstractWebProvider.isDynamicLink((String)noQuotes)) {
            return null;
        }
        URIUtil.ParsedURI uri = URIUtil.parse((String)noQuotes);
        if (uri.scheme != null && !uri.scheme.equals("file")) {
            return null;
        }
        IPath absPath = this.getAbsolutePathFromLink(uri, link);
        Reference reference = null;
        if (absPath == null) {
            reference = new Reference(link, referenceType);
            reference.setFragmentLocation(new TextRange(0, link.getLinkLocation().getLength(), link.getLinkLocation().getLinenumber()));
            reference.setBrokenStatus(BrokenStatus.BROKEN);
        } else {
            reference = WebXMLResolverProvider.createServletMappingReference(link, uri, absPath);
        }
        return reference;
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        if ("javaee.javatype.nodeid".equals(params.reference.getReferenceType())) {
            return (String)params.renameParameters.get("typeName.id");
        }
        if ("javaee.servletmapping.ref".equals(params.reference.getReferenceType())) {
            String noQuotes = AbstractWebProvider.trimQuotes((String)params.transformResult);
            return noQuotes;
        }
        return super.renameReference(params);
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        if ("javaee.javatype.nodeid".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        if ("javaee.servletmapping.ref".equals(params.reference.getReferenceType())) {
            return Status.OK_STATUS;
        }
        return super.checkRenameReference(params);
    }
}

