/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.javaee.internal.providers.detectors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class WebXmlLinkDetectorProvider
implements ILinkDetectorProvider {
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        links.add(factory.createLink("javaee.webxml.nodeid", null, null, TextRange.EMPTY, null, TextRange.EMPTY, true));
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            TreeWalker iter = ((DocumentTraversal)document).createTreeWalker((Node)document, 1, null, false);
            Node n = iter.nextNode();
            while (n != null) {
                ILink desc;
                CreateLinkParameter param;
                CreateLinkParameter param2;
                String name;
                IDOMElement servletName;
                NodeList childNodes;
                String nodeName = n.getNodeName();
                if (nodeName.equalsIgnoreCase("servlet")) {
                    childNodes = n.getChildNodes();
                    servletName = AbstractWebProvider.getNode((NodeList)childNodes, (String)"servlet-name");
                    name = AbstractWebProvider.getTextContent((IDOMElement)servletName);
                    if (name != null) {
                        name = name.trim();
                    }
                    ILink linkToAdd = null;
                    IDOMElement servletClass = AbstractWebProvider.getNode((NodeList)childNodes, (String)"servlet-class");
                    if (servletClass != null) {
                        param2 = new CreateLinkParameter(factory, (IDOMElement)n, (IDOMNode)servletClass, "javaee.webxml.servlet", name);
                        linkToAdd = AbstractWebProvider.createLink((CreateLinkParameter)param2);
                        factory.addParam(linkToAdd, "javaee.param.servlettype", "class");
                    }
                    if (linkToAdd == null) {
                        IDOMElement jspFile = AbstractWebProvider.getNode((NodeList)childNodes, (String)"jsp-file");
                        CreateLinkParameter param3 = new CreateLinkParameter(factory, (IDOMElement)n, (IDOMNode)jspFile, "javaee.webxml.servlet", name);
                        linkToAdd = AbstractWebProvider.createLink((CreateLinkParameter)param3);
                        factory.addParam(linkToAdd, "javaee.param.servlettype", "jsp");
                    }
                    if (linkToAdd == null) {
                        param2 = new CreateLinkParameter(factory, (IDOMElement)n, null, "javaee.webxml.servlet", name);
                        linkToAdd = AbstractWebProvider.createLink((CreateLinkParameter)param2);
                    }
                    links.add(linkToAdd);
                }
                if (nodeName.equalsIgnoreCase("init-param")) {
                    childNodes = n.getChildNodes();
                    IDOMElement paramName = AbstractWebProvider.getNode((NodeList)childNodes, (String)"param-name");
                    name = AbstractWebProvider.trimQuotes((String)AbstractWebProvider.getTextContent((IDOMElement)paramName));
                    IDOMElement paramValue = AbstractWebProvider.getNode((NodeList)childNodes, (String)"param-value");
                    CreateLinkParameter param4 = new CreateLinkParameter(factory, (IDOMElement)n, (IDOMNode)paramValue, "javaee.webxml.initparam", name);
                    ILink desc2 = AbstractWebProvider.createLink((CreateLinkParameter)param4);
                    links.add(desc2);
                } else if (nodeName.equalsIgnoreCase("servlet-mapping")) {
                    childNodes = n.getChildNodes();
                    servletName = AbstractWebProvider.getNode((NodeList)childNodes, (String)"servlet-name");
                    List urlPatterns = AbstractWebProvider.getNodes((NodeList)childNodes, (String)"url-pattern");
                    for (IDOMElement urlPattern : urlPatterns) {
                        param2 = new CreateLinkParameter(factory, (IDOMElement)n, (IDOMNode)servletName, "javaee.webxml.smapping", AbstractWebProvider.trimQuotes((String)AbstractWebProvider.getTextContent((IDOMElement)urlPattern)));
                        ILink desc3 = AbstractWebProvider.createLink((CreateLinkParameter)param2);
                        links.add(desc3);
                    }
                } else if (nodeName.equalsIgnoreCase("small-icon") || nodeName.equalsIgnoreCase("large-icon") || nodeName.equalsIgnoreCase("form-error-page") || nodeName.equalsIgnoreCase("form-login-page") || nodeName.equalsIgnoreCase("location")) {
                    param = new CreateLinkParameter(factory, (IDOMElement)n, (IDOMNode)((IDOMElement)n), "web.webapprelative.link", null);
                    desc = AbstractWebProvider.createLink((CreateLinkParameter)param);
                    links.add(desc);
                } else if (nodeName.equalsIgnoreCase("taglib-location")) {
                    param = new CreateLinkParameter(factory, (IDOMElement)n, (IDOMNode)((IDOMElement)n), "javaee.web.fullwebappwebxmlrelative.link", null);
                    desc = AbstractWebProvider.createLink((CreateLinkParameter)param);
                    links.add(desc);
                } else if (nodeName.equalsIgnoreCase("exception-type") || nodeName.equalsIgnoreCase("listener-class") || nodeName.equalsIgnoreCase("filter-class") || nodeName.equalsIgnoreCase("home") || nodeName.equalsIgnoreCase("remote") || nodeName.equalsIgnoreCase("resource-env-ref-type") || nodeName.equalsIgnoreCase("res-type")) {
                    param = new CreateLinkParameter(factory, (IDOMElement)n, (IDOMNode)((IDOMElement)n), "javaee.webxml.servlet", null);
                    desc = AbstractWebProvider.createLink((CreateLinkParameter)param);
                    factory.addParam(desc, "javaee.param.servlettype", "class");
                    links.add(desc);
                }
                n = iter.nextNode();
            }
        }
        return links;
    }
}

