/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.faces.internal.providers.generators;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.references.web.faces.FacesReferenceUtil;
import com.ibm.etools.references.web.faces.internal.BindingHelper;
import com.ibm.etools.references.web.providers.generators.WebLinkGeneratorProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;

public class FacesComponentGeneratorProvider
extends WebLinkGeneratorProvider {
    protected IPath getAbsolutePathFromLink(URIUtil.ParsedURI uri, ILink link) {
        IPath absPath = super.getAbsolutePathFromLink(uri, link);
        if (absPath == null && (uri.path.startsWith("/") || uri.path.startsWith("\\"))) {
            absPath = this.getWorkspacePathForWebAppRelativeLink(link, uri);
        }
        return absPath;
    }

    public List<Reference> generateReferences(ILink link, String referenceType, String transformResult) {
        if ("web.reference.workspacePath".equals(referenceType)) {
            String vbl = transformResult;
            vbl = BindingHelper.removeVbl(transformResult);
            if (vbl.equals(transformResult)) {
                Reference reference = this.createReference(link, transformResult, referenceType);
                if (reference == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(reference);
            }
            return Collections.emptyList();
        }
        if ("jsf.simple.vbl".equals(referenceType)) {
            return FacesReferenceUtil.createFacesActionReferences(link, referenceType, transformResult);
        }
        return Collections.emptyList();
    }

    public String renameReference(RefactoringGeneratorParameters params) {
        if (params.reference.getReferenceType().equals("jdt.reference")) {
            String methodName = (String)params.renameParameters.get("methodName.id");
            return methodName;
        }
        if ("web.reference.workspacePath".equals(params.reference.getReferenceType())) {
            IFile targetFile;
            String actualDocRoot;
            String newString = null;
            String noQuotes = AbstractWebProvider.trimQuotes((String)params.transformResult);
            Path targetPath = new Path((String)params.renameParameters.get("web.ref.abs.path.id"));
            if ((noQuotes.startsWith("/") || noQuotes.startsWith("\\")) && (actualDocRoot = ComponentUtilities.getServerContextRoot((IProject)(targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)targetPath)).getProject())) != null) {
                IPath linkPath;
                Path origPath;
                if (actualDocRoot.startsWith("/")) {
                    actualDocRoot = actualDocRoot.substring(1);
                }
                if ((origPath = new Path(noQuotes)).segmentCount() > 1 && !origPath.segment(0).equals(actualDocRoot) && (linkPath = this.getWebAppRootRelativePath((IPath)targetPath)) != null) {
                    linkPath = noQuotes.startsWith("/") || noQuotes.startsWith("\\") ? linkPath.makeAbsolute() : linkPath.makeRelative();
                    newString = linkPath.toString();
                    newString = URIUtil.addURIComponents((String)newString, (IFile)this.getTargetContainer(params), (String)noQuotes);
                }
            }
            if (newString == null) {
                newString = super.renameReference(new RefactoringGeneratorParameters(params.newReferenceTargetContainer, params.reference, params.transformResult, params.renameParameters, params.renameArguments));
            }
            return newString;
        }
        return null;
    }

    public IStatus checkRenameReference(RefactoringGeneratorParameters params) {
        return Status.OK_STATUS;
    }
}

