/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.search;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.references.ui.internal.Activator;
import com.ibm.etools.references.ui.internal.nls.Messages;
import com.ibm.etools.references.ui.internal.search.ReferenceSearchMatch;
import com.ibm.etools.references.ui.internal.search.ReferenceSearchResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class ReferencesSearchQuery
implements ISearchQuery {
    private final SearchScope scope;
    private final ReferenceSearchResult result;
    private final String searchText;
    private final boolean incoming;
    private final ILink subject;
    private final IResource resource;
    private int searchResultSizeLimit = 0;
    private int currentResultSize = 0;

    public ReferencesSearchQuery(SearchScope scope, String searchText, boolean incoming, boolean caseSensitive) {
        this.scope = scope;
        this.searchText = searchText;
        this.subject = null;
        this.resource = null;
        this.incoming = incoming;
        this.result = new ReferenceSearchResult(this);
        this.currentResultSize = 0;
    }

    public ReferencesSearchQuery(SearchScope scope, ILink subject, boolean incoming, boolean caseSensitive) {
        this.scope = scope;
        this.subject = subject;
        this.searchText = null;
        this.resource = null;
        this.incoming = incoming;
        this.result = new ReferenceSearchResult(this);
        this.currentResultSize = 0;
    }

    public ReferencesSearchQuery(SearchScope scope, IResource resource, boolean incoming, boolean caseSensitive) {
        this.scope = scope;
        this.resource = resource;
        this.subject = null;
        this.searchText = null;
        this.incoming = incoming;
        this.result = new ReferenceSearchResult(this);
        this.currentResultSize = 0;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        String text = null;
        if (this.subject != null) {
            text = this.subject.getName();
            if (text == null) {
                text = this.subject.getLinkText();
            }
            if (text == null) {
                text = this.subject.getContextText();
            }
            if (text == null) {
                text = Messages.unspecified;
            }
        } else {
            text = this.resource != null ? this.resource.getFullPath().toString() : this.searchText;
        }
        String inOrOutString = this.incoming ? Messages.IncomingLinksToXwhereSourceFromY : Messages.OutgoingLinksFromXwhereSourceFromY;
        inOrOutString = NLS.bind((String)inOrOutString, (Object)text, (Object)this.scope.toString());
        if (text == null || text.length() == 0) {
            inOrOutString = this.incoming ? Messages.all_incoming_links_contained_within_X : Messages.all_outgoing_links_contained_witihin_x;
            inOrOutString = NLS.bind((String)inOrOutString, (Object)this.scope.toString());
        }
        return inOrOutString;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        block15: {
            block16: {
                block14: {
                    this.searchResultSizeLimit = Activator.getDefault().getPreferenceStore().getInt("com.ibm.etools.references.ui.search.displayLimit");
                    this.result.removeAll();
                    this.currentResultSize = 0;
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
                    if (this.searchText == null) break block14;
                    String actualSearchString = null;
                    actualSearchString = this.searchText.indexOf(42) == -1 ? String.valueOf('*') + this.searchText + '*' : this.searchText;
                    int patternStyle = actualSearchString.indexOf(42) >= 0 || actualSearchString.indexOf(63) >= 0 ? 2 : 0;
                    SearchPattern pattern = SearchPattern.createPattern((String)actualSearchString, (SearchType)SearchType.BY_LINKTEXT, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)patternStyle);
                    DefaultSearchRequestor requestor = new DefaultSearchRequestor();
                    new SearchEngine().search(pattern, this.scope, (SearchRequestor)requestor, (IProgressMonitor)sub.newChild(1));
                    HashSet<ILink> resultLinks = new HashSet<ILink>();
                    Set links = requestor.getMatches();
                    if (this.incoming) {
                        for (ILink link : links) {
                            Collection references = link.resolveIncomingReference(null, null);
                            for (IResolvedReference resolvedReference : references) {
                                resultLinks.add(resolvedReference.getSource());
                            }
                        }
                    } else {
                        resultLinks.addAll(links);
                    }
                    for (ILink link : resultLinks) {
                        this.addMatch(link);
                    }
                    break block15;
                }
                if (this.resource == null) break block16;
                LinkNode ln = ReferenceManager.getReferenceManager().getLinkNode(this.resource);
                if (this.incoming) {
                    Collection links = ln.getIncomingLinks(monitor, SpecializedType.Depth.INFINITE, this.scope);
                    for (ILink link : links) {
                        this.addMatch(link);
                    }
                } else {
                    Collection links = ln.getLinks(null, SpecializedType.Depth.INFINITE, monitor);
                    for (ILink link : links) {
                        Collection rrs = link.resolveReference(null, monitor);
                        for (IResolvedReference resolvedReference : rrs) {
                            ILink target = resolvedReference.getTarget();
                            if (target == null || target.getContainer() == null || !this.scope.encloses(target.getPath().toString())) continue;
                            this.addMatch(target);
                        }
                    }
                }
                break block15;
            }
            if (this.subject == null) break block15;
            if (this.incoming) {
                Collection rrs = this.subject.resolveIncomingReference(null, this.scope, null);
                for (IResolvedReference rr : rrs) {
                    this.addMatch(rr.getSource());
                }
            } else {
                Collection rrs = this.subject.resolveReference(null, this.scope, null);
                for (IResolvedReference rr : rrs) {
                    this.addMatch(rr.getTarget());
                }
            }
        }
        return Status.OK_STATUS;
    }

    private void addMatch(ILink link) {
        TextRange range;
        if (this.currentResultSize < this.searchResultSizeLimit && link != null && (range = link.getLinkLocation()) != null) {
            this.result.addMatch(new ReferenceSearchMatch(link, range.getOffset(), range.getLength()));
            ++this.currentResultSize;
        }
    }

    public int getTotalResultSize() {
        return this.currentResultSize;
    }
}

