/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.search;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.ui.internal.Activator;
import com.ibm.etools.references.ui.internal.nls.Messages;
import com.ibm.etools.references.ui.internal.search.FileTreeContentProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ReferencesLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String HIGHLIGHT_BG_COLOR_NAME = "org.eclipse.jdt.ui.ColoredLabels.match_highlight";
    public static final StyledString.Styler HIGHLIGHT_STYLE = StyledString.createColorRegistryStyler(null, (String)"org.eclipse.jdt.ui.ColoredLabels.match_highlight");
    private final LocalResourceManager manager;

    public ReferencesLabelProvider(Display display) {
        this.manager = new LocalResourceManager(JFaceResources.getResources((Display)display));
    }

    public Image getImage(Object element) {
        if (element instanceof ILink) {
            Image img = this.manager.createImage(Activator.getImageDescriptor("icons/obj16/link_result.gif"));
            return img;
        }
        if (element instanceof IAdaptable) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
            if (adapter != null && (descriptor = adapter.getImageDescriptor(element)) != null) {
                return this.manager.createImage(descriptor);
            }
        } else if (element == FileTreeContentProvider.EMPTY_INDICATOR) {
            return null;
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        StyledString ss = new StyledString();
        if (element == FileTreeContentProvider.EMPTY_INDICATOR) {
            ss.append(Messages.NoLinksMatched);
        } else if (element instanceof ILink) {
            ILink link = (ILink)element;
            if (ReferenceManager.getReferenceManager().isBuiltIn(link)) {
                ss.append(NLS.bind((String)Messages.ResourceColon, (Object)link.getContainer().getResource().getFullPath().toString()));
            } else {
                int line = link.getLinkLocation().getLinenumber();
                String trimmedString = link.getContextText();
                if (trimmedString == null) {
                    trimmedString = link.getLinkText();
                }
                if (trimmedString == null) {
                    trimmedString = link.getName();
                }
                if (trimmedString == null) {
                    trimmedString = link.getPath().lastSegment();
                }
                trimmedString.length();
                String label = link.getLinkText();
                label = label == null ? "" : label.replaceAll("\n|\r|\t", "");
                trimmedString = trimmedString.replaceAll("\n|\r|\t", "");
                trimmedString = NLS.bind((String)Messages.X_Y, (Object)line, (Object)trimmedString);
                int startOfLabel = trimmedString.indexOf(":") + 1;
                if (startOfLabel >= trimmedString.length()) {
                    ss.append(trimmedString);
                } else {
                    String lineNumber = trimmedString.substring(0, startOfLabel);
                    ss.append(lineNumber, StyledString.QUALIFIER_STYLER);
                    int start = trimmedString.indexOf(label);
                    if (start >= 0 && startOfLabel < start) {
                        String first = trimmedString.substring(startOfLabel, start);
                        String middle = trimmedString.substring(start, start + label.length());
                        String last = trimmedString.substring(start + label.length());
                        ss.append(first);
                        ss.append(middle, HIGHLIGHT_STYLE);
                        ss.append(last);
                    } else {
                        ss.append(trimmedString.substring(startOfLabel));
                    }
                }
            }
        } else if (element instanceof IAdaptable) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
            if (adapter != null) {
                String label = adapter.getLabel(element);
                if (label != null) {
                    ss.append(label);
                }
            } else {
                ss.append(element.toString());
            }
        } else {
            ss.append(element.toString());
        }
        return ss;
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.manager.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

